/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.packet;

import CoroUtil.forge.CoroAI;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

public class PacketHelper {
    @SideOnly(value=Side.CLIENT)
    public static void sendClientPacket(Packet packet) {
        FMLClientHandler.instance().getClient().field_71439_g.field_71174_a.func_147297_a(packet);
    }

    public static void writeTEntToPacket(TileEntity tEnt, NBTTagCompound nbt) {
        try {
            nbt.func_74768_a("dimID", tEnt.func_145831_w().field_73011_w.field_76574_g);
            nbt.func_74768_a("x", tEnt.field_145851_c);
            nbt.func_74768_a("y", tEnt.field_145848_d);
            nbt.func_74768_a("z", tEnt.field_145849_e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FMLProxyPacket createPacketForNBTHandler(String parChannel, String packetChannel, NBTTagCompound parNBT) {
        ByteBuf byteBuf = Unpooled.buffer();
        try {
            ByteBufUtils.writeUTF8String((ByteBuf)byteBuf, (String)parChannel);
            ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)parNBT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new FMLProxyPacket(byteBuf, packetChannel);
    }

    public static FMLProxyPacket createPacketForTEntDWClient(TileEntity tEnt, String name, Object val) {
        CoroAI.dbg("createPacketForTEntDWClient incomplete");
        ByteBuf byteBuf = Unpooled.buffer();
        return new FMLProxyPacket(byteBuf, CoroAI.eventChannelName);
    }

    public static FMLProxyPacket createPacketForTEntDWServer(TileEntity tEnt) {
        CoroAI.dbg("createPacketForTEntDWServer incomplete");
        ByteBuf byteBuf = Unpooled.buffer();
        return new FMLProxyPacket(byteBuf, CoroAI.eventChannelName);
    }

    public static FMLProxyPacket createPacketForTEntCommand(TileEntity tEnt, NBTTagCompound data) {
        ByteBuf byteBuf = Unpooled.buffer();
        NBTTagCompound nbtSendData = new NBTTagCompound();
        try {
            nbtSendData.func_74778_a("command", "CoroAI_TEntCmd");
            nbtSendData.func_74768_a("dimID", tEnt.func_145831_w().field_73011_w.field_76574_g);
            nbtSendData.func_74768_a("x", tEnt.field_145851_c);
            nbtSendData.func_74768_a("y", tEnt.field_145848_d);
            nbtSendData.func_74768_a("z", tEnt.field_145849_e);
            nbtSendData.func_74782_a("data", (NBTBase)data);
            ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)nbtSendData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new FMLProxyPacket(byteBuf, CoroAI.eventChannelName);
    }

    public static NBTTagCompound readNBTTagCompound(ByteBuf fullBuffer) throws IOException {
        short short1 = fullBuffer.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        fullBuffer.readBytes(abyte);
        return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
    }

    public static FMLProxyPacket getNBTPacket(NBTTagCompound parNBT, String parChannel) {
        ByteBuf byteBuf = Unpooled.buffer();
        try {
            ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)parNBT);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new FMLProxyPacket(byteBuf, parChannel);
    }

    public static FMLProxyPacket getPacketForRelativeMotion(Entity ent, double motionX, double motionY, double motionZ) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("command", "Ent_Motion");
        data.func_74768_a("entityID", ent.func_145782_y());
        data.func_74780_a("motionX", motionX);
        data.func_74780_a("motionY", motionY);
        data.func_74780_a("motionZ", motionZ);
        return PacketHelper.getNBTPacket(data, CoroAI.eventChannelName);
    }
}

