/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.componentAI.jobSystem;

import CoroUtil.componentAI.AIAgent;
import CoroUtil.componentAI.jobSystem.JobBase;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;

public class JobManager {
    public AIAgent ai = null;
    public ArrayList<JobBase> curJobs = new ArrayList();
    public JobBase priJob;
    public JobBase lastJobRun;
    public int lastJobRunID;
    public String debug = "";

    public JobManager(AIAgent entRef) {
        this.ai = entRef;
    }

    public boolean hookHit(DamageSource par1DamageSource, int par2) {
        boolean result = true;
        for (int i = 0; i < this.curJobs.size(); ++i) {
            JobBase job = this.curJobs.get(i);
            if (job.hookHit(par1DamageSource, par2)) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean hookInteract(EntityPlayer par1EntityPlayer) {
        boolean result = true;
        for (int i = 0; i < this.curJobs.size(); ++i) {
            JobBase job = this.curJobs.get(i);
            if (job.hookInteract(par1EntityPlayer)) continue;
            result = false;
            break;
        }
        return result;
    }

    public void tick() {
        this.debug = "";
        for (int i = 0; i < this.curJobs.size(); ++i) {
            JobBase job = this.curJobs.get(i);
            if (job.shouldExecute()) {
                this.debug = this.debug + job.toString() + " | ";
                job.tick();
                this.lastJobRun = this.curJobs.get(i);
                this.lastJobRunID = i;
            }
            if (!job.shouldContinue()) break;
        }
    }

    public void addPrimaryJob(JobBase job) {
        this.priJob = job;
        this.addJob(job, -1);
    }

    public JobBase getPrimaryJob() {
        return this.priJob;
    }

    public JobBase getFirstJobByClass(Class clazz) {
        for (int i = 0; i < this.curJobs.size(); ++i) {
            JobBase job = this.curJobs.get(i);
            if (!clazz.isAssignableFrom(job.getClass())) continue;
            return job;
        }
        return null;
    }

    public void addJob(JobBase newJob) {
        this.addJob(newJob, -1);
    }

    public void addJob(JobBase newJob, int priority) {
        if (priority != -1) {
            this.curJobs.add(priority, newJob);
        } else {
            this.curJobs.add(newJob);
        }
    }

    public void clearJobs() {
        this.curJobs.clear();
    }

    public void cleanup() {
        for (int i = 0; i < this.curJobs.size(); ++i) {
            JobBase job = this.curJobs.get(i);
            job.cleanup();
        }
        this.clearJobs();
        this.ai = null;
    }
}

