/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fossilsarcheology.Revival;
import fossilsarcheology.api.EnumDiet;
import fossilsarcheology.api.FoodMappings;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.entity.TileEntityFeeder;
import fossilsarcheology.server.entity.EntityDinosaurEgg;
import fossilsarcheology.server.entity.EntityPrehistoricSwimming;
import fossilsarcheology.server.entity.EntityToyBase;
import fossilsarcheology.server.entity.IPrehistoricAI;
import fossilsarcheology.server.entity.mob.EntitySpinosaurus;
import fossilsarcheology.server.entity.mob.Flock;
import fossilsarcheology.server.enums.EnumAnimation;
import fossilsarcheology.server.enums.EnumDinoBones;
import fossilsarcheology.server.enums.EnumMobType;
import fossilsarcheology.server.enums.EnumOrderType;
import fossilsarcheology.server.enums.EnumPrehistoric;
import fossilsarcheology.server.enums.EnumPrehistoricAI;
import fossilsarcheology.server.enums.EnumPrehistoricMood;
import fossilsarcheology.server.enums.EnumSituation;
import fossilsarcheology.server.enums.EnumTimePeriod;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.message.MessageFoodParticles;
import fossilsarcheology.server.message.MessageHappyParticles;
import fossilsarcheology.server.message.MessageSetDay;
import fossilsarcheology.server.message.MessageUpdateEgg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.ilexiconn.llibrary.client.model.tools.ChainBuffer;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.AnimationHandler;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public abstract class EntityPrehistoric
extends EntityTameable
implements IPrehistoricAI,
IAnimatedEntity {
    public Animation SPEAK_ANIMATION;
    public Animation ATTACK_ANIMATION;
    public float minSize;
    public float maxSize;
    public int teenAge;
    public EnumPrehistoric type;
    public ItemStack ItemInMouth = null;
    public EnumOrderType currentOrder;
    public boolean hasFeatherToggle = false;
    public boolean featherToggle;
    public boolean hasTeenTexture = false;
    public boolean hasBabyTexture;
    public float weakProgress;
    public float sitProgress;
    public int ticksSitted;
    protected boolean isSitting;
    public float sleepProgress;
    public float climbProgress;
    public int ticksSlept;
    protected boolean isSleeping;
    protected boolean developsResistance;
    protected boolean breaksBlocks;
    private Animation currentAnimation;
    private int animTick;
    @SideOnly(value=Side.CLIENT)
    public ChainBuffer chainBuffer;
    public float pediaScale;
    public boolean mood_nospace;
    public boolean mood_noplants;
    protected int nearByMobsAllowed;
    public int ticksTillPlay;
    public int ticksTillMate;
    public int prevAge;
    public boolean isDaytime;
    public Flock flockObj;
    public double baseDamage;
    public double maxDamage;
    public double baseHealth;
    public double maxHealth;
    public double baseSpeed;
    public double maxSpeed;
    public float ridingXZ;
    public float ridingY;
    public float actualWidth;

    public EntityPrehistoric(World world, EnumPrehistoric type, double baseDamage, double maxDamage, double baseHealth, double maxHealth, double baseSpeed, double maxSpeed) {
        super(world);
        this.setHunger(this.getMaxHunger() / 2);
        this.func_98055_j(this.getAgeScale());
        this.SPEAK_ANIMATION = Animation.create((int)this.getSpeakLength());
        this.ATTACK_ANIMATION = Animation.create((int)this.getAttackLength());
        this.hasBabyTexture = true;
        this.type = type;
        this.pediaScale = 1.0f;
        this.nearByMobsAllowed = 15;
        this.currentOrder = EnumOrderType.WANDER;
        if (this.ticksTillMate == 0) {
            this.ticksTillMate = this.field_70146_Z.nextInt(6000) + 6000;
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.chainBuffer = new ChainBuffer();
        }
        this.baseDamage = baseDamage;
        this.maxDamage = maxDamage;
        this.baseHealth = baseHealth;
        this.maxHealth = maxHealth;
        this.baseSpeed = baseSpeed;
        this.maxSpeed = maxSpeed;
        this.updateAbilities();
    }

    public static boolean isCannibalistic() {
        return false;
    }

    public int getSpeakLength() {
        return 20;
    }

    public int getAttackLength() {
        return 20;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)30);
        this.field_70180_af.func_75682_a(20, (Object)1);
        this.field_70180_af.func_75682_a(21, (Object)-1);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)"");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("AgeTick", this.getAgeInTicks());
        compound.func_74768_a("Hunger", this.getHunger());
        compound.func_74757_a("isModelized", this.isSkeleton());
        compound.func_74757_a("Angry", this.isAngry());
        compound.func_74768_a("SubSpecies", this.getSubSpecies());
        compound.func_74768_a("Gender", this.getGender());
        compound.func_74757_a("Sleeping", this.isSleeping);
        compound.func_74768_a("Mood", this.getMood());
        compound.func_74757_a("Sitting", this.isSitting);
        compound.func_74757_a("MoodNoSpace", this.mood_nospace);
        compound.func_74757_a("MoodNoPlants", this.mood_noplants);
        compound.func_74768_a("TicksSincePlay", this.ticksTillPlay);
        compound.func_74768_a("TicksSinceMate", this.ticksTillMate);
        compound.func_74774_a("Order", (byte)this.currentOrder.ordinal());
        compound.func_74778_a("OwnerDisplayName", this.getOwnerDisplayName());
    }

    public String getOwnerDisplayName() {
        return this.field_70180_af.func_75681_e(26);
    }

    public void setOwnerDisplayName(String displayName) {
        this.field_70180_af.func_75692_b(26, (Object)displayName);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setAgeinTicks(compound.func_74762_e("AgeTick"));
        this.setHunger(compound.func_74762_e("Hunger"));
        this.setSkeleton(compound.func_74767_n("isModelized"));
        this.setAngry(compound.func_74767_n("Angry"));
        this.setSubSpecies(compound.func_74762_e("SubSpecies"));
        this.setGender(compound.func_74762_e("Gender"));
        this.setSleeping(compound.func_74767_n("Sleeping"));
        this.func_70904_g(compound.func_74767_n("Sitting"));
        this.setMood(compound.func_74762_e("Mood"));
        this.setOrder(EnumOrderType.values()[compound.func_74771_c("currentOrder")]);
        this.mood_nospace = compound.func_74767_n("MoodNoSpace");
        this.mood_noplants = compound.func_74767_n("MoodNoPlants");
        this.ticksTillPlay = compound.func_74762_e("TicksSincePlay");
        this.ticksTillMate = compound.func_74762_e("TicksSinceMate");
        this.currentOrder = EnumOrderType.values()[compound.func_74771_c("Order")];
        String s = "";
        if (compound.func_150297_b("Owner", 8)) {
            s = compound.func_74779_i("Owner");
            this.setOwnerDisplayName(s);
        } else {
            this.setOwnerDisplayName(compound.func_74779_i("OwnerDisplayName"));
        }
    }

    public AxisAlignedBB getAttackBounds() {
        return this.field_70121_D.func_72314_b(3.0, 3.0, 3.0);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        Random random = new Random();
        this.setAgeInDays(this.getAdultAge());
        this.setSpawnValues();
        this.setGender(random.nextInt(2));
        this.updateAbilities();
        this.ticksTillPlay = 0;
        this.ticksTillMate = 24000;
        this.func_70691_i(this.func_110138_aP());
        return data;
    }

    public void setActualSize(float width, float height) {
        this.actualWidth = width;
        this.func_70105_a(width, height);
    }

    public boolean func_70650_aV() {
        return !this.isSkeleton();
    }

    public void doPlayBonus(int playBonus) {
        this.ticksTillPlay = this.field_70146_Z.nextInt(600) + 600;
        this.setMood(this.getMood() + playBonus);
        Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageHappyParticles(this.func_145782_y()));
    }

    public abstract void setSpawnValues();

    public EnumOrderType getOrderType() {
        return this.currentOrder;
    }

    public boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.func_70906_o() || this.isSleeping() || this.isSkeleton() || this.isActuallyWeak();
    }

    public boolean func_70906_o() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSitting;
            boolean bl = isSitting = (this.field_70180_af.func_75683_a(16) & 1) != 0;
            if (isSitting != this.isSitting) {
                this.ticksSitted = 0;
            }
            this.isSitting = isSitting;
            return isSitting;
        }
        return this.isSitting;
    }

    public boolean isSleeping() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSleeping;
            boolean bl = isSleeping = (this.field_70180_af.func_75683_a(23) & 1) != 0;
            if (isSleeping != this.isSleeping) {
                this.ticksSlept = 0;
            }
            this.isSleeping = isSleeping;
            return isSleeping;
        }
        return this.isSleeping;
    }

    public Vec3 getBlockToEat(int range) {
        for (int r = 1; r <= range; ++r) {
            int z;
            int y;
            int x;
            int dy;
            int ds;
            for (ds = -r; ds <= r; ++ds) {
                for (dy = 4; dy > -5; --dy) {
                    x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds));
                    y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy));
                    z = MathHelper.func_76128_c((double)(this.field_70161_v - (double)r));
                    if (this.field_70163_u + (double)dy >= 0.0 && this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K() && FoodMappings.INSTANCE.getBlockFoodAmount(this.field_70170_p.func_147439_a(x, y, z), this.type.diet) != 0) {
                        Vec3 pos = Vec3.func_72443_a((double)x, (double)y, (double)z);
                        return pos;
                    }
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || FoodMappings.INSTANCE.getBlockFoodAmount(this.field_70170_p.func_147439_a(x, y, z), this.type.diet) == 0) continue;
                    Vec3 pos = Vec3.func_72443_a((double)x, (double)y, (double)z);
                    return pos;
                }
            }
            for (ds = -r + 1; ds <= r - 1; ++ds) {
                for (dy = 4; dy > -5; --dy) {
                    x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds));
                    y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy));
                    z = MathHelper.func_76128_c((double)(this.field_70161_v - (double)r));
                    if (this.field_70163_u + (double)dy >= 0.0 && this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K() && FoodMappings.INSTANCE.getBlockFoodAmount(this.field_70170_p.func_147439_a(x, y, z), this.type.diet) != 0) {
                        Vec3 pos = Vec3.func_72443_a((double)x, (double)y, (double)z);
                        return pos;
                    }
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || FoodMappings.INSTANCE.getBlockFoodAmount(this.field_70170_p.func_147439_a(x, y, z), this.type.diet) == 0) continue;
                    Vec3 pos = Vec3.func_72443_a((double)x, (double)y, (double)z);
                    return pos;
                }
            }
        }
        return null;
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && !(this instanceof IMob) && this.func_70909_n();
    }

    public void setOrder(EnumOrderType var1) {
        this.currentOrder = var1;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public TileEntityFeeder getNearestFeeder(int feederRange) {
        for (int dx = -2; dx != -(feederRange + 1); dx += dx < 0 ? dx * -2 : -(2 * dx + 1)) {
            for (int dy = -5; dy < 4; ++dy) {
                for (int dz = -2; dz != -(feederRange + 1); dz += dz < 0 ? dz * -2 : -(2 * dz + 1)) {
                    TileEntity feeder;
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || (feeder = this.field_70170_p.func_147438_o(MathHelper.func_76128_c((double)(this.field_70165_t + (double)dx)), MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy)), MathHelper.func_76128_c((double)(this.field_70161_v + (double)dz)))) == null || !(feeder instanceof TileEntityFeeder) || ((TileEntityFeeder)feeder).isEmpty(this.type)) continue;
                    return (TileEntityFeeder)feeder;
                }
            }
        }
        return null;
    }

    public float getActualWidth() {
        return this.actualWidth * this.getAgeScale();
    }

    public boolean arePlantsNearby(int range) {
        for (int r = 1; r <= range; ++r) {
            int z;
            int y;
            int x;
            int dy;
            int ds;
            for (ds = -r; ds <= r; ++ds) {
                for (dy = 4; dy > -5; --dy) {
                    x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds));
                    y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy));
                    z = MathHelper.func_76128_c((double)(this.field_70161_v - (double)r));
                    if (this.field_70163_u + (double)dy >= 0.0 && this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K() && this.isPlantBlock(this.field_70170_p.func_147439_a(x, y, z))) {
                        return true;
                    }
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || !this.isPlantBlock(this.field_70170_p.func_147439_a(x, y, z))) continue;
                    return true;
                }
            }
            for (ds = -r + 1; ds <= r - 1; ++ds) {
                for (dy = 4; dy > -5; --dy) {
                    x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds));
                    y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy));
                    z = MathHelper.func_76128_c((double)(this.field_70161_v - (double)r));
                    if (this.field_70163_u + (double)dy >= 0.0 && this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K() && this.isPlantBlock(this.field_70170_p.func_147439_a(x, y, z))) {
                        return true;
                    }
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || !this.isPlantBlock(this.field_70170_p.func_147439_a(x, y, z))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_70104_M() {
        return !this.isSkeleton() && super.func_70104_M();
    }

    public int getNearestBubbleBlock(int range, int type) {
        for (int r = 1; r <= range; ++r) {
            for (int ds = -r; ds <= r; ++ds) {
                for (int dy = 4; dy > -5; --dy) {
                    int x = MathHelper.func_76128_c((double)(this.field_70165_t + (double)ds));
                    int y = MathHelper.func_76128_c((double)(this.field_70163_u + (double)dy));
                    int z = MathHelper.func_76128_c((double)(this.field_70161_v - (double)r));
                    if (this.field_70163_u + (double)dy >= 0.0 && this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K() && this.field_70170_p.func_147439_a(x, y, z) == FABlockRegistry.INSTANCE.bubbleMachine && this.field_70170_p.func_72864_z(x, y, z)) {
                        switch (type) {
                            case 0: {
                                return x;
                            }
                            case 1: {
                                return y;
                            }
                            case 2: {
                                return z;
                            }
                        }
                    }
                    if (!(this.field_70163_u + (double)dy >= 0.0) || !(this.field_70163_u + (double)dy <= (double)this.field_70170_p.func_72800_K()) || this.field_70170_p.func_147439_a(x, y, z) != FABlockRegistry.INSTANCE.bubbleMachine || !this.field_70170_p.func_72864_z(x, y, z)) continue;
                    switch (type) {
                        case 0: {
                            return x;
                        }
                        case 1: {
                            return y;
                        }
                        case 2: {
                            return z;
                        }
                    }
                }
            }
        }
        return 0;
    }

    public boolean isPlantBlock(Block block) {
        return block.func_149688_o() == Material.field_151577_b || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151584_j;
    }

    public boolean canSleep() {
        return (this.field_70122_E || this.field_70173_aa % 20 == 0) && !this.func_70090_H() && (this.aiActivityType() == EnumPrehistoricAI.Activity.DIURINAL && !this.isDaytime() || this.aiActivityType() == EnumPrehistoricAI.Activity.NOCTURNAL && this.isDaytime() && !this.field_70170_p.func_72937_j(MathHelper.func_76128_c((double)this.field_70165_t), (int)this.field_70121_D.field_72338_b, MathHelper.func_76128_c((double)this.field_70161_v)) || this.aiActivityType() == EnumPrehistoricAI.Activity.BOTH && this.func_70681_au().nextInt(600) == 0);
    }

    public boolean isDaytime() {
        if (this.field_70170_p.field_72995_K) {
            return this.isDaytime;
        }
        Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageSetDay(this.func_145782_y(), this.field_70170_p.func_72935_r()));
        return this.field_70170_p.func_72935_r();
    }

    public void func_70636_d() {
        if (!this.isSkeleton()) {
            boolean inital_mood_nospace;
            boolean inital_mood_noplants;
            super.func_70636_d();
            if (this.func_70902_q() != null && this.getOwnerDisplayName().equals("")) {
                this.setOwnerDisplayName(this.func_70902_q().func_70005_c_());
            }
            if (this.getHunger() > this.getMaxHunger()) {
                this.setHunger(this.getMaxHunger());
            }
            if (this.getMood() > 100) {
                this.setMood(100);
            }
            if (this.getMood() < -100) {
                this.setMood(-100);
            }
            if (this.ticksTillPlay > 0) {
                --this.ticksTillPlay;
            }
            if (this.ticksTillMate > 0) {
                --this.ticksTillMate;
            }
            if (this.getRidingPlayer() != null) {
                this.field_70138_W = 1.0f;
            }
            int blockX = MathHelper.func_76128_c((double)this.field_70165_t);
            int blockY = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1;
            int blockZ = MathHelper.func_76128_c((double)this.field_70161_v);
            if (this.getBlockUnder() == FABlockRegistry.INSTANCE.bubbleMachine && this.field_70170_p.func_72864_z(blockX, blockY, blockZ) && this.ticksTillPlay == 0) {
                this.func_70664_aZ();
                for (int i = 0; i < 1; ++i) {
                    double dd = this.func_70681_au().nextGaussian() * 0.02;
                    double dd1 = this.func_70681_au().nextGaussian() * 0.02;
                    double dd2 = this.func_70681_au().nextGaussian() * 0.02;
                    Revival.PROXY.spawnPacketHeartParticles(this.field_70170_p, (float)(this.field_70165_t + (double)(this.func_70681_au().nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N), (float)(this.field_70163_u + 0.5 + (double)(this.func_70681_au().nextFloat() * this.field_70131_O)), (float)(this.field_70161_v + (double)(this.func_70681_au().nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N), dd, dd1, dd2);
                }
                this.doPlayBonus(15);
            }
            if (this.ticksTillMate == 0 && this.getGender() == 1) {
                this.mate();
            }
            if (!this.arePlantsNearby(16) && !this.mood_noplants && this.field_70173_aa % 1200 == 0) {
                inital_mood_noplants = this.mood_noplants;
                this.mood_noplants = true;
                if (this.mood_noplants != inital_mood_noplants) {
                    this.setMood(this.getMood() - 50);
                }
            }
            if (this.arePlantsNearby(16) && this.field_70173_aa % 1200 == 0) {
                inital_mood_noplants = this.mood_noplants;
                this.mood_noplants = false;
                if (this.mood_noplants != inital_mood_noplants) {
                    this.setMood(this.getMood() + 50);
                }
            }
            if (this.isThereNearbyTypes() && !this.mood_nospace && this.field_70173_aa % 1200 == 0) {
                inital_mood_nospace = this.mood_nospace;
                this.mood_nospace = true;
                if (this.mood_nospace != inital_mood_nospace) {
                    this.setMood(this.getMood() - 50);
                }
            }
            if (!this.isThereNearbyTypes() && this.field_70173_aa % 1200 == 0) {
                inital_mood_nospace = this.mood_nospace;
                this.mood_nospace = false;
                if (this.mood_nospace != inital_mood_nospace) {
                    this.setMood(this.getMood() + 50);
                }
            }
            if (this.func_70906_o()) {
                ++this.ticksSitted;
            }
            if (this.isSleeping()) {
                ++this.ticksSlept;
            }
            if (!(this.field_70170_p.field_72995_K || this.func_70090_H() || this.field_70153_n != null || this.func_70906_o() || this.func_70681_au().nextInt(100) != 1 || this.func_70115_ae() || this.getAnimation() != NO_ANIMATION && this.getAnimation() != this.SPEAK_ANIMATION || this.isSleeping())) {
                this.func_70904_g(true);
                this.ticksSitted = 0;
            }
            if (!this.field_70170_p.field_72995_K && !this.func_70090_H() && (this.func_70906_o() && this.ticksSitted > 100 && this.func_70681_au().nextInt(100) == 1 || this.func_70638_az() != null) && !this.isSleeping()) {
                this.func_70904_g(false);
                this.ticksSitted = 0;
            }
            if (!(this.field_70170_p.field_72995_K || this.func_70090_H() || this.field_70153_n != null || this.isActuallyWeak() || !this.canSleep() || this.func_70681_au().nextInt(100) != 1 || this.func_70638_az() != null || this.getAnimation() != NO_ANIMATION && this.getAnimation() != this.SPEAK_ANIMATION)) {
                this.func_70904_g(false);
                this.setSleeping(true);
                this.ticksSlept = 0;
            }
            if (!this.field_70170_p.field_72995_K && (!this.canSleep() || this.isActuallyWeak() || this.isSleeping() && this.ticksSlept > 200 && this.func_70681_au().nextInt(1000) == 1 || this.func_70638_az() != null || this.func_70090_H())) {
                this.func_70904_g(false);
                this.setSleeping(false);
                this.ticksSlept = 0;
            }
            if (this.isSleeping() && this.field_70173_aa % 60 == 0) {
                Random rand = new Random();
                double motionY = rand.nextGaussian() * 0.07;
                float f = (float)((double)rand.nextFloat() * (this.field_70121_D.field_72336_d - this.field_70121_D.field_72340_a) + this.field_70121_D.field_72340_a);
                float f1 = (float)((double)rand.nextFloat() * (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) + this.field_70121_D.field_72338_b);
                float f2 = (float)((double)rand.nextFloat() * (this.field_70121_D.field_72334_f - this.field_70121_D.field_72339_c) + this.field_70121_D.field_72339_c);
                Revival.PROXY.spawnSleepParticles(this.field_70170_p, f, f1, f2, 0.0, motionY, 0.0);
            }
            if (this.currentOrder == EnumOrderType.STAY && !this.func_70906_o() && !this.isActuallyWeak()) {
                this.func_70904_g(true);
                this.setSleeping(false);
            }
            if (this.breaksBlocks) {
                this.breakBlock(5.0f);
            }
            if (this.doesFlock() && this.flockObj == null) {
                if (this.getNearbyFlock() != null) {
                    this.getNearbyFlock().flockMembers.add(this);
                } else {
                    this.flockObj = new Flock();
                    this.flockObj.createFlock(this);
                }
            }
            if (this.flockObj != null && this == this.flockObj.flockLeader) {
                this.flockObj.onUpdate();
            }
        } else {
            this.field_70159_w *= 0.0;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= 0.0;
        }
    }

    public EntityLivingBase func_70902_q() {
        return this.field_70170_p.func_72924_a(this.getOwnerDisplayName());
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public Block getBlockUnder() {
        int blockX = MathHelper.func_76128_c((double)this.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1;
        int blockZ = MathHelper.func_76128_c((double)this.field_70161_v);
        return this.field_70170_p.func_147439_a(blockX, blockY, blockZ);
    }

    public EntityPrehistoric findFlockLeader(List<EntityPrehistoric> flock) {
        int index = new Random().nextInt(flock.size());
        return flock.get(index);
    }

    public EntityPlayer getRidingPlayer() {
        if (this.field_70153_n instanceof EntityPlayer) {
            return (EntityPlayer)this.field_70153_n;
        }
        return null;
    }

    public void setRidingPlayer(EntityPlayer player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        player.func_70078_a((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.isSkeleton()) {
            boolean climbing;
            boolean sitting;
            this.setAgeinTicks(this.getAgeInTicks() + 1);
            if (this.getAgeInTicks() % 24000 == 0) {
                this.updateAbilities();
            }
            if (this.getAgeInTicks() % 1200 == 0 && this.getHunger() > 0 && Revival.CONFIG.starvingDinos) {
                this.setHunger(this.getHunger() - 1);
            }
            if ((sitting = this.func_70906_o()) && this.sitProgress < 20.0f) {
                this.sitProgress += 0.5f;
            } else if (!sitting && this.sitProgress > 0.0f) {
                this.sitProgress -= 0.5f;
            }
            boolean sleeping = this.isSleeping();
            if (sleeping && this.sleepProgress < 20.0f) {
                this.sleepProgress += 0.5f;
            } else if (!sleeping && this.sleepProgress > 0.0f) {
                this.sleepProgress -= 0.5f;
            }
            boolean bl = climbing = this.aiClimbType() == EnumPrehistoricAI.Climbing.ARTHROPOD && this.isBesideClimbableBlock() && !this.field_70122_E;
            if (climbing && this.climbProgress < 20.0f) {
                this.climbProgress += 1.0f;
            } else if (!climbing && this.climbProgress > 0.0f) {
                this.climbProgress -= 1.0f;
            }
            boolean weak = this.isActuallyWeak();
            if (weak && this.weakProgress < 20.0f) {
                this.weakProgress += 0.5f;
            } else if (!weak && this.weakProgress > 0.0f) {
                this.weakProgress -= 0.5f;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.aiClimbType() == EnumPrehistoricAI.Climbing.ARTHROPOD) {
                    this.setBesideClimbableBlock(this.field_70123_F);
                } else {
                    this.setBesideClimbableBlock(false);
                }
            }
            Revival.PROXY.calculateChainBuffer(this);
            AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        }
    }

    @Override
    public abstract EnumPrehistoricAI.Activity aiActivityType();

    @Override
    public abstract EnumPrehistoricAI.Attacking aiAttackType();

    @Override
    public abstract EnumPrehistoricAI.Climbing aiClimbType();

    @Override
    public abstract EnumPrehistoricAI.Following aiFollowType();

    @Override
    public abstract EnumPrehistoricAI.Jumping aiJumpType();

    @Override
    public abstract EnumPrehistoricAI.Response aiResponseType();

    @Override
    public abstract EnumPrehistoricAI.Stalking aiStalkType();

    @Override
    public abstract EnumPrehistoricAI.Taming aiTameType();

    @Override
    public abstract EnumPrehistoricAI.Untaming aiUntameType();

    @Override
    public abstract EnumPrehistoricAI.Moving aiMovingType();

    @Override
    public abstract EnumPrehistoricAI.WaterAbility aiWaterAbilityType();

    public abstract int getAdultAge();

    public abstract boolean doesFlock();

    public boolean func_70686_a(Class clazz) {
        return this.getClass() != clazz && clazz != EntityDinosaurEgg.class;
    }

    public float getAgeScale() {
        float step = (this.maxSize - this.minSize) / (float)(this.getAdultAge() * 24000 + 1);
        if (this.getAgeInTicks() > this.getAdultAge() * 24000) {
            return this.minSize + step * (float)this.getAdultAge() * 24000.0f;
        }
        return this.minSize + step * (float)this.getAgeInTicks();
    }

    protected int func_70693_a(EntityPlayer par1EntityPlayer) {
        return MathHelper.func_76141_d((float)(this.type.Exp0 + (float)this.getAgeInDays() * this.type.ExpInc));
    }

    public void updateAbilities() {
        double healthStep = (this.maxHealth - this.baseHealth) / (double)this.getAdultAge();
        double attackStep = (this.maxDamage - this.baseDamage) / (double)this.getAdultAge();
        double speedStep = (this.maxSpeed - this.baseSpeed) / (double)this.getAdultAge();
        if (this.getAgeInDays() <= this.getAdultAge()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.round(this.baseHealth + healthStep * (double)this.getAgeInDays()));
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)Math.round(this.baseDamage + attackStep * (double)this.getAgeInDays()));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.baseSpeed + speedStep * (double)this.getAgeInDays());
            if (this.developsResistance) {
                if (this.isTeen()) {
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
                } else if (this.isAdult()) {
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(2.0);
                } else {
                    this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
                }
            }
        }
    }

    public void breakBlock(float hardness) {
        if (Revival.CONFIG.dinoBlockBreaking && !this.isSkeleton() && this.isAdult() && this.isHungry()) {
            for (int a = (int)Math.round(this.field_70121_D.field_72340_a) - 1; a <= (int)Math.round(this.field_70121_D.field_72336_d) + 1; ++a) {
                for (int b = (int)Math.round(this.field_70121_D.field_72338_b) + 1; b <= (int)Math.round(this.field_70121_D.field_72337_e) + 3 && b <= 127; ++b) {
                    for (int c = (int)Math.round(this.field_70121_D.field_72339_c) - 1; c <= (int)Math.round(this.field_70121_D.field_72334_f) + 1; ++c) {
                        Block block = this.field_70170_p.func_147439_a(a, b, c);
                        if (block instanceof BlockBush || block instanceof BlockLiquid || block == Blocks.field_150357_h || block == FABlockRegistry.INSTANCE.ancientGlass || block == FABlockRegistry.INSTANCE.strongGlass || !(block.func_149712_f(this.field_70170_p, a, b, c) < hardness)) continue;
                        this.field_70159_w *= 0.6;
                        this.field_70179_y *= 0.6;
                        if (block == Blocks.field_150350_a || this.field_70170_p.field_72995_K) continue;
                        this.field_70170_p.func_147480_a(a, b, c, true);
                    }
                }
            }
        }
    }

    public void func_98054_a(boolean child) {
        if (this.field_70173_aa % 20 == 0) {
            this.func_98055_j(this.getAgeScale());
        }
    }

    public Entity createEgg(EntityAgeable entity) {
        Object baby = null;
        if (this.type.type == EnumMobType.MAMMAL) {
            baby = this.type.invokeClass(this.field_70170_p);
        }
        if (this.type.type == EnumMobType.BIRD) {
            baby = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(this.type.birdEggItem));
        }
        if (this.type.type == EnumMobType.DINOSAUR) {
            if (Revival.CONFIG.eggsLikeChickens || this.type.isAquatic()) {
                baby = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(this.type.eggItem));
            } else {
                baby = new EntityDinosaurEgg(this.field_70170_p, this.type);
                ((EntityDinosaurEgg)((Object)baby)).selfType = this.type;
            }
        }
        return baby;
    }

    public boolean isAdult() {
        return this.getAgeInDays() >= this.getAdultAge();
    }

    public boolean isTeen() {
        return this.getAgeInDays() >= this.teenAge && this.getAgeInDays() < this.getAdultAge();
    }

    public boolean func_70631_g_() {
        return this.getAgeInDays() < this.teenAge && !this.isSkeleton();
    }

    public abstract int getMaxHunger();

    public boolean isSkeleton() {
        return this.field_70180_af.func_75683_a(21) >= 0;
    }

    public void setSkeleton(boolean skeleton) {
        this.field_70180_af.func_75692_b(21, (Object)((byte)(skeleton ? 0 : -1)));
    }

    public int getAgeInDays() {
        return this.field_70180_af.func_75679_c(20) / 24000;
    }

    public void setAgeInDays(int days) {
        this.field_70180_af.func_75692_b(20, (Object)(days * 24000));
        this.updateAbilities();
    }

    public int getAgeInTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setAgeinTicks(int ticks) {
        this.field_70180_af.func_75692_b(20, (Object)ticks);
    }

    public int getHunger() {
        return this.field_70180_af.func_75679_c(19);
    }

    public void setHunger(int hunger) {
        if (this.getHunger() > this.getMaxHunger()) {
            this.field_70180_af.func_75692_b(19, (Object)this.getMaxHunger());
        } else {
            this.field_70180_af.func_75692_b(19, (Object)hunger);
        }
    }

    public boolean increaseHunger(int hunger) {
        if (this.getHunger() >= this.getMaxHunger()) {
            return false;
        }
        this.setHunger(this.getHunger() + hunger);
        if (this.getHunger() > this.getMaxHunger()) {
            this.setHunger(this.getMaxHunger());
        }
        this.field_70170_p.func_72956_a((Entity)this, "random.eat", this.func_70599_aP(), this.func_70647_i());
        return true;
    }

    public void func_70074_a(EntityLivingBase var1) {
        super.func_70074_a(var1);
        this.increaseHunger(FoodMappings.INSTANCE.getEntityFoodAmount(var1.getClass(), this.type.diet));
        this.func_70691_i(FoodMappings.INSTANCE.getEntityFoodAmount(var1.getClass(), this.type.diet) / 3);
        this.setMood(this.getMood() + 25);
    }

    public boolean isHungry() {
        return (float)this.getHunger() < (float)this.getMaxHunger() * 0.75f;
    }

    public boolean IsDeadlyHungry() {
        return (float)this.getHunger() < (float)this.getMaxHunger() * 0.25f;
    }

    public void sendStatusMessage(EnumSituation var1) {
        if (this.func_70902_q() != null && this.func_70032_d((Entity)this.func_70902_q()) < 50.0f) {
            String Status1 = StatCollector.func_74838_a((String)("status." + var1.toString() + ".head"));
            String Dino = this.type.toString();
            String Status2 = StatCollector.func_74838_a((String)("status." + var1.toString()));
            ((EntityPlayer)this.func_70902_q()).func_145747_a((IChatComponent)new ChatComponentText(Status1 + Dino + Status2));
        }
    }

    public boolean func_70617_f_() {
        if (this.aiMovingType() == EnumPrehistoricAI.Moving.AQUATIC || this.aiMovingType() == EnumPrehistoricAI.Moving.SEMIAQUATIC) {
            return false;
        }
        return this.aiClimbType() == EnumPrehistoricAI.Climbing.ARTHROPOD && this.isBesideClimbableBlock();
    }

    public boolean isAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setAngry(boolean var1) {
        byte var2 = this.field_70180_af.func_75683_a(16);
        if (var1) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(var2 & 0xFFFFFFFD)));
        }
    }

    public int getSubSpecies() {
        return this.field_70180_af.func_75679_c(20);
    }

    public void setSubSpecies(int var1) {
        this.field_70180_af.func_75692_b(20, (Object)var1);
    }

    public int getGender() {
        return this.field_70180_af.func_75679_c(24);
    }

    public void setGender(int var1) {
        this.field_70180_af.func_75692_b(24, (Object)var1);
    }

    public void setSleeping(boolean sleeping) {
        byte b0 = this.field_70180_af.func_75683_a(23);
        if (sleeping) {
            this.field_70180_af.func_75692_b(23, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_75692_b(23, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.isSleeping = sleeping;
        }
    }

    public int getMood() {
        return this.field_70180_af.func_75679_c(25);
    }

    public void setMood(int var1) {
        this.field_70180_af.func_75692_b(25, (Object)var1);
    }

    public EnumPrehistoricMood getMoodFace() {
        if (this.getMood() == 100) {
            return EnumPrehistoricMood.HAPPY;
        }
        if (this.getMood() >= 50) {
            return EnumPrehistoricMood.CONTENT;
        }
        if (this.getMood() == -100) {
            return EnumPrehistoricMood.ANGRY;
        }
        if (this.getMood() <= -50) {
            return EnumPrehistoricMood.SAD;
        }
        return EnumPrehistoricMood.CALM;
    }

    public int getScaledMood() {
        return (int)(71.0 * -((double)this.getMood() * 0.01));
    }

    public void func_70904_g(boolean sitting) {
        super.func_70904_g(sitting);
        if (!this.field_70170_p.field_72995_K) {
            this.isSitting = sitting;
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean func_70097_a(DamageSource dmg, float i) {
        if (this.isSkeleton()) {
            if (dmg == DamageSource.field_76368_d) {
                return false;
            }
            this.func_85030_a("mob.skeleton.hurt", 0.8f, 1.0f);
            if (!this.field_70170_p.field_72995_K) {
                if (this.type.timeperiod == EnumTimePeriod.CENOZOIC) {
                    this.func_145779_a(FAItemRegistry.INSTANCE.tarfossil, 1);
                } else {
                    this.func_145779_a(FAItemRegistry.INSTANCE.biofossil, 1);
                }
                this.func_70099_a(new ItemStack(Items.field_151103_aS, Math.min(this.getAgeInDays(), this.getAdultAge()), 1), 1.0f);
            }
            this.func_70106_y();
            return false;
        }
        if (this.func_110144_aD() instanceof EntityPlayer && this.func_70902_q() == this.func_110144_aD()) {
            this.func_70903_f(false);
            this.setMood(this.getMood() - 15);
            this.sendStatusMessage(EnumSituation.Betrayed);
        }
        if (i > 0.0f) {
            this.func_70904_g(false);
            this.setSleeping(false);
        }
        if (dmg.func_76346_g() != null) {
            this.setMood(this.getMood() - 5);
        }
        if (this.func_70621_aR() != null && this.getAnimation() != null && this.getAnimation() == NO_ANIMATION && this.field_70170_p.field_72995_K) {
            this.setAnimation(this.SPEAK_ANIMATION);
        }
        super.func_70097_a(dmg, i);
        return super.func_70097_a(dmg, i);
    }

    public static boolean isEntitySmallerThan(Entity entity, float size) {
        if (entity instanceof EntityPrehistoric) {
            return ((EntityPrehistoric)entity).getActualWidth() <= size;
        }
        return entity.field_70130_N <= size;
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75679_c(22) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean isClollided) {
        int b0 = this.field_70180_af.func_75679_c(22);
        b0 = isClollided ? (int)((byte)(b0 | 1)) : (b0 &= 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(22, (Object)b0);
    }

    protected void func_70069_a(float i) {
        if (this.aiClimbType() != EnumPrehistoricAI.Climbing.ARTHROPOD && this.aiMovingType() != EnumPrehistoricAI.Moving.WALKANDGLIDE && this.aiMovingType() != EnumPrehistoricAI.Moving.FLIGHT) {
            super.func_70069_a(i);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (this.isSkeleton()) {
            if (itemstack == null) {
                if (player.func_70093_af()) {
                    this.nudgeEntity(player);
                } else {
                    this.func_70625_a((Entity)player, 360.0f, 360.0f);
                }
            } else if (itemstack.func_77973_b() == Items.field_151103_aS && this.getAgeInDays() < this.getAdultAge()) {
                this.func_85030_a("mob.skeleton.say", 0.8f, 1.0f);
                this.setAgeInDays(this.getAgeInDays() + 1);
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                if (itemstack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
        } else {
            if (itemstack != null && itemstack.func_77973_b() != null && (this.aiTameType() == EnumPrehistoricAI.Taming.GEM && itemstack.func_77973_b() == FAItemRegistry.INSTANCE.gem || this.aiTameType() == EnumPrehistoricAI.Taming.BLUEGEM && itemstack.func_77973_b() == FAItemRegistry.INSTANCE.gem_blue) && !this.func_70909_n() && !this.func_152114_e((EntityLivingBase)player) && this.isActuallyWeak()) {
                this.triggerTamingAcheivement(player);
                this.func_70691_i(200.0f);
                this.setMood(100);
                this.increaseHunger(500);
                this.func_70903_f(true);
                this.func_70778_a(null);
                this.func_70624_b(null);
                this.func_152115_b(player.func_70005_c_());
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            if (itemstack != null) {
                if (itemstack.func_77973_b() == FAItemRegistry.INSTANCE.chickenEssence && !player.field_70170_p.field_72995_K) {
                    if (this.getAgeInDays() < this.getAdultAge() && this.getHunger() > 0 && (Revival.RELEASE_TYPE.enableDebugging() || this.aiTameType() != EnumPrehistoricAI.Taming.GEM && this.aiTameType() != EnumPrehistoricAI.Taming.BLUEGEM) && this.getHunger() > 0) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            --itemstack.field_77994_a;
                        }
                        if (itemstack.field_77994_a <= 0) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo, 1));
                        }
                        Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), Item.func_150891_b((Item)FAItemRegistry.INSTANCE.chickenEssence)));
                        this.setAgeInDays(this.getAgeInDays() + 1);
                        this.setHunger(1 + new Random().nextInt(this.getHunger()));
                        return true;
                    }
                    if (!this.field_70170_p.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"status.essencefail")));
                    }
                    return false;
                }
                if (FoodMappings.INSTANCE.getItemFoodAmount(itemstack, this.type.diet) != 0) {
                    if (!player.field_70170_p.field_72995_K) {
                        if (this.getMaxHunger() > this.getHunger() || this.func_110143_aJ() > this.func_110138_aP() && Revival.CONFIG.healingDinos) {
                            this.setHunger(this.getHunger() + FoodMappings.INSTANCE.getItemFoodAmount(itemstack, this.type.diet));
                            if (!this.field_70170_p.field_72995_K) {
                                this.eatItem(itemstack);
                            }
                            if (Revival.CONFIG.healingDinos) {
                                this.func_70691_i(3.0f);
                            }
                            if (this.getHunger() >= this.getMaxHunger() && this.func_70909_n()) {
                                this.sendStatusMessage(EnumSituation.Full);
                            }
                            --itemstack.field_77994_a;
                            if (this.aiTameType() == EnumPrehistoricAI.Taming.FEEDING && !this.func_70909_n() && this.type.isTameable() && new Random().nextInt(10) == 1) {
                                this.func_70903_f(true);
                                this.func_152115_b(player.func_70005_c_());
                                this.field_70170_p.func_72960_a((Entity)this, (byte)35);
                            }
                            return true;
                        }
                        if (this.ItemInMouth == null) {
                            return true;
                        }
                    }
                    return false;
                }
                if (itemstack.func_77973_b() == Items.field_151058_ca && this.func_110164_bC() && this.func_152114_e((EntityLivingBase)player)) {
                    this.func_110162_b((Entity)player, true);
                    --itemstack.field_77994_a;
                    return true;
                }
                if (FMLCommonHandler.instance().getSide().isClient() && itemstack.func_77973_b() == FAItemRegistry.INSTANCE.dinoPedia) {
                    this.setPedia();
                    player.openGui((Object)Revival.INSTANCE, 4, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                    return true;
                }
                if (itemstack.func_77973_b() == FAItemRegistry.INSTANCE.whip && this.aiTameType() != EnumPrehistoricAI.Taming.NONE && this.isAdult() && !this.field_70170_p.field_72995_K) {
                    if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && this.canBeRidden()) {
                        if (this.getRidingPlayer() == null) {
                            Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), FABlockRegistry.INSTANCE.volcanicRock));
                            this.setOrder(EnumOrderType.WANDER);
                            this.setRidingPlayer(player);
                            this.func_70904_g(false);
                            this.setSleeping(false);
                        } else if (this.getRidingPlayer() == player) {
                            this.func_70031_b(true);
                            Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), FABlockRegistry.INSTANCE.volcanicRock));
                            this.setMood(this.getMood() - 1);
                        }
                    } else if (!this.func_70909_n() && this.aiTameType() != EnumPrehistoricAI.Taming.BLUEGEM && this.aiTameType() != EnumPrehistoricAI.Taming.GEM) {
                        this.setMood(this.getMood() - 1);
                        Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), FABlockRegistry.INSTANCE.volcanicRock));
                        if (this.func_70681_au().nextInt(5) == 0) {
                            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"prehistoric.autotame") + this.func_70005_c_() + StatCollector.func_74838_a((String)"prehistoric.period")));
                            this.setMood(this.getMood() - 25);
                            this.func_70903_f(true);
                            Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), Item.func_150891_b((Item)Items.field_151043_k)));
                            this.func_152115_b(player.func_70005_c_());
                        }
                    }
                    this.func_70904_g(false);
                }
                if (this.getOrderItem() != null && itemstack.func_77973_b() == this.getOrderItem() && this.func_70909_n() && this.getOwnerDisplayName().equals(player.func_70005_c_()) && !player.func_70115_ae()) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70703_bu = false;
                        this.func_70778_a(null);
                        this.currentOrder = EnumOrderType.values()[(this.currentOrder.ordinal() + 1) % 3];
                        this.sendOrderMessage(this.currentOrder);
                    }
                    return true;
                }
            }
        }
        return super.func_70085_c(player);
    }

    public abstract Item getOrderItem();

    private void triggerTamingAcheivement(EntityPlayer player) {
    }

    public boolean isWeak() {
        return this.func_110143_aJ() < 8.0f && this.getAgeInDays() >= this.getAdultAge() && !this.func_70909_n();
    }

    protected void setPedia() {
        Revival.toPedia = this;
    }

    private void sendOrderMessage(EnumOrderType var1) {
        String S = StatCollector.func_74838_a((String)"order.head") + StatCollector.func_74838_a((String)("order." + var1.toString().toLowerCase()));
        this.field_70170_p.func_72924_a(this.getOwnerDisplayName()).func_145747_a((IChatComponent)new ChatComponentText(S));
    }

    public void nudgeEntity(EntityPlayer player) {
        this.func_70634_a(this.field_70165_t + (player.field_70165_t - this.field_70165_t) * (double)0.01f, this.field_70163_u, this.field_70161_v + (player.field_70161_v - this.field_70161_v) * (double)0.01f);
    }

    public ArrayList<Class<? extends Entity>> preyList() {
        return new ArrayList<Class<? extends Entity>>();
    }

    public ArrayList<Class<? extends Entity>> preyBlacklist() {
        return new ArrayList<Class<? extends Entity>>();
    }

    public void playerRoar(EntityPlayer player) {
    }

    public void playerAttack(EntityPlayer player) {
    }

    public void playerJump(EntityPlayer player) {
    }

    public void playerFlyUp(EntityPlayer player) {
    }

    public void playerFlyDown(EntityPlayer player) {
    }

    public String getTexture() {
        String sleeping;
        String gender;
        if (this.isSkeleton()) {
            return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + this.type.toString().toLowerCase() + "_skeleton.png";
        }
        if (this.hasBabyTexture) {
            String sleeping2;
            String gender2;
            boolean isBaby;
            String toggle = this.hasFeatherToggle ? (this.featherToggle ? "feathered/" : "scaled/") : "";
            boolean bl = isBaby = this.func_70631_g_() && this.hasBabyTexture;
            String string = this.hasTeenTexture ? (this.isTeen() ? "_teen" : (isBaby ? "_baby" : (this.getGender() == 0 ? "_female" : "_male"))) : (this.func_70631_g_() ? "_baby" : (gender2 = this.getGender() == 0 ? "_female" : "_male"));
            String string2 = !this.isSleeping() ? (this.isActuallyWeak() ? "_sleeping" : "") : (sleeping2 = "_sleeping");
            String toggleList = this.hasFeatherToggle ? (this.featherToggle ? "_feathered" : "_scaled") : "";
            return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + toggle + this.type.toString().toLowerCase() + gender2 + toggleList + sleeping2 + ".png";
        }
        String toggle = this.hasFeatherToggle ? (this.featherToggle ? "feathered/" : "scaled/") : "";
        String string = gender = this.getGender() == 0 ? "_female" : "_male";
        String string3 = !this.isSleeping() ? (this.isActuallyWeak() ? "_sleeping" : "") : (sleeping = "_sleeping");
        String toggleList = this.hasFeatherToggle ? (this.featherToggle ? "_feathered" : "_scaled") : "";
        return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + toggle + this.type.toString().toLowerCase() + gender + toggleList + sleeping + ".png";
    }

    public boolean func_152114_e(EntityLivingBase entity) {
        if (entity != null) {
            String s = entity.func_70005_c_();
            return s != null && this.getOwnerDisplayName() != null && this.getOwnerDisplayName().equals(s);
        }
        return false;
    }

    public boolean isActuallyWeak() {
        return this.aiTameType() == EnumPrehistoricAI.Taming.BLUEGEM || this.aiTameType() == EnumPrehistoricAI.Taming.GEM ? this.isWeak() : false;
    }

    public int getTailSegments() {
        return 3;
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.field_70154_o != null && this.field_70154_o instanceof EntityPlayer) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u - (double)((EntityPlayer)this.field_70154_o).field_70129_M, this.field_70161_v);
        }
    }

    private double getSpeed() {
        return 0.4;
    }

    public float getMaleSize() {
        return 1.0f;
    }

    public String getOverlayTexture() {
        return "fossil:textures/blank.png";
    }

    public void triggerAnimation(EnumAnimation animation) {
        int animateID = animation.ordinal();
        Revival.PROXY.animate(animateID);
    }

    public int getAnimationTick() {
        return this.animTick;
    }

    public void setAnimationTick(int tick) {
        this.animTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation == null ? NO_ANIMATION : this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{this.SPEAK_ANIMATION, this.ATTACK_ANIMATION};
    }

    public void func_70642_aH() {
        if (!this.isSleeping() && !this.isSkeleton()) {
            super.func_70642_aH();
            if (this.getAnimation() != null && this.getAnimation() == NO_ANIMATION && !this.field_70170_p.field_72995_K) {
                this.setAnimation(this.SPEAK_ANIMATION);
            }
        }
    }

    public void knockbackEntity(Entity knockBackMob, float knockbackStrength, float knockbackStrengthUp) {
        if (!(knockBackMob instanceof EntityToyBase)) {
            knockBackMob.field_70181_x += (double)0.4f;
            EntityPrehistoric.knockBackMob(knockBackMob, 0.25, 0.2, 0.25);
        }
    }

    public static void knockBackMob(Entity entity, double xMotion, double yMotion, double zMotion) {
        entity.field_70160_al = true;
        float f1 = MathHelper.func_76133_a((double)(xMotion * xMotion + zMotion * zMotion));
        entity.field_70159_w /= 2.0;
        entity.field_70181_x /= 2.0;
        entity.field_70179_y /= 2.0;
        entity.field_70159_w -= xMotion / (double)f1;
        entity.field_70181_x += yMotion;
        entity.field_70179_y -= zMotion / (double)f1;
    }

    public void func_152115_b(String name) {
        this.setOwnerDisplayName(name);
        this.field_70180_af.func_75692_b(17, (Object)name);
    }

    public void func_70653_a(Entity entity, float f, double x, double z) {
        if (entity != null && entity instanceof EntityPrehistoric) {
            if (this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e() <= 0.0 && this.field_70122_E) {
                this.field_70133_I = false;
                EntityPrehistoric.knockBackMob(entity, 1.0, 0.4, 1.0);
            }
        } else {
            super.func_70653_a(entity, f, x, z);
        }
    }

    public boolean canDinoHunt(Entity target, boolean hunger) {
        boolean isAnotherDino = target instanceof EntityPrehistoric;
        if (this.type.diet != EnumDiet.HERBIVORE && this.type.diet != EnumDiet.NONE && this.func_70686_a(target.getClass()) && (isAnotherDino ? this.getActualWidth() >= ((EntityPrehistoric)target).getActualWidth() : this.getActualWidth() >= target.field_70130_N)) {
            if (hunger) {
                return this.isHungry() || target instanceof EntityToyBase && this.ticksTillPlay == 0;
            }
            return true;
        }
        return false;
    }

    public boolean isMad() {
        return this.getMoodFace() == EnumPrehistoricMood.SAD;
    }

    public Flock getNearbyFlock() {
        EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)this);
        IEntitySelector targetEntitySelector = new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                return entity instanceof EntityPrehistoric;
            }
        };
        double d0 = 64.0;
        List list = this.field_70170_p.func_82733_a(EntityPrehistoric.class, this.field_70121_D.func_72314_b(d0, 4.0, d0), targetEntitySelector);
        Collections.sort(list, theNearestAttackableTargetSorter);
        if (!list.isEmpty()) {
            for (EntityPrehistoric mob : list) {
                if (mob.type != this.type || mob.flockObj == null || mob.flockObj.flockLeader != mob) continue;
                return mob.flockObj;
            }
        }
        return null;
    }

    public void mate() {
        EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)this);
        IEntitySelector targetEntitySelector = new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                return entity instanceof EntityPrehistoric;
            }
        };
        double d0 = 64.0;
        List list = this.field_70170_p.func_82733_a(EntityPrehistoric.class, this.field_70121_D.func_72314_b(d0, 4.0, d0), targetEntitySelector);
        Collections.sort(list, theNearestAttackableTargetSorter);
        ArrayList<EntityPrehistoric> listOfFemales = new ArrayList<EntityPrehistoric>();
        if (!list.isEmpty()) {
            for (EntityPrehistoric mob : list) {
                if (mob.type != this.type || !mob.isAdult() || mob.getGender() != 0 || mob.ticksTillMate != 0) continue;
                listOfFemales.add(mob);
            }
        }
        if (!listOfFemales.isEmpty() && this.ticksTillMate == 0 && Revival.CONFIG.allowBreeding) {
            EntityPrehistoric prehistoric = (EntityPrehistoric)listOfFemales.get(0);
            if (prehistoric.ticksTillMate == 0) {
                this.func_70661_as().func_75497_a((Entity)prehistoric, 1.0);
                double distance = this.field_70130_N * 8.0f * this.field_70130_N * 8.0f + prehistoric.field_70130_N;
                if (this.func_70092_e(prehistoric.field_70165_t, prehistoric.field_70121_D.field_72338_b, prehistoric.field_70161_v) <= distance && prehistoric.field_70122_E && this.field_70122_E && this.isAdult() && prehistoric.isAdult()) {
                    prehistoric.procreate(this);
                    this.ticksTillMate = this.field_70146_Z.nextInt(6000) + 6000;
                    prehistoric.ticksTillMate = this.field_70146_Z.nextInt(12000) + 24000;
                }
            }
        }
    }

    public abstract boolean canBeRidden();

    public boolean func_82171_bF() {
        return this.canBeRidden() && this.getRidingPlayer() != null && this.func_152114_e((EntityLivingBase)this.getRidingPlayer());
    }

    public void procreate(EntityPrehistoric mob) {
        Entity hatchling;
        for (int i = 0; i < 7; ++i) {
            double dd = this.field_70146_Z.nextGaussian() * 0.02;
            double dd1 = this.field_70146_Z.nextGaussian() * 0.02;
            double dd2 = this.field_70146_Z.nextGaussian() * 0.02;
            Revival.PROXY.spawnPacketHeartParticles(this.field_70170_p, (float)(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N), (float)(this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O)), (float)(this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N), dd, dd1, dd2);
            Revival.PROXY.spawnPacketHeartParticles(mob.field_70170_p, (float)(mob.field_70165_t + (double)(mob.field_70146_Z.nextFloat() * mob.field_70130_N * 2.0f) - (double)mob.field_70130_N), (float)(mob.field_70163_u + 0.5 + (double)(mob.field_70146_Z.nextFloat() * mob.field_70131_O)), (float)(mob.field_70161_v + (double)(mob.field_70146_Z.nextFloat() * mob.field_70130_N * 2.0f) - (double)mob.field_70130_N), dd, dd1, dd2);
        }
        if (this.field_70146_Z.nextInt(15) == 0) {
            this.func_85030_a("fossil:music.mating", 1.0f, 1.0f);
        }
        if ((hatchling = this.createEgg((EntityAgeable)mob)) != null && !this.field_70170_p.field_72995_K) {
            this.field_70789_a = null;
            mob.field_70789_a = null;
            hatchling.func_70080_a(mob.field_70165_t, mob.field_70163_u + 1.0, mob.field_70161_v, mob.field_70177_z, 0.0f);
            if (hatchling instanceof EntityDinosaurEgg) {
                Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdateEgg(hatchling.func_145782_y(), this.type.ordinal()));
            } else if (hatchling instanceof EntityPrehistoric) {
                ((EntityPrehistoric)hatchling).func_110161_a(null);
                ((EntityPrehistoric)hatchling).setAgeInDays(1);
                ((EntityPrehistoric)hatchling).updateAbilities();
                ((EntityPrehistoric)hatchling).func_70606_j((float)this.baseHealth);
            }
            this.field_70170_p.func_72838_d(hatchling);
        }
    }

    public boolean isThereNearbyTypes() {
        EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)this);
        IEntitySelector targetEntitySelector = new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                return entity instanceof EntityPrehistoric;
            }
        };
        double d0 = 64.0;
        List list = this.field_70170_p.func_82733_a(EntityPrehistoric.class, this.field_70121_D.func_72314_b(d0, 4.0, d0), targetEntitySelector);
        Collections.sort(list, theNearestAttackableTargetSorter);
        if (list.isEmpty() || this.doesFlock()) {
            return false;
        }
        ArrayList<EntityPrehistoric> listOfType = new ArrayList<EntityPrehistoric>();
        for (EntityPrehistoric mob : list) {
            if (mob.type != this.type || !mob.isAdult()) continue;
            listOfType.add(mob);
        }
        return listOfType.size() > this.nearByMobsAllowed;
    }

    public void doFoodEffect(Item item) {
        this.func_85030_a("random.eat", this.func_70599_aP(), this.func_70647_i());
        if (item != null) {
            if (item instanceof ItemBlock) {
                this.spawnItemParticle(item, true);
            } else {
                this.spawnItemParticle(item, false);
            }
        }
    }

    public void doFoodEffect() {
        this.func_85030_a("random.eat", this.func_70599_aP(), this.func_70647_i());
        switch (this.type.diet) {
            case HERBIVORE: {
                this.spawnItemParticle(Items.field_151014_N, false);
                break;
            }
            case OMNIVORE: {
                this.spawnItemParticle(Items.field_151025_P, false);
                break;
            }
            case PISCIVORE: {
                this.spawnItemParticle(Items.field_151115_aP, false);
                break;
            }
            default: {
                this.spawnItemParticle(Items.field_151082_bd, false);
            }
        }
    }

    public void spawnItemParticle(Item item, boolean itemBlock) {
        if (!this.field_70170_p.field_72995_K) {
            double motionX = this.field_70146_Z.nextGaussian() * 0.07;
            double motionY = this.field_70146_Z.nextGaussian() * 0.07;
            double motionZ = this.field_70146_Z.nextGaussian() * 0.07;
            float f = (float)((double)this.func_70681_au().nextFloat() * (this.field_70121_D.field_72336_d - this.field_70121_D.field_72340_a) + this.field_70121_D.field_72340_a);
            float f1 = (float)((double)this.func_70681_au().nextFloat() * (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) + this.field_70121_D.field_72338_b);
            float f2 = (float)((double)this.func_70681_au().nextFloat() * (this.field_70121_D.field_72334_f - this.field_70121_D.field_72339_c) + this.field_70121_D.field_72339_c);
            if (itemBlock && item instanceof ItemBlock) {
                Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), Block.func_149682_b((Block)((ItemBlock)item).field_150939_a)));
            } else {
                Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), Item.func_150891_b((Item)item)));
            }
        }
    }

    public boolean isInWaterMaterial() {
        int k;
        int j;
        double d0 = this.field_70163_u;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        Block block = this.field_70170_p.func_147439_a(i, j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d0)), k = MathHelper.func_76128_c((double)this.field_70161_v));
        if (block.func_149688_o() == Material.field_151586_h) {
            double filled = 1.0;
            if (block instanceof IFluidBlock) {
                filled = ((IFluidBlock)block).getFilledPercentage(this.field_70170_p, i, j, k);
            }
            if (filled < 0.0) {
                return d0 > (double)j + (1.0 - (filled *= -1.0));
            }
            return d0 < (double)j + filled;
        }
        return false;
    }

    public void eatItem(ItemStack stack) {
        if (stack != null && stack.field_77994_a > 0 && stack.func_77973_b() != null && FoodMappings.INSTANCE.getItemFoodAmount(stack, this.type.diet) != 0) {
            this.setMood(this.getMood() + 5);
            this.doFoodEffect(stack.func_77973_b());
            Revival.NETWORK_WRAPPER.sendToAll((IMessage)new MessageFoodParticles(this.func_145782_y(), Item.func_150891_b((Item)stack.func_77973_b())));
            this.setHunger(this.getHunger() + FoodMappings.INSTANCE.getItemFoodAmount(stack, this.type.diet));
            --stack.field_77994_a;
        }
    }

    public String getTempermentString() {
        String s = null;
        if (this.aiResponseType() == EnumPrehistoricAI.Response.AGRESSIVE || this.aiResponseType() == EnumPrehistoricAI.Response.WATERAGRESSIVE) {
            s = "agressive";
        } else if (this.aiResponseType() == EnumPrehistoricAI.Response.SCARED) {
            s = "scared";
        } else if (this.aiResponseType() == EnumPrehistoricAI.Response.NONE || this.aiResponseType() == EnumPrehistoricAI.Response.WATERCALM) {
            s = "none";
        } else if (this.aiResponseType() == EnumPrehistoricAI.Response.TERITORIAL) {
            s = "territorial";
        }
        return "pedia.temperament." + s;
    }

    public boolean canRunFrom(Entity entity) {
        if (this.field_70130_N <= entity.field_70130_N) {
            if (entity instanceof EntityPrehistoric) {
                EntityPrehistoric mob = (EntityPrehistoric)entity;
                if (mob.type.diet != EnumDiet.HERBIVORE) {
                    return true;
                }
            } else {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (this.func_70902_q() == player) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected void func_70628_a(boolean bool, int rand) {
        int j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + rand);
        if (this.type.type == EnumMobType.BIRD || this.type.type == EnumMobType.TERRORBIRD) {
            for (int k = 0; k < j; ++k) {
                this.func_145779_a(Items.field_151008_G, 1);
            }
        }
        if (this.func_70027_ad() && this.type.cookedFoodItem != null) {
            this.func_145779_a(this.type.cookedFoodItem, Math.min(this.getAgeInDays(), this.getAdultAge()));
        } else if (this.type.foodItem != null) {
            this.func_145779_a(this.type.foodItem, Math.min(this.getAgeInDays(), this.getAdultAge()));
        }
        if (EnumDinoBones.get(this.type) != null) {
            this.func_70099_a(new ItemStack(FAItemRegistry.INSTANCE.skull, this.field_70146_Z.nextInt(1), EnumDinoBones.get(this.type).ordinal()), 0.0f);
            this.func_70099_a(new ItemStack(FAItemRegistry.INSTANCE.armBone, this.field_70146_Z.nextInt(2), EnumDinoBones.get(this.type).ordinal()), 0.0f);
            this.func_70099_a(new ItemStack(FAItemRegistry.INSTANCE.dinoRibCage, this.field_70146_Z.nextInt(1), EnumDinoBones.get(this.type).ordinal()), 0.0f);
            this.func_70099_a(new ItemStack(FAItemRegistry.INSTANCE.vertebrae, this.field_70146_Z.nextInt(5), EnumDinoBones.get(this.type).ordinal()), 0.0f);
            this.func_70099_a(new ItemStack(FAItemRegistry.INSTANCE.foot, this.field_70146_Z.nextInt(2), EnumDinoBones.get(this.type).ordinal()), 0.0f);
            this.func_70099_a(new ItemStack(FAItemRegistry.INSTANCE.claw, this.field_70146_Z.nextInt(2), EnumDinoBones.get(this.type).ordinal()), 0.0f);
        }
    }

    public double func_70042_X() {
        return 0.0;
    }

    public void func_70043_V() {
        if (this.func_152114_e((EntityLivingBase)this.getRidingPlayer()) && this.func_70638_az() != this.getRidingPlayer()) {
            this.field_70177_z = this.field_70761_aq;
            this.field_70177_z = this.field_70153_n.field_70177_z;
            float radius = this.ridingXZ * (0.7f * this.getAgeScale()) * -3.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = this.ridingY * this.getAgeScale();
            float spinosaurusAddition = 0.0f;
            if (this instanceof EntitySpinosaurus) {
                spinosaurusAddition = -(((EntitySpinosaurus)this).swimProgress * 0.1f);
            }
            this.field_70153_n.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY + (double)spinosaurusAddition, this.field_70161_v + extraZ);
            return;
        }
        super.func_70043_V();
    }

    public EntityAgeable func_90011_a(EntityAgeable entity) {
        Entity baby = this.type.invokeClass(this.field_70170_p);
        if (entity instanceof EntityPrehistoric) {
            ((EntityPrehistoric)baby).func_110161_a(null);
            ((EntityPrehistoric)baby).setAgeInDays(0);
            ((EntityPrehistoric)baby).updateAbilities();
            ((EntityPrehistoric)baby).func_70606_j((float)this.baseHealth);
            return (EntityPrehistoric)baby;
        }
        return null;
    }

    protected String func_70639_aQ() {
        return "fossil:" + this.type.name().toLowerCase() + "_living";
    }

    protected String func_70621_aR() {
        return "fossil:" + this.type.name().toLowerCase() + "_hurt";
    }

    protected String func_70673_aS() {
        return "fossil:" + this.type.name().toLowerCase() + "_death";
    }

    public boolean isAquatic() {
        return this instanceof EntityPrehistoricSwimming;
    }
}

