/*
 * Decompiled with CFR 0.152.
 */
package lumien.extendedpotions;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.lang.reflect.Field;
import lumien.extendedpotions.ErrorHandler;
import lumien.extendedpotions.asm.MCPNames;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="ExtendedPotions", name="Extended Potions", version="1.2", dependencies="before:*")
public class ExtendedPotions {
    @Mod.Instance(value="ExtendedPotions")
    public static ExtendedPotions INSTANCE;
    Logger logger;
    int newPotionSize;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        Configuration configuration = new Configuration(event.getSuggestedConfigurationFile());
        this.newPotionSize = configuration.get("Settings", "PotionIDLimit", 4096, "What should be the new potion id limit (Vanilla is 32)").getInt(4096);
        ErrorHandler.log = configuration.get("Settings", "LogConflicts", true, "Whether Potion ID Conflicts are supposed to be logged to the console. (Otherwise they will be logged to the DEBUG log)").getBoolean(true);
        if (configuration.hasChanged()) {
            configuration.save();
        }
        this.extendPotionArray();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ErrorHandler.displayConflicts();
    }

    private void extendPotionArray() {
        try {
            Field potionTypesField = Potion.class.getDeclaredField(MCPNames.field("field_76425_a"));
            this.makeModifiable(potionTypesField);
            int potionArraySize = Potion.field_76425_a.length;
            if (potionArraySize < this.newPotionSize) {
                Potion[] newArray = new Potion[this.newPotionSize];
                for (int i = 0; i < potionArraySize; ++i) {
                    newArray[i] = Potion.field_76425_a[i];
                }
                potionTypesField.set(null, newArray);
                this.logger.log(Level.INFO, "Extended Potion Array to " + this.newPotionSize);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.INFO, "Could not extend Potion Array");
        }
    }

    private void makeModifiable(Field nameField) throws Exception {
        nameField.setAccessible(true);
        int modifiers = nameField.getModifiers();
        Field modifierField = nameField.getClass().getDeclaredField("modifiers");
        modifierField.setAccessible(true);
        modifierField.setInt(nameField, modifiers &= 0xFFFFFFEF);
    }
}

