/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.features.trees;

import biomesoplenty.api.content.BOPCBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenOriginalTree
extends WorldGenAbstractTree {
    private final int minTreeHeight;
    private final int randomTreeHeight;
    private final boolean vinesGrow;
    private final Block wood;
    private final Block leaves;
    private final int metaWood;
    private int metaLeaves;
    private int metaFruit = -1;

    public WorldGenOriginalTree(Block wood, Block leaves, int metaWood, int metaLeaves) {
        this(wood, leaves, metaWood, metaLeaves, false, 4, 3, false);
    }

    public WorldGenOriginalTree(Block wood, Block leaves, int metaWood, int metaLeaves, int metaFruit) {
        this(wood, leaves, metaWood, metaLeaves, false, 5, 4, false);
        this.metaFruit = metaFruit;
    }

    public WorldGenOriginalTree(Block wood, Block leaves, int metaWood, int metaLeaves, boolean doBlockNotify, int minTreeHeight, int randomTreeHeight, boolean vinesGrow) {
        super(doBlockNotify);
        this.wood = wood;
        this.leaves = leaves;
        this.metaWood = metaWood;
        this.metaLeaves = metaLeaves;
        this.minTreeHeight = minTreeHeight;
        this.randomTreeHeight = randomTreeHeight;
        this.vinesGrow = vinesGrow;
    }

    public boolean func_76484_a(World par1World, Random par2Random, int par3, int par4, int par5) {
        int l = par2Random.nextInt(this.randomTreeHeight) + this.minTreeHeight;
        boolean flag = true;
        if (par4 >= 1 && par4 + l + 1 <= 256) {
            Block block;
            int k1;
            int b0;
            for (int i1 = par4; i1 <= par4 + 1 + l; ++i1) {
                b0 = 1;
                if (i1 == par4) {
                    b0 = 0;
                }
                if (i1 >= par4 + 1 + l - 2) {
                    b0 = 2;
                }
                for (int j1 = par3 - b0; j1 <= par3 + b0 && flag; ++j1) {
                    for (k1 = par5 - b0; k1 <= par5 + b0 && flag; ++k1) {
                        if (i1 >= 0 && i1 < 256) {
                            block = par1World.func_147439_a(j1, i1, k1);
                            if (this.isReplaceable(par1World, j1, i1, k1)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block block2 = par1World.func_147439_a(par3, par4 - 1, par5);
            boolean isSoil = block2.canSustainPlant((IBlockAccess)par1World, par3, par4 - 1, par5, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && par4 < 256 - l - 1) {
                int j2;
                int i2;
                int l1;
                int i3;
                block2.onPlantGrow(par1World, par3, par4 - 1, par5, par3, par4, par5);
                b0 = 3;
                int b1 = 0;
                for (k1 = par4 - b0 + l; k1 <= par4 + l; ++k1) {
                    i3 = k1 - (par4 + l);
                    l1 = b1 + 1 - i3 / 2;
                    for (i2 = par3 - l1; i2 <= par3 + l1; ++i2) {
                        j2 = i2 - par3;
                        for (int k2 = par5 - l1; k2 <= par5 + l1; ++k2) {
                            Block block1;
                            int l2 = k2 - par5;
                            if (Math.abs(j2) == l1 && Math.abs(l2) == l1 && (par2Random.nextInt(2) == 0 || i3 == 0) || !(block1 = par1World.func_147439_a(i2, k1, k2)).isAir((IBlockAccess)par1World, i2, k1, k2) && !block1.isLeaves((IBlockAccess)par1World, i2, k1, k2)) continue;
                            this.func_150516_a(par1World, i2, k1, k2, this.leaves, this.metaLeaves);
                        }
                    }
                }
                for (k1 = 0; k1 < l; ++k1) {
                    block = par1World.func_147439_a(par3, par4 + k1, par5);
                    if (!block.isAir((IBlockAccess)par1World, par3, par4 + k1, par5) && !block.isLeaves((IBlockAccess)par1World, par3, par4 + k1, par5)) continue;
                    this.func_150516_a(par1World, par3, par4 + k1, par5, this.wood, this.metaWood);
                    if (!this.vinesGrow || k1 <= 0) continue;
                    if (par2Random.nextInt(3) > 0 && par1World.func_147437_c(par3 - 1, par4 + k1, par5)) {
                        this.func_150516_a(par1World, par3 - 1, par4 + k1, par5, Blocks.field_150395_bd, 8);
                    }
                    if (par2Random.nextInt(3) > 0 && par1World.func_147437_c(par3 + 1, par4 + k1, par5)) {
                        this.func_150516_a(par1World, par3 + 1, par4 + k1, par5, Blocks.field_150395_bd, 2);
                    }
                    if (par2Random.nextInt(3) > 0 && par1World.func_147437_c(par3, par4 + k1, par5 - 1)) {
                        this.func_150516_a(par1World, par3, par4 + k1, par5 - 1, Blocks.field_150395_bd, 1);
                    }
                    if (par2Random.nextInt(3) <= 0 || !par1World.func_147437_c(par3, par4 + k1, par5 + 1)) continue;
                    this.func_150516_a(par1World, par3, par4 + k1, par5 + 1, Blocks.field_150395_bd, 4);
                }
                if (this.metaFruit > -1) {
                    int fr = par2Random.nextInt(4);
                    for (int fl = 0; fl < fr; ++fl) {
                        int f3;
                        int f2;
                        int f1 = par2Random.nextInt(4);
                        Block fruit = par1World.func_147439_a(par3 - 2 + f1, par4 + (f2 = l - 4), par5 - 2 + (f3 = par2Random.nextInt(4)));
                        if (!fruit.isAir((IBlockAccess)par1World, par3 - 2 + f1, par4 + f2, par5 - 2 + f3) || !par1World.func_147439_a(par3 - 2 + f1, par4 + (f2 + 1), par5 - 2 + f3).isLeaves((IBlockAccess)par1World, par3 - 2 + f1, par4 + (f2 + 1), par5 - 2 + f3)) continue;
                        this.func_150516_a(par1World, par3 - 2 + f1, par4 + f2, par5 - 2 + f3, BOPCBlocks.fruitBop, this.metaFruit);
                    }
                }
                if (this.vinesGrow) {
                    for (k1 = par4 - 3 + l; k1 <= par4 + l; ++k1) {
                        i3 = k1 - (par4 + l);
                        l1 = 2 - i3 / 2;
                        for (i2 = par3 - l1; i2 <= par3 + l1; ++i2) {
                            for (j2 = par5 - l1; j2 <= par5 + l1; ++j2) {
                                if (!par1World.func_147439_a(i2, k1, j2).isLeaves((IBlockAccess)par1World, i2, k1, j2)) continue;
                                if (par2Random.nextInt(4) == 0 && par1World.func_147439_a(i2 - 1, k1, j2).isAir((IBlockAccess)par1World, i2 - 1, k1, j2)) {
                                    this.growVines(par1World, i2 - 1, k1, j2, 8);
                                }
                                if (par2Random.nextInt(4) == 0 && par1World.func_147439_a(i2 + 1, k1, j2).isAir((IBlockAccess)par1World, i2 + 1, k1, j2)) {
                                    this.growVines(par1World, i2 + 1, k1, j2, 2);
                                }
                                if (par2Random.nextInt(4) == 0 && par1World.func_147439_a(i2, k1, j2 - 1).isAir((IBlockAccess)par1World, i2, k1, j2 - 1)) {
                                    this.growVines(par1World, i2, k1, j2 - 1, 1);
                                }
                                if (par2Random.nextInt(4) != 0 || !par1World.func_147439_a(i2, k1, j2 + 1).isAir((IBlockAccess)par1World, i2, k1, j2 + 1)) continue;
                                this.growVines(par1World, i2, k1, j2 + 1, 4);
                            }
                        }
                    }
                    if (par2Random.nextInt(5) == 0 && l > 5) {
                        for (k1 = 0; k1 < 2; ++k1) {
                            for (i3 = 0; i3 < 4; ++i3) {
                                if (par2Random.nextInt(4 - k1) != 0) continue;
                                l1 = par2Random.nextInt(3);
                                this.func_150516_a(par1World, par3 + Direction.field_71583_a[Direction.field_71580_e[i3]], par4 + l - 5 + k1, par5 + Direction.field_71581_b[Direction.field_71580_e[i3]], Blocks.field_150375_by, l1 << 2 | i3);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void growVines(World world, int x, int y, int z, int flag) {
        this.func_150516_a(world, x, y, z, Blocks.field_150395_bd, flag);
        int i1 = 4;
        while (!world.func_147439_a(x, --y, z).isAir((IBlockAccess)world, x, y, z) && i1 > 0) {
            this.func_150516_a(world, x, y, z, Blocks.field_150395_bd, flag);
            --i1;
        }
        return;
    }
}

