/*
 * Decompiled with CFR 0.152.
 */
package radixcore.math;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import radixcore.enums.EnumAxis;
import radixcore.util.RadixMath;

public final class Point3D
implements Comparable {
    public static final Point3D ZERO = new Point3D(0, 0, 0);
    public short sPosX;
    public short sPosY;
    public short sPosZ;
    public int iPosX;
    public int iPosY;
    public int iPosZ;
    public float fPosX;
    public float fPosY;
    public float fPosZ;
    public double dPosX;
    public double dPosY;
    public double dPosZ;

    public Point3D(short posX, short posY, short posZ) {
        this.sPosX = posX;
        this.sPosY = posY;
        this.sPosZ = posZ;
        this.iPosX = posX;
        this.iPosY = posY;
        this.iPosZ = posZ;
        this.fPosX = posX;
        this.fPosY = posY;
        this.fPosZ = posZ;
        this.dPosX = posX;
        this.dPosY = posY;
        this.dPosZ = posZ;
    }

    public Point3D(int posX, int posY, int posZ) {
        this.sPosX = (short)posX;
        this.sPosY = (short)posY;
        this.sPosZ = (short)posZ;
        this.iPosX = posX;
        this.iPosY = posY;
        this.iPosZ = posZ;
        this.fPosX = posX;
        this.fPosX = posY;
        this.fPosX = posZ;
        this.dPosX = posX;
        this.dPosY = posY;
        this.dPosZ = posZ;
    }

    public Point3D(float posX, float posY, float posZ) {
        this.sPosX = (short)posX;
        this.sPosY = (short)posY;
        this.sPosZ = (short)posZ;
        this.iPosX = (int)posX;
        this.iPosY = (int)posY;
        this.iPosZ = (int)posZ;
        this.fPosX = posX;
        this.fPosY = posY;
        this.fPosZ = posZ;
        this.dPosX = posX;
        this.dPosY = posY;
        this.dPosZ = posZ;
    }

    public Point3D(double posX, double posY, double posZ) {
        this.sPosX = (short)posX;
        this.sPosY = (short)posY;
        this.sPosZ = (short)posZ;
        this.iPosX = (int)posX;
        this.iPosY = (int)posY;
        this.iPosZ = (int)posZ;
        this.fPosX = (float)posX;
        this.fPosY = (float)posY;
        this.fPosZ = (float)posZ;
        this.dPosX = posX;
        this.dPosY = posY;
        this.dPosZ = posZ;
    }

    public Point3D setPoint(int posX, int posY, int posZ) {
        return new Point3D(posX, posY, posZ);
    }

    public Point3D setPoint(float posX, float posY, float posZ) {
        return new Point3D(posX, posY, posZ);
    }

    public Point3D setPoint(short posX, short posY, short posZ) {
        return new Point3D(posX, posY, posZ);
    }

    public Point3D setPoint(double posX, double posY, double posZ) {
        return new Point3D(posX, posY, posZ);
    }

    public static Point3D getNearestPointInList(Point3D refPoint, List<Point3D> pointList) {
        Point3D returnPoint = null;
        double lastDistance = 100.0;
        for (Point3D point : pointList) {
            double distanceTo = RadixMath.getDistanceToXYZ(refPoint.iPosX, refPoint.iPosY, refPoint.iPosZ, point.iPosX, point.iPosY, point.iPosZ);
            if (!(distanceTo < lastDistance)) continue;
            returnPoint = point;
            lastDistance = distanceTo;
        }
        return returnPoint;
    }

    public Point3D rotate(EnumAxis axis, float angle) {
        if (axis == EnumAxis.X) {
            return new Point3D(this.dPosX, this.dPosY * Math.cos(angle) - this.dPosZ * Math.sin(angle), this.dPosY * Math.sin(angle) - this.dPosZ * Math.cos(angle));
        }
        if (axis == EnumAxis.Y) {
            return new Point3D(this.dPosZ * Math.sin(angle) - this.dPosX * Math.cos(angle), this.dPosY, this.dPosZ * Math.cos(angle) - this.dPosX * Math.sin(angle));
        }
        if (axis == EnumAxis.Z) {
            return new Point3D(this.dPosX * Math.cos(angle) - this.dPosY * Math.sin(angle), this.dPosX * Math.sin(angle) - this.dPosY * Math.cos(angle), this.dPosZ);
        }
        return ZERO;
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74780_a(name + "dPosX", this.dPosX);
        nbt.func_74780_a(name + "dPosY", this.dPosY);
        nbt.func_74780_a(name + "dPosZ", this.dPosZ);
    }

    public static Point3D readFromNBT(String name, NBTTagCompound nbt) {
        double x = nbt.func_74769_h(name + "dPosX");
        double y = nbt.func_74769_h(name + "dPosY");
        double z = nbt.func_74769_h(name + "dPosZ");
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return ZERO;
        }
        return new Point3D(x, y, z);
    }

    public String toString() {
        return this.dPosX + ", " + this.dPosY + ", " + this.dPosZ;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point3D) {
            Point3D point = (Point3D)obj;
            return point.dPosX == this.dPosX && point.dPosY == this.dPosY && point.dPosZ == this.dPosZ;
        }
        return false;
    }

    public int compareTo(Object obj) {
        Point3D point = (Point3D)obj;
        if (this.iPosY > point.iPosY) {
            return 1;
        }
        if (this.iPosY == point.iPosY) {
            if (this.iPosX > point.iPosX) {
                return 1;
            }
            if (this.iPosX == point.iPosX) {
                if (this.iPosZ > point.iPosZ) {
                    return 1;
                }
                if (this.iPosZ == point.iPosZ) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
        return -1;
    }
}

