/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.tile;

import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.api.ISteamTransporter;
import flaxbeard.steamcraft.api.IWrenchable;
import flaxbeard.steamcraft.api.SteamcraftRegistry;
import flaxbeard.steamcraft.api.steamnet.SteamNetwork;
import flaxbeard.steamcraft.api.tile.SteamTransporterTileEntity;
import flaxbeard.steamcraft.tile.TileEntitySteamFurnace;
import java.util.ArrayList;
import net.minecraft.block.BlockFurnace;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.MutablePair;

public class TileEntitySteamHeater
extends SteamTransporterTileEntity
implements ISteamTransporter,
IWrenchable {
    public boolean isPrimaryHeater;
    private boolean isInitialized = false;
    private int numHeaters = 0;
    private boolean prevHadYuck = true;
    public int steamConsumption = Config.heaterConsumption;

    public TileEntitySteamHeater() {
        super(ForgeDirection.VALID_DIRECTIONS);
        this.addSidesToGaugeBlacklist(ForgeDirection.VALID_DIRECTIONS);
    }

    public static void replace(TileEntitySteamFurnace te) {
        TileEntitySteamFurnace furnace = te;
        if (furnace != null) {
            ItemStack[] furnaceItemStacks = new ItemStack[]{furnace.func_70301_a(0), furnace.func_70301_a(1), furnace.func_70301_a(2)};
            int furnaceBurnTime = furnace.field_145956_a;
            int currentItemBurnTime = furnace.field_145963_i;
            int furnaceCookTime = furnace.field_145961_j;
            te.func_145831_w().func_147455_a(te.field_145851_c, te.field_145848_d, te.field_145849_e, (TileEntity)new TileEntityFurnace());
            TileEntityFurnace furnace2 = (TileEntityFurnace)te.func_145831_w().func_147438_o(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            furnace2.func_70299_a(0, furnaceItemStacks[0]);
            furnace2.func_70299_a(1, furnaceItemStacks[1]);
            furnace2.func_70299_a(2, furnaceItemStacks[2]);
            furnace2.field_145956_a = furnaceBurnTime;
            furnace2.field_145963_i = currentItemBurnTime;
            furnace2.field_145961_j = furnaceCookTime;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.prevHadYuck = par1NBTTagCompound.func_74767_n("prevHadYuck");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("prevHadYuck", this.prevHadYuck);
    }

    @Override
    public void func_145845_h() {
        ForgeDirection dir = this.myDir();
        if (!this.isInitialized) {
            ForgeDirection[] directions = new ForgeDirection[6];
            int i = 0;
            for (ForgeDirection direction : ForgeDirection.values()) {
                if (direction == dir) continue;
                directions[i] = direction;
                ++i;
            }
            this.setDistributionDirections(directions);
            this.isInitialized = true;
        }
        super.func_145845_h();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ArrayList<TileEntitySteamHeater> secondaryHeaters = new ArrayList<TileEntitySteamHeater>();
        if (this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) != null && this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) instanceof TileEntityFurnace) {
            this.numHeaters = 0;
            if (!this.isPrimaryHeater) {
                this.prevHadYuck = true;
            }
            this.isPrimaryHeater = false;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir2 = ForgeDirection.getOrientation((int)i);
                int x = this.field_145851_c + dir.offsetX + dir2.offsetX;
                int y = this.field_145848_d + dir.offsetY + dir2.offsetY;
                int z = this.field_145849_e + dir.offsetZ + dir2.offsetZ;
                if (this.field_145850_b.func_147438_o(x, y, z) != null) {
                    if (!(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntitySteamHeater) || ((TileEntitySteamHeater)this.field_145850_b.func_147438_o(x, y, z)).getSteamShare() < this.steamConsumption || this.field_145850_b.func_72805_g(x, y, z) != ForgeDirection.OPPOSITES[i]) continue;
                    this.isPrimaryHeater = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
                    secondaryHeaters.add((TileEntitySteamHeater)this.field_145850_b.func_147438_o(x, y, z));
                    ++this.numHeaters;
                    if (secondaryHeaters.size() > 4) {
                        secondaryHeaters.remove(0);
                    }
                    this.numHeaters = Math.min(4, this.numHeaters);
                    continue;
                }
                this.field_145850_b.addTileEntity((TileEntity)this);
            }
            if (this.isPrimaryHeater && this.numHeaters > 0) {
                TileEntityFurnace furnace = (TileEntityFurnace)this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                if (!(furnace instanceof TileEntitySteamFurnace) && furnace.getClass() == TileEntityFurnace.class) {
                    ItemStack[] furnaceItemStacks = new ItemStack[]{furnace.func_70301_a(0), furnace.func_70301_a(1), furnace.func_70301_a(2)};
                    int furnaceBurnTime = furnace.field_145956_a;
                    int currentItemBurnTime = furnace.field_145963_i;
                    int furnaceCookTime = furnace.field_145961_j;
                    this.field_145850_b.func_147455_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, (TileEntity)new TileEntitySteamFurnace());
                    TileEntityFurnace furnace2 = (TileEntityFurnace)this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                    furnace2.func_70299_a(0, furnaceItemStacks[0]);
                    furnace2.func_70299_a(1, furnaceItemStacks[1]);
                    furnace2.func_70299_a(2, furnaceItemStacks[2]);
                    furnace2.field_145956_a = furnaceBurnTime;
                    furnace2.field_145963_i = currentItemBurnTime;
                    furnace2.field_145961_j = furnaceCookTime;
                }
                if ((furnace.field_145956_a == 1 || furnace.field_145956_a == 0) && this.getSteamShare() >= this.steamConsumption && this.canSmelt(furnace)) {
                    if (furnace.field_145956_a == 0) {
                        BlockFurnace.func_149931_a((boolean)true, (World)this.field_145850_b, (int)(this.field_145851_c + dir.offsetX), (int)(this.field_145848_d + dir.offsetY), (int)(this.field_145849_e + dir.offsetZ));
                    }
                    for (TileEntitySteamHeater heater : secondaryHeaters) {
                        heater.decrSteam(this.steamConsumption);
                    }
                    furnace.field_145956_a += 3;
                    if (this.numHeaters > 1 && furnace.field_145961_j > 0) {
                        furnace.field_145961_j += 2 * this.numHeaters - 1;
                        furnace.field_145961_j = Math.min(furnace.field_145961_j, 199);
                    }
                    this.field_145850_b.func_147471_g(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                }
                this.prevHadYuck = furnace.func_70301_a(2) != null && SteamcraftRegistry.steamingRecipes.containsKey(furnace.func_70301_a(2).func_77973_b());
            }
        }
    }

    public boolean canSmelt(TileEntityFurnace furnace) {
        Item item;
        int meta;
        if (furnace.func_70301_a(0) == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(furnace.func_70301_a(0));
        if (itemstack == null) {
            return false;
        }
        if (SteamcraftRegistry.steamingRecipes.containsKey(MutablePair.of((Object)itemstack.func_77973_b(), (Object)-1))) {
            meta = (Integer)SteamcraftRegistry.steamingRecipes.get((Object)MutablePair.of((Object)itemstack.func_77973_b(), (Object)Integer.valueOf((int)-1))).right;
            item = (Item)SteamcraftRegistry.steamingRecipes.get((Object)MutablePair.of((Object)itemstack.func_77973_b(), (Object)Integer.valueOf((int)-1))).left;
            itemstack = meta == -1 ? new ItemStack(item) : new ItemStack(item, 0, meta);
        }
        if (SteamcraftRegistry.steamingRecipes.containsKey(MutablePair.of((Object)itemstack.func_77973_b(), (Object)itemstack.func_77960_j()))) {
            meta = (Integer)SteamcraftRegistry.steamingRecipes.get((Object)MutablePair.of((Object)itemstack.func_77973_b(), (Object)Integer.valueOf((int)itemstack.func_77960_j()))).right;
            item = (Item)SteamcraftRegistry.steamingRecipes.get((Object)MutablePair.of((Object)itemstack.func_77973_b(), (Object)Integer.valueOf((int)itemstack.func_77960_j()))).left;
            itemstack = meta == -1 ? new ItemStack(item) : new ItemStack(item, 0, meta);
        }
        if (furnace.func_70301_a(2) == null) {
            return true;
        }
        if (!furnace.func_70301_a(2).func_77969_a(itemstack)) {
            return false;
        }
        int result = furnace.func_70301_a((int)2).field_77994_a + itemstack.field_77994_a;
        return result <= furnace.func_70297_j_() && result <= furnace.func_70301_a(2).func_77976_d();
    }

    public ForgeDirection myDir() {
        return ForgeDirection.getOrientation((int)this.func_145832_p());
    }

    @Override
    public boolean onWrench(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xO, float yO, float zO) {
        int steam = this.getSteamShare();
        this.getNetwork().split(this, true);
        ForgeDirection dir = this.myDir();
        ForgeDirection[] directions = new ForgeDirection[6];
        int i = 0;
        for (ForgeDirection direction : ForgeDirection.values()) {
            if (direction == dir) continue;
            directions[i] = direction;
            ++i;
        }
        this.setDistributionDirections(directions);
        SteamNetwork.newOrJoin(this);
        this.getNetwork().addSteam(steam);
        return true;
    }
}

