/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.item.firearm;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.api.IEngineerable;
import flaxbeard.steamcraft.api.enhancement.IEnhancement;
import flaxbeard.steamcraft.api.enhancement.IEnhancementFirearm;
import flaxbeard.steamcraft.api.enhancement.UtilEnhancements;
import flaxbeard.steamcraft.api.util.UtilMisc;
import flaxbeard.steamcraft.entity.EntityMusketBall;
import flaxbeard.steamcraft.gui.GuiEngineeringTable;
import flaxbeard.steamcraft.handler.SteamcraftEventHandler;
import flaxbeard.steamcraft.item.ItemExosuitArmor;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import org.apache.commons.lang3.tuple.MutablePair;

public class ItemFirearm
extends Item
implements IEngineerable {
    public float damage;
    public int reloadTime;
    public int shellCount;
    public float accuracy;
    public float knockback;
    public boolean shotgun;
    public Object repairMaterial = null;
    private int ticksSinceReload;
    private boolean wasSprinting = false;

    public ItemFirearm(float par2, int par3, float par4, float par5, boolean par6, int par7) {
        this.field_77777_bU = 1;
        this.func_77656_e(384);
        this.damage = par2;
        this.reloadTime = par3;
        this.accuracy = par4;
        this.knockback = par5;
        this.shotgun = par6;
        this.shellCount = par7;
    }

    public ItemFirearm(float par2, int par3, float par4, float par5, boolean par6, int par7, Object repair) {
        this.field_77777_bU = 1;
        this.func_77656_e(384);
        this.damage = par2;
        this.reloadTime = par3;
        this.accuracy = par4;
        this.knockback = par5;
        this.shotgun = par6;
        this.shellCount = par7;
        this.repairMaterial = repair;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (UtilEnhancements.hasEnhancement(stack)) {
            list.add(UtilEnhancements.getEnhancementDisplayText(stack));
        }
        super.func_77624_a(stack, player, list, par4);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean isCurrentItem) {
        super.func_77663_a(stack, world, entity, par4, isCurrentItem);
        if (entity instanceof EntityPlayerSP) {
            EntityPlayerSP player = (EntityPlayerSP)entity;
            ItemStack usingItem = player.func_71011_bu();
            if (usingItem != null && usingItem.func_77973_b() == this && UtilEnhancements.hasEnhancement(usingItem) && UtilEnhancements.getEnhancementFromItem(usingItem).getID() == "Speedy") {
                player.field_71158_b.field_78900_b *= 5.0f;
                player.field_71158_b.field_78902_a *= 5.0f;
            } else {
                this.wasSprinting = player.func_70051_ag();
            }
        }
        if (!isCurrentItem && entity instanceof EntityPlayer && stack.func_77942_o()) {
            ItemExosuitArmor legsArmor;
            Item legsItem;
            ++this.ticksSinceReload;
            NBTTagCompound nbt = stack.func_77978_p();
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack legs = player.func_71124_b(2);
            if (legs != null && nbt.func_74762_e("loaded") < 1 && this.ticksSinceReload >= this.reloadTime + 10 && (legsItem = legs.func_77973_b()) instanceof ItemExosuitArmor && (legsArmor = (ItemExosuitArmor)legsItem).hasUpgrade(legs, SteamcraftItems.reloadingHolsters) && SteamcraftEventHandler.hasPower((EntityLivingBase)player, Config.reloadingConsumption) && player.field_71071_by.func_146028_b(SteamcraftItems.musketCartridge)) {
                this.func_77654_b(stack, world, player);
                this.func_77659_a(stack, world, player);
                SteamcraftEventHandler.drainSteam(player.func_71124_b(3), Config.reloadingConsumption);
                this.ticksSinceReload = 0;
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (UtilEnhancements.hasEnhancement(stack)) {
            return UtilEnhancements.getNameFromEnhancement(stack);
        }
        return super.func_77667_c(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        super.func_94581_a(ir);
        UtilEnhancements.registerEnhancementsForItem(ir, this);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (UtilEnhancements.hasEnhancement(stack)) {
            return UtilEnhancements.getIconFromEnhancement(stack);
        }
        return super.getIcon(stack, renderPass, player, usingItem, useRemaining);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (UtilEnhancements.hasEnhancement(stack)) {
            return UtilEnhancements.getIconFromEnhancement(stack);
        }
        return super.func_77650_f(stack);
    }

    public void func_77615_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        boolean crouched = par3EntityPlayer.func_70093_af();
        if (nbt.func_74762_e("loaded") > 0) {
            int i;
            float crouchingBonus;
            float enhancementAccuracy = 0.0f;
            float enhancementDamage = 0.0f;
            float enhancementKnockback = 0.0f;
            float f = crouchingBonus = crouched ? 0.1f : 0.0f;
            if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementFirearm) {
                enhancementAccuracy = ((IEnhancementFirearm)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getAccuracyChange(this);
                enhancementDamage = ((IEnhancementFirearm)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getDamageChange(this);
                enhancementKnockback = ((IEnhancementFirearm)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getKnockbackChange(this);
            }
            int var6 = this.func_77626_a(par1ItemStack) - par4;
            ArrowLooseEvent event = new ArrowLooseEvent(par3EntityPlayer, par1ItemStack, var6);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return;
            }
            var6 = event.charge;
            float var7 = (float)var6 / 20.0f;
            if ((double)(var7 = (var7 * var7 + var7 * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (var7 > 1.0f) {
                var7 = 1.0f;
            }
            EntityMusketBall var8 = new EntityMusketBall(par2World, par3EntityPlayer, 2.0f, 1.0f + this.accuracy + enhancementAccuracy - crouchingBonus - var7, this.damage + enhancementDamage, true);
            if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementFirearm) {
                var8 = ((IEnhancementFirearm)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).changeBullet(var8);
            }
            par1ItemStack.func_77972_a(1, (EntityLivingBase)par3EntityPlayer);
            par2World.func_72956_a((Entity)par3EntityPlayer, "random.explode", (this.knockback + enhancementKnockback) * 0.4f * (UtilEnhancements.getEnhancementFromItem(par1ItemStack) != null && UtilEnhancements.getEnhancementFromItem(par1ItemStack).getID() == "Silencer" ? 0.4f : 1.0f), 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + var7 * 0.5f);
            for (i = 1; i < 16; ++i) {
                par2World.func_72869_a("smoke", par3EntityPlayer.field_70165_t + (double)field_77697_d.nextFloat() - 0.5, par3EntityPlayer.field_70163_u + (double)(field_77697_d.nextFloat() / 2.0f) - 0.25, par3EntityPlayer.field_70161_v + (double)field_77697_d.nextFloat() - 0.5, 0.0, 0.01, 0.0);
            }
            if (!par2World.field_72995_K) {
                if (this.shotgun) {
                    for (i = 1; i < 21; ++i) {
                        EntityMusketBall var12 = new EntityMusketBall(par2World, par3EntityPlayer, 2.0f, 1.0f + this.accuracy + enhancementAccuracy - crouchingBonus - var7, this.damage + enhancementDamage, false);
                        if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementFirearm) {
                            var12 = ((IEnhancementFirearm)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).changeBullet(var12);
                        }
                        par2World.func_72838_d((Entity)var12);
                    }
                } else {
                    par2World.func_72838_d((Entity)var8);
                }
            }
            nbt.func_74768_a("loaded", nbt.func_74762_e("loaded") - 1);
            if (par2World.field_72995_K && !par3EntityPlayer.field_71075_bZ.field_75098_d) {
                float thiskb = this.knockback + enhancementKnockback;
                boolean crouching = par3EntityPlayer.func_70093_af();
                if (crouching) {
                    thiskb /= 2.0f;
                }
                par3EntityPlayer.field_70125_A -= thiskb * 3.0f;
                par3EntityPlayer.field_70179_y = -MathHelper.func_76134_b((float)(par3EntityPlayer.field_70177_z * (float)Math.PI / 180.0f)) * (thiskb * 0.08f);
                par3EntityPlayer.field_70159_w = MathHelper.func_76126_a((float)(par3EntityPlayer.field_70177_z * (float)Math.PI / 180.0f)) * (thiskb * 0.08f);
            }
        } else if (nbt.func_74767_n("done")) {
            nbt.func_74768_a("loaded", nbt.func_74762_e("numloaded"));
            nbt.func_74757_a("done", false);
        }
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        boolean var5 = par3EntityPlayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)par1ItemStack) > 0;
        int enhancementShells = 0;
        if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementFirearm) {
            enhancementShells = ((IEnhancementFirearm)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getClipSizeChange(this);
        }
        if ((var5 || par3EntityPlayer.field_71071_by.func_146028_b(SteamcraftItems.musketCartridge)) && !nbt.func_74767_n("done")) {
            nbt.func_74768_a("numloaded", 1);
            if (var5) {
                nbt.func_74768_a("numloaded", this.shellCount + enhancementShells);
            } else {
                par3EntityPlayer.field_71071_by.func_146026_a(SteamcraftItems.musketCartridge);
                if (this.shellCount + enhancementShells > 1) {
                    for (int i = 1; i < this.shellCount + enhancementShells; ++i) {
                        if (!par3EntityPlayer.field_71071_by.func_146028_b(SteamcraftItems.musketCartridge)) continue;
                        par3EntityPlayer.field_71071_by.func_146026_a(SteamcraftItems.musketCartridge);
                        nbt.func_74768_a("numloaded", nbt.func_74762_e("numloaded") + 1);
                    }
                }
            }
            nbt.func_74757_a("done", true);
            par2World.func_72956_a((Entity)par3EntityPlayer, "random.click", UtilEnhancements.getEnhancementFromItem(par1ItemStack) != null && UtilEnhancements.getEnhancementFromItem(par1ItemStack).getID() == "Silencer" ? 0.4f : 1.0f, par2World.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        return par1ItemStack;
    }

    public boolean func_77662_d() {
        return true;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        NBTTagCompound nbt;
        if (!par1ItemStack.func_77942_o()) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
            nbt = par1ItemStack.func_77978_p();
            nbt.func_74768_a("loaded", 0);
            nbt.func_74768_a("numloaded", 0);
        }
        nbt = par1ItemStack.func_77978_p();
        int enhancementReload = 0;
        if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementFirearm) {
            enhancementReload = ((IEnhancementFirearm)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getReloadChange(this);
        }
        if (nbt.func_74762_e("loaded") > 0 || nbt.func_74767_n("done")) {
            return 72000;
        }
        return this.reloadTime + enhancementReload;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        NBTTagCompound nbt;
        if (!par1ItemStack.func_77942_o()) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
            nbt = par1ItemStack.func_77978_p();
            nbt.func_74768_a("loaded", 0);
            nbt.func_74768_a("numloaded", 0);
        }
        if ((nbt = par1ItemStack.func_77978_p()).func_74762_e("loaded") > 0) {
            return EnumAction.bow;
        }
        return EnumAction.block;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!par1ItemStack.func_77942_o()) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
            NBTTagCompound nbt = par1ItemStack.func_77978_p();
            nbt.func_74768_a("loaded", 0);
            nbt.func_74757_a("done", false);
            nbt.func_74768_a("numloaded", 0);
        }
        NBTTagCompound nbtt = par1ItemStack.func_77978_p();
        if (par3EntityPlayer.field_71075_bZ.field_75098_d) {
            int enhancementShells = 0;
            if (UtilEnhancements.hasEnhancement(par1ItemStack) && UtilEnhancements.getEnhancementFromItem(par1ItemStack) instanceof IEnhancementFirearm) {
                enhancementShells = ((IEnhancementFirearm)UtilEnhancements.getEnhancementFromItem(par1ItemStack)).getClipSizeChange(this);
            }
            nbtt.func_74768_a("loaded", 1);
            nbtt.func_74768_a("numloaded", this.shellCount + enhancementShells);
        }
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    @Override
    public MutablePair<Integer, Integer>[] engineerCoordinates() {
        return new MutablePair[]{MutablePair.of((Object)53, (Object)29)};
    }

    @Override
    public ItemStack getStackInSlot(ItemStack me, int var1) {
        if (UtilEnhancements.hasEnhancement(me)) {
            Item item = (Item)UtilEnhancements.getEnhancementFromItem(me);
            return new ItemStack(item);
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(ItemStack me, int var1, ItemStack stack) {
        if (!me.func_77942_o()) {
            me.func_77982_d(new NBTTagCompound());
        }
        if (stack != null) {
            IEnhancement enhancement = (IEnhancement)stack.func_77973_b();
            NBTTagCompound enhancements = new NBTTagCompound();
            enhancements.func_74778_a("id", enhancement.getID());
            me.field_77990_d.func_74782_a("enhancements", (NBTBase)enhancements);
        }
    }

    @Override
    public boolean isItemValidForSlot(ItemStack me, int var1, ItemStack var2) {
        return true;
    }

    @Override
    public ItemStack decrStackSize(ItemStack me, int var1, int var2) {
        if (UtilEnhancements.hasEnhancement(me)) {
            Item item = (Item)UtilEnhancements.getEnhancementFromItem(me);
            UtilEnhancements.removeEnhancement(me);
            return new ItemStack(item);
        }
        return null;
    }

    @Override
    public void drawSlot(GuiContainer guiEngineeringTable, int slotnum, int i, int j) {
        guiEngineeringTable.field_146297_k.func_110434_K().func_110577_a(GuiEngineeringTable.furnaceGuiTextures);
        guiEngineeringTable.func_73729_b(i, j, 176, 0, 18, 18);
    }

    @Override
    public boolean canPutInSlot(ItemStack me, int slotNum, ItemStack upgrade) {
        return upgrade.func_77973_b() instanceof IEnhancement && ((IEnhancement)upgrade.func_77973_b()).canApplyTo(me);
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        if (this.repairMaterial != null) {
            if (this.repairMaterial instanceof ItemStack) {
                return par2ItemStack.func_77969_a((ItemStack)this.repairMaterial) ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
            }
            if (this.repairMaterial instanceof String) {
                return UtilMisc.doesMatch(par2ItemStack, (String)this.repairMaterial) ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
            }
        }
        return super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    @Override
    public void drawBackground(GuiEngineeringTable guiEngineeringTable, int i, int j, int k) {
        guiEngineeringTable.field_146297_k.func_110434_K().func_110577_a(ItemExosuitArmor.largeIcons);
        if (this == SteamcraftItems.musket) {
            guiEngineeringTable.func_73729_b(j + 26, k + 3, 0, 64, 64, 64);
        } else if (this == SteamcraftItems.blunderbuss) {
            guiEngineeringTable.func_73729_b(j + 26, k + 3, 64, 64, 64, 64);
        } else if (this == SteamcraftItems.pistol) {
            guiEngineeringTable.func_73729_b(j + 26, k + 3, 128, 64, 64, 64);
        }
    }
}

