/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.codechicken.lib.render;

import flaxbeard.steamcraft.codechicken.lib.colour.ColourRGBA;
import flaxbeard.steamcraft.codechicken.lib.lighting.LC;
import flaxbeard.steamcraft.codechicken.lib.lighting.LightMatrix;
import flaxbeard.steamcraft.codechicken.lib.render.CCModel;
import flaxbeard.steamcraft.codechicken.lib.render.CCRenderPipeline;
import flaxbeard.steamcraft.codechicken.lib.render.Vertex5;
import flaxbeard.steamcraft.codechicken.lib.util.Copyable;
import flaxbeard.steamcraft.codechicken.lib.vec.Rotation;
import flaxbeard.steamcraft.codechicken.lib.vec.Transformation;
import flaxbeard.steamcraft.codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class CCRenderState {
    public static IVertexSource model;
    public static int firstVertexIndex;
    public static int lastVertexIndex;
    public static int vertexIndex;
    public static CCRenderPipeline pipeline;
    public static int baseColour;
    public static VertexAttribute<int[]> colourAttrib;
    public static int alphaOverride;
    public static boolean useNormals;
    public static boolean computeLighting;
    public static boolean useColour;
    public static LightMatrix lightMatrix;
    public static VertexAttribute<Vector3[]> normalAttrib;
    public static Vertex5 vert;
    public static boolean hasNormal;
    public static Vector3 normal;
    public static VertexAttribute<int[]> sideAttrib;
    public static boolean hasColour;
    public static VertexAttribute<LC[]> lightCoordAttrib;
    public static int colour;
    public static VertexAttribute<int[]> lightingAttrib;
    public static boolean hasBrightness;
    public static int brightness;
    public static int side;
    public static LC lc;
    private static int nextOperationIndex;
    private static ArrayList<VertexAttribute<?>> vertexAttributes;

    public static int registerOperation() {
        return nextOperationIndex++;
    }

    public static int operationCount() {
        return nextOperationIndex;
    }

    private static int registerVertexAttribute(VertexAttribute<?> attr) {
        vertexAttributes.add(attr);
        return vertexAttributes.size() - 1;
    }

    public static VertexAttribute<?> getAttribute(int index) {
        return vertexAttributes.get(index);
    }

    public static void arrayCopy(Object src, int srcPos, Object dst, int destPos, int length) {
        System.arraycopy(src, srcPos, dst, destPos, length);
        if (dst instanceof Copyable[]) {
            Object[] oa = (Object[])dst;
            Copyable[] c = (Copyable[])dst;
            for (int i = destPos; i < destPos + length; ++i) {
                if (c[i] == null) continue;
                oa[i] = c[i].copy();
            }
        }
    }

    public static <T> T copyOf(VertexAttribute<T> attr, T src, int length) {
        T dst = attr.newArray(length);
        CCRenderState.arrayCopy(src, 0, dst, 0, ((Object[])src).length);
        return dst;
    }

    public static void reset() {
        model = null;
        pipeline.reset();
        hasColour = false;
        hasBrightness = false;
        hasNormal = false;
        useNormals = false;
        computeLighting = true;
        useColour = true;
        alphaOverride = -1;
        baseColour = -1;
    }

    public static void setPipeline(IVertexOperation ... ops) {
        pipeline.setPipeline(ops);
    }

    public static void setPipeline(IVertexSource model, int start, int end, IVertexOperation ... ops) {
        pipeline.reset();
        CCRenderState.setModel(model, start, end);
        pipeline.setPipeline(ops);
    }

    public static void bindModel(IVertexSource model) {
        if (CCRenderState.model != model) {
            CCRenderState.model = model;
            pipeline.rebuild();
        }
    }

    public static void setModel(IVertexSource source) {
        CCRenderState.setModel(source, 0, source.getVertices().length);
    }

    public static void setModel(IVertexSource source, int start, int end) {
        CCRenderState.bindModel(source);
        CCRenderState.setVertexRange(start, end);
    }

    public static void setVertexRange(int start, int end) {
        firstVertexIndex = start;
        lastVertexIndex = end;
    }

    public static void render(IVertexOperation ... ops) {
        CCRenderState.setPipeline(ops);
        CCRenderState.render();
    }

    public static void render() {
        Vertex5[] verts = model.getVertices();
        for (vertexIndex = firstVertexIndex; vertexIndex < lastVertexIndex; ++vertexIndex) {
            model.prepareVertex();
            vert.set(verts[vertexIndex]);
            CCRenderState.runPipeline();
            CCRenderState.writeVert();
        }
    }

    public static void runPipeline() {
        pipeline.operate();
    }

    public static void writeVert() {
        if (hasNormal) {
            Tessellator.field_78398_a.func_78375_b((float)CCRenderState.normal.x, (float)CCRenderState.normal.y, (float)CCRenderState.normal.z);
        }
        if (hasColour) {
            Tessellator.field_78398_a.func_78370_a(colour >>> 24, colour >> 16 & 0xFF, colour >> 8 & 0xFF, alphaOverride >= 0 ? alphaOverride : colour & 0xFF);
        }
        if (hasBrightness) {
            Tessellator.field_78398_a.func_78380_c(brightness);
        }
        Tessellator.field_78398_a.func_78374_a(CCRenderState.vert.vec.x, CCRenderState.vert.vec.y, CCRenderState.vert.vec.z, CCRenderState.vert.uv.u, CCRenderState.vert.uv.v);
    }

    public static void setNormal(double x, double y, double z) {
        hasNormal = true;
        normal.set(x, y, z);
    }

    public static void setNormal(Vector3 n) {
        hasNormal = true;
        normal.set(n);
    }

    public static void setColour(int c) {
        hasColour = true;
        colour = c;
    }

    public static void setBrightness(int b) {
        hasBrightness = true;
        brightness = b;
    }

    public static void setBrightness(IBlockAccess world, int x, int y, int z) {
        CCRenderState.setBrightness(world.func_147439_a(x, y, z).func_149677_c(world, x, y, z));
    }

    public static void pullLightmap() {
        CCRenderState.setBrightness((int)OpenGlHelper.lastBrightnessY << 16 | (int)OpenGlHelper.lastBrightnessX);
    }

    public static void setDynamic() {
        useNormals = true;
        computeLighting = false;
    }

    public static void changeTexture(String texture) {
        CCRenderState.changeTexture(new ResourceLocation(texture));
    }

    public static void changeTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void startDrawing() {
        CCRenderState.startDrawing(7);
    }

    public static void startDrawing(int mode) {
        Tessellator.field_78398_a.func_78371_b(mode);
        if (hasColour) {
            Tessellator.field_78398_a.func_78370_a(colour >>> 24, colour >> 16 & 0xFF, colour >> 8 & 0xFF, alphaOverride >= 0 ? alphaOverride : colour & 0xFF);
        }
        if (hasBrightness) {
            Tessellator.field_78398_a.func_78380_c(brightness);
        }
    }

    public static void draw() {
        Tessellator.field_78398_a.func_78381_a();
    }

    static /* synthetic */ int access$000(VertexAttribute x0) {
        return CCRenderState.registerVertexAttribute(x0);
    }

    static {
        pipeline = new CCRenderPipeline();
        colourAttrib = new VertexAttribute<int[]>(){
            private int[] colourRef;

            @Override
            public int[] newArray(int length) {
                return new int[length];
            }

            @Override
            public boolean load() {
                this.colourRef = model.getAttributes(this);
                return this.colourRef != null || !model.hasAttribute(this);
            }

            @Override
            public void operate() {
                if (this.colourRef != null) {
                    CCRenderState.setColour(ColourRGBA.multiply(baseColour, this.colourRef[vertexIndex]));
                } else {
                    CCRenderState.setColour(baseColour);
                }
            }
        };
        lightMatrix = new LightMatrix();
        normalAttrib = new VertexAttribute<Vector3[]>(){
            private Vector3[] normalRef;

            @Override
            public Vector3[] newArray(int length) {
                return new Vector3[length];
            }

            @Override
            public boolean load() {
                this.normalRef = model.getAttributes(this);
                if (model.hasAttribute(this)) {
                    return this.normalRef != null;
                }
                if (model.hasAttribute(sideAttrib)) {
                    pipeline.addDependency(sideAttrib);
                    return true;
                }
                throw new IllegalStateException("Normals requested but neither normal or side attrutes are provided by the model");
            }

            @Override
            public void operate() {
                if (this.normalRef != null) {
                    CCRenderState.setNormal(this.normalRef[vertexIndex]);
                } else {
                    CCRenderState.setNormal(Rotation.axes[side]);
                }
            }
        };
        vert = new Vertex5();
        normal = new Vector3();
        sideAttrib = new VertexAttribute<int[]>(){
            private int[] sideRef;

            @Override
            public int[] newArray(int length) {
                return new int[length];
            }

            @Override
            public boolean load() {
                this.sideRef = model.getAttributes(this);
                if (model.hasAttribute(this)) {
                    return this.sideRef != null;
                }
                pipeline.addDependency(normalAttrib);
                return true;
            }

            @Override
            public void operate() {
                side = this.sideRef != null ? this.sideRef[vertexIndex] : CCModel.findSide(normal);
            }
        };
        lightCoordAttrib = new VertexAttribute<LC[]>(){
            private LC[] lcRef;
            private Vector3 vec = new Vector3();
            private Vector3 pos = new Vector3();

            @Override
            public LC[] newArray(int length) {
                return new LC[length];
            }

            @Override
            public boolean load() {
                this.lcRef = model.getAttributes(this);
                if (model.hasAttribute(this)) {
                    return this.lcRef != null;
                }
                this.pos.set(CCRenderState.lightMatrix.pos.x, CCRenderState.lightMatrix.pos.y, CCRenderState.lightMatrix.pos.z);
                pipeline.addDependency(sideAttrib);
                pipeline.addRequirement(Transformation.operationIndex);
                return true;
            }

            @Override
            public void operate() {
                if (this.lcRef != null) {
                    lc.set(this.lcRef[vertexIndex]);
                } else {
                    lc.compute(this.vec.set(CCRenderState.vert.vec).sub(this.pos), side);
                }
            }
        };
        lightingAttrib = new VertexAttribute<int[]>(){
            private int[] colourRef;

            @Override
            public int[] newArray(int length) {
                return new int[length];
            }

            @Override
            public boolean load() {
                if (!(computeLighting && useColour && model.hasAttribute(this))) {
                    return false;
                }
                this.colourRef = model.getAttributes(this);
                if (this.colourRef != null) {
                    pipeline.addDependency(colourAttrib);
                    return true;
                }
                return false;
            }

            @Override
            public void operate() {
                CCRenderState.setColour(ColourRGBA.multiply(colour, this.colourRef[vertexIndex]));
            }
        };
        lc = new LC();
        vertexAttributes = new ArrayList();
    }

    public static abstract class VertexAttribute<T>
    implements IVertexOperation {
        public final int attributeIndex = CCRenderState.access$000(this);
        private final int operationIndex = CCRenderState.registerOperation();
        public boolean active = false;

        public abstract T newArray(int var1);

        @Override
        public int operationID() {
            return this.operationIndex;
        }
    }

    public static interface IVertexSource {
        public Vertex5[] getVertices();

        public <T> T getAttributes(VertexAttribute<T> var1);

        public boolean hasAttribute(VertexAttribute<?> var1);

        public void prepareVertex();
    }

    public static interface IVertexOperation {
        public boolean load();

        public void operate();

        public int operationID();
    }
}

