/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world;

import elec332.core.player.PlayerHelper;
import elec332.core.util.BlockLoc;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class WorldHelper {
    public static void spawnExplosion(World worldObj, int xCoord, int yCoord, int zCoord, float force) {
        worldObj.func_72876_a(null, (double)xCoord, (double)yCoord, (double)zCoord, force * 4.0f, true);
    }

    public static ForgeChunkManager.Ticket requestTicket(World world, BlockLoc loc, Object modInstance) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)modInstance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket != null) {
            loc.toNBT(ticket.getModData());
        }
        return ticket;
    }

    public static ChunkCoordIntPair fromBlockLoc(BlockLoc loc) {
        return new ChunkCoordIntPair(loc.xCoord >> 4, loc.zCoord >> 4);
    }

    public static void forceChunk(ForgeChunkManager.Ticket ticket) {
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)WorldHelper.fromBlockLoc(new BlockLoc(ticket.getModData())));
    }

    public static void dropStack(World world, BlockLoc blockLoc, ItemStack stack) {
        WorldHelper.dropStack(world, blockLoc.xCoord, blockLoc.yCoord, blockLoc.zCoord, stack);
    }

    public static void dropStack(World world, int x, int y, int z, ItemStack itemStack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void scheduleBlockUpdate(World world, BlockLoc blockLoc) {
        WorldHelper.scheduleBlockUpdate(world, blockLoc.xCoord, blockLoc.yCoord, blockLoc.zCoord);
    }

    public static void scheduleBlockUpdate(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, world.func_147439_a(x, y, z), 1);
    }

    public static int getDimID(World world) {
        if (world == null) {
            throw new IllegalArgumentException("Cannot fetch the Dimension-ID from a null world!");
        }
        if (world.field_73011_w == null) {
            for (Integer i : DimensionManager.getIDs()) {
                if (DimensionManager.getWorld((int)i) != world) continue;
                return i;
            }
            throw new RuntimeException("Unable to determine the dimension of world: " + world);
        }
        return world.field_73011_w.field_76574_g;
    }

    public static int getBlockMeta(IBlockAccess world, BlockLoc blockLoc) {
        return world.func_72805_g(blockLoc.xCoord, blockLoc.yCoord, blockLoc.zCoord);
    }

    public static TileEntity getTileAt(IBlockAccess world, BlockLoc loc) {
        return world.func_147438_o(loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public static Block getBlockAt(IBlockAccess world, BlockLoc loc) {
        return world.func_147439_a(loc.xCoord, loc.yCoord, loc.zCoord);
    }

    public static void spawnLightningAtLookVec(EntityPlayer player, Double range) {
        MovingObjectPosition position = PlayerHelper.getPosPlayerIsLookingAt(player, range);
        WorldHelper.spawnLightningAt(player.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d);
    }

    public static void spawnLightningAt(World world, double x, double y, double z) {
        world.func_72908_a(x, y, z, "ambient.weather.thunder", 10000.0f, 0.8f);
        world.func_72908_a(x, y, z, "random.explode", 10000.0f, 0.8f);
        world.func_72838_d((Entity)new EntityLightningBolt(world, x, y, z));
    }
}

