/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLoc {
    public int xCoord;
    public int yCoord;
    public int zCoord;

    public BlockLoc(TileEntity tileEntity) {
        this.xCoord = tileEntity.field_145851_c;
        this.yCoord = tileEntity.field_145848_d;
        this.zCoord = tileEntity.field_145849_e;
    }

    public BlockLoc(int xCoord, int yCoord, int zCoord) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
    }

    public BlockLoc atSide(ForgeDirection direction) {
        return new BlockLoc(this.xCoord + direction.offsetX, this.yCoord + direction.offsetY, this.zCoord + direction.offsetZ);
    }

    public BlockLoc copy() {
        return new BlockLoc(this.xCoord, this.yCoord, this.zCoord);
    }

    public BlockLoc add(float i) {
        this.xCoord = (int)((float)this.xCoord + i);
        this.yCoord = (int)((float)this.yCoord + i);
        this.zCoord = (int)((float)this.zCoord + i);
        return this;
    }

    public BlockLoc translate(BlockLoc blockLoc) {
        this.xCoord += blockLoc.xCoord;
        this.yCoord += blockLoc.yCoord;
        this.zCoord += blockLoc.zCoord;
        return this;
    }

    public double distanceSquared(BlockLoc loc) {
        double dx = loc.xCoord - this.xCoord;
        double dy = loc.yCoord - this.yCoord;
        double dz = loc.zCoord - this.zCoord;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distance(BlockLoc loc) {
        return Math.sqrt(this.distanceSquared(loc));
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
    }

    public BlockLoc(NBTTagCompound tagCompound) {
        this.xCoord = (int)tagCompound.func_74769_h("xCoord");
        this.yCoord = (int)tagCompound.func_74769_h("yCoord");
        this.zCoord = (int)tagCompound.func_74769_h("zCoord");
    }

    public NBTTagCompound toNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74780_a("xCoord", (double)this.xCoord);
        tagCompound.func_74780_a("yCoord", (double)this.yCoord);
        tagCompound.func_74780_a("zCoord", (double)this.zCoord);
        return tagCompound;
    }

    public boolean equals(Object obj) {
        return obj instanceof BlockLoc && ((BlockLoc)obj).zCoord == this.zCoord && ((BlockLoc)obj).yCoord == this.yCoord && ((BlockLoc)obj).xCoord == this.xCoord;
    }

    public String toString() {
        return "(" + this.xCoord + "," + this.yCoord + "," + this.zCoord + ")";
    }

    public int hashCode() {
        return this.xCoord + this.yCoord + this.zCoord;
    }
}

