/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import elec332.core.main.ElecCore;
import elec332.core.network.NetworkHandler;
import elec332.core.player.PlayerHelper;
import elec332.core.server.ElecPlayer;
import elec332.core.util.EventHelper;
import elec332.core.util.NBTHelper;
import elec332.core.world.WorldHelper;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.io.FileUtils;

public class ServerHelper {
    public static final ServerHelper instance = new ServerHelper();
    private final Map<String, Class<? extends ElecPlayer.ExtendedProperties>> extendedPropertiesList;
    private NBTHelper generalData;
    private Map<UUID, ElecPlayer> playerData;
    private Map<Integer, NBTHelper> worldData;
    private boolean locked;

    private ServerHelper() {
        EventHelper.registerHandlerForgeAndFML(new EventHandler());
        this.playerData = Maps.newHashMap();
        this.worldData = Maps.newHashMap();
        this.extendedPropertiesList = Maps.newHashMap();
        this.locked = false;
        this.setInvalid();
    }

    public void load() {
    }

    public void registerExtendedProperties(String identifier, Class<? extends ElecPlayer.ExtendedProperties> propClass) {
        if (this.extendedPropertiesList.keySet().contains(identifier)) {
            throw new IllegalArgumentException("Property for " + identifier + " has already been registered!");
        }
        if (Loader.instance().hasReachedState(LoaderState.AVAILABLE) || this.locked) {
            throw new IllegalArgumentException("Mod is attempting to register properties too late: " + identifier + "  " + propClass.getName());
        }
        this.extendedPropertiesList.put(identifier, propClass);
    }

    public ElecPlayer getPlayer(EntityPlayer player) {
        return this.getPlayer(PlayerHelper.getPlayerUUID(player));
    }

    public ElecPlayer getPlayer(UUID uuid) {
        if (this.isValid()) {
            return this.playerData.get(uuid);
        }
        return null;
    }

    public NBTHelper getWorldData(World world) {
        return this.getWorldData(WorldHelper.getDimID(world));
    }

    public NBTHelper getWorldData(int i) {
        if (!this.isValid()) {
            return null;
        }
        NBTHelper ret = this.worldData.get(i);
        if (ret == null) {
            ret = new NBTHelper(new NBTTagCompound());
            this.worldData.put(i, ret);
        }
        return ret;
    }

    public NBTHelper getGlobalData() {
        if (this.isValid()) {
            return this.generalData;
        }
        return null;
    }

    public List<EntityPlayerMP> getOnlinePlayers() {
        return this.getMinecraftServer().func_71203_ab().field_72404_b;
    }

    public boolean isPlayerOnline(UUID uuid) {
        return this.getPlayer(uuid).isOnline();
    }

    public EntityPlayerMP getRealPlayer(UUID uuid) {
        if (this.isPlayerOnline(uuid)) {
            for (EntityPlayerMP player : this.getOnlinePlayers()) {
                if (!PlayerHelper.getPlayerUUID((EntityPlayer)player).equals(uuid)) continue;
                return player;
            }
        }
        return null;
    }

    public List<EntityPlayerMP> getAllPlayersWatchingBlock(World world, int x, int z) {
        ArrayList ret = Lists.newArrayList();
        if (world instanceof WorldServer) {
            PlayerManager playerManager = ((WorldServer)world).func_73040_p();
            for (EntityPlayerMP player : this.getOnlinePlayers()) {
                Chunk chunk = world.func_72938_d(x, z);
                if (!playerManager.func_72694_a(player, chunk.field_76635_g, chunk.field_76647_h)) continue;
                ret.add(player);
            }
        }
        return ret;
    }

    public void sendMessageToAllPlayersWatchingBlock(World world, int x, int z, IMessage message, NetworkHandler networkHandler) {
        for (EntityPlayerMP player : this.getAllPlayersWatchingBlock(world, x, z)) {
            networkHandler.getNetworkWrapper().sendTo(message, player);
        }
    }

    public MinecraftServer getMinecraftServer() {
        return MinecraftServer.func_71276_C();
    }

    public boolean isValid() {
        return this.getMinecraftServer() != null;
    }

    public static boolean isServer(World world) {
        return !world.field_72995_K;
    }

    private void setInvalid() {
        this.generalData = null;
        this.playerData.clear();
        this.worldData.clear();
    }

    private void investigateErrors(boolean errorBefore) {
        if (errorBefore) {
            ElecCore.logger.error("Starting thorough investigation...");
        }
        boolean error = false;
        for (EntityPlayerMP playerMP : this.getOnlinePlayers()) {
            ElecPlayer elecPlayer;
            if (!this.isValid() || (elecPlayer = this.getPlayer((EntityPlayer)playerMP)) != null) continue;
            if (!errorBefore) {
                this.investigateErrors(true);
                return;
            }
            error = true;
            ElecCore.logger.error("Seems like there is a player online that also never properly connected: " + playerMP.getDisplayName());
        }
        for (ElecPlayer elecPlayer : this.playerData.values()) {
            EntityPlayerMP online;
            if (!elecPlayer.isOnline() || (online = this.getRealPlayer(elecPlayer.getPlayerUUID())) != null) continue;
            if (!errorBefore) {
                this.investigateErrors(true);
                return;
            }
            error = true;
            ElecCore.logger.error("Seems like the player with UUID: " + elecPlayer.getPlayerUUID() + " never properly disconnected from the server.");
        }
        if (errorBefore) {
            if (!error) {
                ElecCore.logger.error("No additional errors found...");
            }
            ElecCore.logger.error("Finished investigation.");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NBTTagCompound fromFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            if (file.exists()) return CompressedStreamTools.func_74797_a((File)file);
            ServerHelper.createFile(file);
            return new NBTTagCompound();
        }
        catch (EOFException e) {
            try {
                ElecCore.logger.error("Error reading NBT files, something weird must have happened when you last shutdown MC, unfortunately, some game data will be lost. Fixing file now....");
                String date = Calendar.getInstance().getTime().toString();
                String ext = file.getName().split(".")[1];
                File newFile = new File(file.getCanonicalPath().replace(ext, "-" + date + ext));
                FileUtils.moveFile((File)file, (File)newFile);
                ServerHelper.createFile(file);
                return new NBTTagCompound();
                catch (IOException io) {
                    if (file.exists() && !file.delete()) {
                        throw new IOException("Failed to delete file: " + file.getCanonicalPath());
                    }
                    ServerHelper.createFile(file);
                    return new NBTTagCompound();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
                throw new RuntimeException(e2);
            }
        }
    }

    public static void createFile(File file) throws IOException {
        if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
            throw new IOException();
        }
    }

    public void toFile(NBTTagCompound tagCompound, File file) {
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)tagCompound, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class EventHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (ServerHelper.isServer(event.world) && WorldHelper.getDimID(event.world) == 0) {
                if (!ServerHelper.this.locked) {
                    ServerHelper.this.locked = true;
                }
                File folder = new File(event.world.func_72860_G().func_75765_b(), "elec332/");
                ServerHelper.this.generalData = new NBTHelper(ServerHelper.fromFile(new File(folder, "generalData.dat")));
                NBTTagList tagList1 = ServerHelper.fromFile(new File(folder, "playerData.dat")).func_150295_c("playerData", 10);
                for (int i = 0; i < tagList1.func_74745_c(); ++i) {
                    NBTTagCompound tagCompound = tagList1.func_150305_b(i);
                    UUID uuid = UUID.fromString(tagCompound.func_74779_i("uuid"));
                    NBTTagCompound data = tagCompound.func_74775_l("data");
                    ElecPlayer player = new ElecPlayer(uuid);
                    player.setExtendedProperties(ServerHelper.this.extendedPropertiesList);
                    player.readFromNBT(data);
                    ServerHelper.this.playerData.put(uuid, player);
                }
                NBTTagList tagList2 = ServerHelper.fromFile(new File(folder, "worldData.dat")).func_150295_c("dimData", 10);
                for (int i = 0; i < tagList2.func_74745_c(); ++i) {
                    NBTTagCompound tagCompound = tagList2.func_150305_b(i);
                    int dim = tagCompound.func_74762_e("dim");
                    NBTTagCompound data = tagCompound.func_74775_l("data");
                    ServerHelper.this.worldData.put(dim, new NBTHelper(data));
                }
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (ServerHelper.isServer(event.world) && WorldHelper.getDimID(event.world) == 0) {
                File folder = new File(event.world.func_72860_G().func_75765_b(), "elec332/");
                ServerHelper.this.toFile(ServerHelper.this.generalData.toNBT(), new File(folder, "generalData.dat"));
                NBTTagList tagList1 = new NBTTagList();
                for (UUID uuid : ServerHelper.this.playerData.keySet()) {
                    tagList1.func_74742_a((NBTBase)new NBTHelper(new NBTTagCompound()).addToTag(uuid.toString(), "uuid").addToTag((NBTBase)((ElecPlayer)ServerHelper.this.playerData.get(uuid)).saveToNBT(), "data").toNBT());
                }
                ServerHelper.this.toFile(new NBTHelper().addToTag((NBTBase)tagList1, "playerData").toNBT(), new File(folder, "playerData.dat"));
                NBTTagList tagList2 = new NBTTagList();
                for (Integer i : ServerHelper.this.worldData.keySet()) {
                    tagList2.func_74742_a((NBTBase)new NBTHelper(new NBTTagCompound()).addToTag(i, "dim").addToTag((NBTBase)((NBTHelper)ServerHelper.this.worldData.get(i)).toNBT(), "data").toNBT());
                }
                ServerHelper.this.toFile(new NBTHelper().addToTag((NBTBase)tagList2, "dimData").toNBT(), new File(folder, "worldData.dat"));
            }
        }

        @SubscribeEvent
        public void playerJoined(PlayerEvent.PlayerLoggedInEvent event) {
            if (!(event.player instanceof EntityPlayerMP)) {
                return;
            }
            if (!ServerHelper.this.locked) {
                ServerHelper.this.locked = true;
            }
            UUID uuid = PlayerHelper.getPlayerUUID(event.player);
            if (!ServerHelper.this.playerData.keySet().contains(uuid)) {
                ElecPlayer player = new ElecPlayer(uuid);
                player.setExtendedProperties(ServerHelper.this.extendedPropertiesList);
                player.readFromNBT(new NBTTagCompound());
                ServerHelper.this.playerData.put(uuid, player);
            }
            ((ElecPlayer)ServerHelper.this.playerData.get(uuid)).setOnline(true);
        }

        @SubscribeEvent
        public void onPlayerDisconnected(PlayerEvent.PlayerLoggedOutEvent event) {
            if (!(event.player instanceof EntityPlayerMP)) {
                return;
            }
            ElecPlayer player = (ElecPlayer)ServerHelper.this.playerData.get(PlayerHelper.getPlayerUUID(event.player));
            if (player == null) {
                for (int i = 0; i < 30; ++i) {
                    ElecCore.logger.error("A player disconnected from the server without connecting first!");
                    ElecCore.logger.error("Player: " + event.player.getDisplayName());
                }
                ServerHelper.this.investigateErrors(true);
                return;
            }
            player.setOnline(false);
        }
    }
}

