/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import elec332.core.network.AbstractPacket;
import elec332.core.util.BlockLoc;
import elec332.core.util.NBTHelper;
import elec332.core.world.WorldHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public abstract class AbstractPacketTileAction
extends AbstractPacket {
    public AbstractPacketTileAction() {
    }

    public AbstractPacketTileAction(TileEntity tile, NBTTagCompound message) {
        this(tile, message, 0);
    }

    public AbstractPacketTileAction(TileEntity tile, NBTTagCompound message, int id) {
        super(new NBTHelper(new BlockLoc(tile).toNBT(new NBTTagCompound())).addToTag((NBTBase)message, "data").addToTag(id, "id").toNBT());
    }

    @Override
    public IMessage onMessage(AbstractPacket message, MessageContext ctx) {
        BlockLoc loc = new BlockLoc(message.networkPackageObject);
        int i = message.networkPackageObject.func_74762_e("id");
        NBTTagCompound data = message.networkPackageObject.func_74775_l("data");
        if (ctx.side == Side.CLIENT) {
            return this.processClient(loc, i, data, ctx);
        }
        this.processPacket(WorldHelper.getTileAt((IBlockAccess)ctx.getServerHandler().field_147369_b.func_71121_q(), loc), i, data, ctx);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private IMessage processClient(BlockLoc loc, int id, NBTTagCompound data, MessageContext ctx) {
        this.processPacket(WorldHelper.getTileAt((IBlockAccess)Minecraft.func_71410_x().field_71441_e, loc), id, data, ctx);
        return null;
    }

    public abstract void processPacket(TileEntity var1, int var2, NBTTagCompound var3, MessageContext var4);
}

