/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import elec332.core.baseclasses.tileentity.IInventoryTile;
import elec332.core.baseclasses.tileentity.TileBase;
import elec332.core.compat.handlers.WailaCompatHandler;
import elec332.core.main.ElecCore;
import elec332.core.multiblock.AbstractMultiBlock;
import elec332.core.multiblock.IMultiBlock;
import elec332.core.multiblock.IMultiBlockTile;
import elec332.core.multiblock.MultiBlockData;
import elec332.core.multiblock.MultiBlockRegistry;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractMultiBlockTile
extends TileBase
implements IMultiBlockTile,
IInventoryTile,
WailaCompatHandler.IWailaInfoTile {
    private MultiBlockData multiBlockData;

    public AbstractMultiBlockTile(MultiBlockRegistry registry) {
        this.multiBlockData = new MultiBlockData(this, registry);
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return this.getMultiBlock() == null ? super.onBlockActivated(player, side, hitX, hitY, hitZ) : this.getMultiBlock().onAnyBlockActivated(player);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.multiBlockData.writeToNBT(tagCompound);
        if (this.getMultiBlock() != null && this.getMultiBlock().isSaveDelegate(this)) {
            this.getMultiBlock().writeToNBT(tagCompound);
        }
    }

    @Override
    public void func_145839_a(final NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.multiBlockData.readFromNBT(tagCompound);
        ElecCore.tickHandler.registerCall(new Runnable(){

            @Override
            public void run() {
                if (AbstractMultiBlockTile.this.getMultiBlock() != null && AbstractMultiBlockTile.this.getMultiBlock().isSaveDelegate(AbstractMultiBlockTile.this)) {
                    AbstractMultiBlockTile.this.getMultiBlock().readFromNBT(tagCompound);
                }
            }
        }, this.func_145831_w());
    }

    @Override
    public void setMultiBlock(IMultiBlock multiBlock, ForgeDirection facing, String structure) {
        this.multiBlockData.setMultiBlock(multiBlock, facing, structure);
    }

    @Override
    public void invalidateMultiBlock() {
        this.multiBlockData.invalidateMultiBlock();
    }

    @Override
    public boolean isValidMultiBlock() {
        return this.multiBlockData.isValidMultiBlock();
    }

    @Override
    public String getStructureIdentifier() {
        return this.multiBlockData.getStructureIdentifier();
    }

    @Override
    public ForgeDirection getMultiBlockFacing() {
        return this.multiBlockData.getFacing();
    }

    @Override
    public AbstractMultiBlock getMultiBlock() {
        return (AbstractMultiBlock)this.multiBlockData.getMultiBlock();
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.multiBlockData.tileEntityValidate();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.multiBlockData.tileEntityChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.multiBlockData.tileEntityInvalidate();
    }

    @Override
    public Container getGuiServer(EntityPlayer player) {
        return this.getMultiBlock() == null ? null : this.getMultiBlock().getGuiServer(player);
    }

    @Override
    public Object getGuiClient(EntityPlayer player) {
        return this.getMultiBlock() == null ? null : this.getMultiBlock().getGuiClient(player);
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (this.getMultiBlock() != null) {
            return this.getMultiBlock().getWailaBody(itemStack, currentTip, accessor, config);
        }
        return currentTip;
    }

    @Override
    public NBTTagCompound getWailaTag(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        if (this.getMultiBlock() != null) {
            return this.getMultiBlock().getWailaTag(player, tile, tag, world, x, y, z);
        }
        return tag;
    }
}

