/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.widget;

import elec332.core.client.inventory.IResourceLocationProvider;
import elec332.core.client.render.RenderHelper;
import elec332.core.inventory.tooltip.ToolTip;
import elec332.core.inventory.widget.Widget;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class FluidTankWidget
extends Widget {
    private FluidTank tank;
    private FluidStack fluidStack;
    private int capacity;

    public FluidTankWidget(int x, int y, int u, int v, int width, int height, FluidTank tank) {
        super(x, y, u, v, width, height);
        this.tank = tank;
    }

    @Override
    public void detectAndSendChanges(List<ICrafting> crafters) {
        if (this.capacity != this.tank.getCapacity() || this.nullityDiffers(this.fluidStack, this.tank.getFluid()) || this.fluidStack != null && !this.fluidStack.isFluidStackIdentical(this.tank.getFluid())) {
            for (ICrafting iCrafting : crafters) {
                if (!(iCrafting instanceof EntityPlayerMP)) continue;
                NBTTagCompound tag = new NBTTagCompound();
                if (this.tank.getFluid() != null) {
                    this.tank.getFluid().writeToNBT(tag);
                }
                tag.func_74768_a("capacity_TANK", this.tank.getCapacity());
                this.sendNBTChangesToPlayer((EntityPlayerMP)iCrafting, tag);
            }
            this.capacity = this.tank.getCapacity();
            this.fluidStack = this.tank.getFluid() == null ? null : this.tank.getFluid().copy();
        }
    }

    @Override
    public ToolTip getToolTip() {
        String fluid = this.fluidStack == null || this.fluidStack.getFluid() == null ? null : this.fluidStack.getFluid().getName();
        int amount = this.fluidStack == null ? 0 : this.fluidStack.amount;
        return new ToolTip(new ToolTip.ColouredString("Fluid: " + fluid + "  Amount: " + amount));
    }

    @Override
    public void readNBTChangesFromPacket(NBTTagCompound tagCompound) {
        this.fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
        this.capacity = tagCompound.func_74762_e("capacity_TANK");
    }

    @Override
    public void draw(Gui gui, int guiX, int guiY, int mouseX, int mouseY) {
        if (this.capacity == 0) {
            return;
        }
        if (this.fluidStack == null || this.fluidStack.getFluid() == null || this.fluidStack.amount <= 0) {
            return;
        }
        IIcon fluidIcon = RenderHelper.getFluidTexture(this.fluidStack.getFluid(), false);
        float scale = (float)this.fluidStack.amount / (float)this.capacity;
        this.bindTexture(RenderHelper.getBlocksResourceLocation());
        for (int col = 0; col < this.width / 16; ++col) {
            for (int row = 0; row <= this.height / 16; ++row) {
                gui.func_94065_a(guiX + this.x + col * 16, guiY + this.y + row * 16 - 1, fluidIcon, 16, 16);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(((IResourceLocationProvider)gui).getBackgroundImageLocation());
        gui.func_73729_b(guiX + this.x, guiY + this.y - 1, this.x, this.y - 1, this.width, this.height - (int)Math.floor((float)this.height * scale) + 1);
        gui.func_73729_b(guiX + this.x, guiY + this.y, this.u, this.v, this.width, this.height);
    }
}

