/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.helper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OredictHelper {
    private static List<String> allOres = Lists.newArrayList();
    private static List<String> allIngots = Lists.newArrayList();

    public static void initLists() {
        for (String s : OreDictionary.getOreNames()) {
            if (s.contains("ore")) {
                allOres.add(s);
                continue;
            }
            if (!s.contains("ingot")) continue;
            allIngots.add(s);
        }
    }

    public static List<String> getAllOres() {
        return ImmutableList.copyOf(allOres);
    }

    public static List<String> getAllIngots() {
        return ImmutableList.copyOf(allIngots);
    }

    public static String concatOreName(String oreName) {
        return oreName.replace("ore", "");
    }

    public static String concatIngotName(String ingotName) {
        return ingotName.replace("ingot", "");
    }

    public static boolean oreExists(ItemStack stack) {
        return OreDictionary.getOres((String)OredictHelper.getOreName(stack)).size() > 0;
    }

    public static String getOreName(ItemStack stack) {
        return OreDictionary.getOreName((int)OredictHelper.getOreID(stack));
    }

    public static int getOreID(ItemStack stack) {
        return OreDictionary.getOreID((ItemStack)stack);
    }

    @Deprecated
    public static Item getFirstOredictEntry(String Oredictname) {
        return OredictHelper.getOredictEntry(0, Oredictname);
    }

    @Deprecated
    public static Item getOredictEntry(int number, String Oredictname) {
        return ((ItemStack)OreDictionary.getOres((String)Oredictname).get(number)).func_77973_b();
    }

    @Deprecated
    public static int getFirstOredictItemDamage(String Oredictname) {
        return OredictHelper.getOredictItemDamage(0, Oredictname);
    }

    @Deprecated
    public static int getOredictItemDamage(int number, String OreDictname) {
        return ((ItemStack)OreDictionary.getOres((String)OreDictname).get(number)).func_77960_j();
    }

    @Deprecated
    public static ItemStack getFirstOreDictItemWithMeta(String Oredictname) {
        return OredictHelper.getOreDictItemWithMeta(Oredictname, 0);
    }

    @Deprecated
    public static ItemStack getOreDictItemWithMeta(String Oredictname, int entry) {
        return new ItemStack(OredictHelper.getOredictEntry(entry, Oredictname), 1, OredictHelper.getOredictItemDamage(entry, Oredictname));
    }

    static {
        OredictHelper.initLists();
    }
}

