/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import elec332.core.main.ElecCore;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.world.World;

public class TickHandler {
    private Queue<Runnable> toGo = new ArrayDeque<Runnable>();
    private Queue<Runnable> client = new ArrayDeque<Runnable>();
    private Queue<Runnable> server = new ArrayDeque<Runnable>();

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        this.processSingleTicks((TickEvent)event, this.server);
        this.processSingleTicks((TickEvent)event, this.toGo);
    }

    @SubscribeEvent
    public void onTickClient(TickEvent.ClientTickEvent event) {
        this.processSingleTicks((TickEvent)event, this.client);
        this.processSingleTicks((TickEvent)event, this.toGo);
    }

    @Deprecated
    public void registerCall(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        this.toGo.add(runnable);
        ElecCore.logger.info("##############################################");
        ElecCore.logger.info("## Error, someone is using an unsafe method!##");
        ElecCore.logger.info("##############################################");
        ElecCore.logger.info("Source: " + runnable.getClass().getCanonicalName());
    }

    public void registerCall(Runnable runnable, World world) {
        if (world == null) {
            this.registerCall(runnable);
            return;
        }
        if (!world.field_72995_K) {
            this.registerCallServer(runnable);
        } else {
            this.registerCallClient(runnable);
        }
    }

    public void registerCallServer(Runnable runnable) {
        this.server.add(runnable);
    }

    public void registerCallClient(Runnable runnable) {
        this.client.add(runnable);
    }

    private void processSingleTicks(TickEvent event, Queue<Runnable> process) {
        if (event.phase == TickEvent.Phase.START && !process.isEmpty()) {
            Runnable runnable = process.poll();
            while (runnable != null) {
                runnable.run();
                runnable = process.poll();
            }
            process.clear();
        }
    }
}

