/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.explosion;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.Event;
import elec332.core.util.BlockLoc;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;

public abstract class AbstractExplosion
extends Explosion {
    private final World world;
    private final BlockLoc location;
    private List<Entity> entitiesInRange;

    public AbstractExplosion(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
        this.world = world;
        this.location = new BlockLoc((int)this.field_77284_b, (int)this.field_77285_c, (int)this.field_77282_d);
        this.entitiesInRange = Lists.newArrayList();
    }

    public void explode() {
        ExplosionEvent.Detonate event = new ExplosionEvent.Detonate(this.world, (Explosion)this, null);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            this.preExplode();
            this.doExplode();
            this.postExplode();
        }
    }

    protected abstract void preExplode();

    protected abstract void doExplode();

    protected abstract void postExplode();

    protected void damageEntities(float radius, float power) {
        if (!this.world.field_72995_K) {
            BlockLoc minCoord = this.location.copy();
            minCoord.add(-(radius *= 2.0f) - 1.0f);
            BlockLoc maxCoord = this.location.copy();
            maxCoord.add(radius + 1.0f);
            List allEntities = this.world.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)minCoord.xCoord, (double)minCoord.yCoord, (double)minCoord.zCoord, (double)maxCoord.xCoord, (double)maxCoord.yCoord, (double)maxCoord.zCoord));
            Collections.sort(allEntities, new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    return (int)(AbstractExplosion.this.getDistance(o1) - AbstractExplosion.this.getDistance(o2));
                }
            });
            for (Entity entity : allEntities) {
                double distance = this.getDistance(entity) / (double)radius;
                if (!(distance <= 1.0)) continue;
                double xDifference = entity.field_70165_t - (double)this.location.xCoord;
                double yDifference = entity.field_70163_u - (double)this.location.yCoord;
                double zDifference = entity.field_70161_v - (double)this.location.zCoord;
                double d1 = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
                xDifference /= d1;
                yDifference /= d1;
                zDifference /= d1;
                double density = this.world.func_72842_a(Vec3.func_72443_a((double)this.location.xCoord, (double)this.location.yCoord, (double)this.location.zCoord), entity.field_70121_D);
                double d2 = (1.0 - distance) * density;
                int damage = (int)((d2 * d2 + d2) / 2.0 * 8.0 * (double)power + 1.0);
                entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)damage);
                entity.field_70159_w += xDifference * d2;
                entity.field_70181_x += yDifference * d2;
                entity.field_70179_y += zDifference * d2;
            }
        }
    }

    private double getDistance(Entity entity) {
        return entity.func_70011_f((double)this.location.xCoord, (double)this.location.yCoord, (double)this.location.zCoord);
    }

    public final float getRadius() {
        return this.field_77280_f;
    }

    public final BlockLoc getLocation() {
        return this.location;
    }

    public final World getWorld() {
        return this.world;
    }

    public void func_77278_a() {
    }

    public void func_77279_a(boolean p_77279_1_) {
    }
}

