/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.effects.api.ability;

import elec332.core.effects.api.ability.WrappedAbility;
import java.awt.Color;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.StatCollector;

public class Ability {
    private final String name;
    private int maxLevel;
    private Color renderColor;
    private Type type;
    private Ability[] components;

    public Ability(String name) {
        this.name = name;
        this.maxLevel = Integer.MAX_VALUE;
        this.renderColor = Color.WHITE;
        this.type = Type.NEUTRAL;
        this.components = new Ability[0];
    }

    public final Ability setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
        return this;
    }

    public final Ability setRenderColor(Color renderColor) {
        this.renderColor = renderColor;
        return this;
    }

    public final Ability setType(Type type) {
        this.type = type;
        return this;
    }

    public final Ability setComponents(Ability[] components) {
        this.components = components;
        return this;
    }

    public boolean isInstant() {
        return false;
    }

    public void onEffectAddedToEntity(EntityLivingBase entity, WrappedAbility activeEffect) {
    }

    public void updateEffectOnEntity(EntityLivingBase entity, WrappedAbility activeEffect) {
    }

    public void onEffectRemovedFromEntity(EntityLivingBase entity, WrappedAbility activeEffect) {
    }

    public final String getName() {
        return this.name;
    }

    public String getLocalisedName() {
        return StatCollector.func_74838_a((String)("ability." + this.name));
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public Color getRenderColor() {
        return this.renderColor;
    }

    public static enum Type {
        GOOD,
        NEUTRAL,
        BAD;

    }
}

