/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.render;

import elec332.core.util.BlockSide;
import elec332.core.util.DirectionHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public final class SidedBlockRenderingCache {
    private final int types;
    private final int states;
    private final ITextureHandler textureHandler;
    private IIcon[][][] icons;

    public SidedBlockRenderingCache(ITextureHandler textureHandler) {
        this(textureHandler, 1);
    }

    public SidedBlockRenderingCache(ITextureHandler textureHandler, int types) {
        this(textureHandler, types, 1);
    }

    public SidedBlockRenderingCache(ITextureHandler textureHandler, int types, int states) {
        this.types = types;
        this.states = states;
        this.textureHandler = textureHandler;
        this.icons = new IIcon[types][states][6];
    }

    public final IIcon getIconForWorldRendering(IBlockAccess iba, int x, int y, int z, int side) {
        int meta = iba.func_72805_g(x, y, z);
        return this.textureHandler.getIconForWorldRendering(iba, x, y, z, side, meta, this);
    }

    public final IIcon getIconForInventoryRendering(int type, int side) {
        return this.getIconDirectly(type, 0, DirectionHelper.ROTATION_MATRIX_YAW[2][side]);
    }

    public final void registerTextures(IIconRegister register) {
        for (int i = 0; i < this.types; ++i) {
            for (int j = 0; j < this.states; ++j) {
                for (BlockSide side : BlockSide.values()) {
                    this.icons[i][j][side.getDefaultSide()] = register.func_94245_a(this.textureHandler.getTextureForSide(side, i, j));
                }
            }
        }
    }

    public IIcon getIconForNormalRendering(int type, int side) {
        return this.getIconForInventoryRendering(type, side);
    }

    public IIcon getIconForBlockFacing(int requestedSide, ForgeDirection directionBlockIsFacing) {
        return this.getIconForBlockFacing(requestedSide, directionBlockIsFacing, 0);
    }

    public IIcon getIconForBlockFacing(int requestedSide, ForgeDirection directionBlockIsFacing, int type) {
        return this.getIconForBlockFacing(requestedSide, directionBlockIsFacing, type, 0);
    }

    public IIcon getIconForBlockFacing(int requestedSide, ForgeDirection directionBlockIsFacing, int type, int state) {
        return this.getIconDirectly(type, state, DirectionHelper.ROTATION_MATRIX_YAW[DirectionHelper.getNumberForDirection(directionBlockIsFacing)][requestedSide]);
    }

    public IIcon getIconDirectly(int type, int state, int side) {
        return this.icons[type][state][side];
    }

    public static interface ITextureHandler {
        public String getTextureForSide(BlockSide var1, int var2, int var3);

        public IIcon getIconForWorldRendering(IBlockAccess var1, int var2, int var3, int var4, int var5, int var6, SidedBlockRenderingCache var7);
    }
}

