/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.baseclasses.tileentity;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import elec332.core.main.ElecCore;
import elec332.core.network.IElecCoreNetworkTile;
import elec332.core.network.PacketReRenderBlock;
import elec332.core.network.PacketTileDataToServer;
import elec332.core.server.ServerHelper;
import elec332.core.util.BlockLoc;
import elec332.core.util.DirectionHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBase
extends TileEntity
implements IElecCoreNetworkTile {
    public void func_145829_t() {
        super.func_145829_t();
        ElecCore.tickHandler.registerCall(new Runnable(){

            @Override
            public void run() {
                if (TileBase.this.func_145831_w().func_72899_e(TileBase.this.field_145851_c, TileBase.this.field_145848_d, TileBase.this.field_145849_e)) {
                    TileBase.this.onTileLoaded();
                }
            }
        }, this.func_145831_w());
    }

    public void func_145843_s() {
        if (!this.func_145837_r()) {
            super.func_145843_s();
            this.onTileUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.onTileUnloaded();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readItemStackNBT(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.writeToItemStack(tagCompound);
    }

    public void readItemStackNBT(NBTTagCompound tagCompound) {
    }

    public void writeToItemStack(NBTTagCompound tagCompound) {
    }

    public void onTileLoaded() {
    }

    public void onTileUnloaded() {
    }

    public void notifyNeighboursOfDataChange() {
        this.func_70296_d();
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
    }

    public ForgeDirection getTileFacing() {
        return DirectionHelper.getDirectionFromNumber(this.func_145832_p());
    }

    public BlockLoc myLocation() {
        return new BlockLoc(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean timeCheck() {
        return this.field_145850_b.func_82737_E() % 32L == 0L;
    }

    protected void setBlockMetadataWithNotify(int meta) {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 2);
        this.notifyNeighboursOfDataChange();
    }

    public int getLightOpacity() {
        return 0;
    }

    public int getLightValue() {
        return 0;
    }

    public void onBlockRemoved() {
    }

    public void onBlockAdded() {
    }

    public void onBlockPlacedBy(EntityLivingBase entityLiving, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readItemStackNBT(stack.func_77978_p());
        }
        this.setMetaForFacingOnPlacement(entityLiving);
    }

    public void onNeighborBlockChange(Block block) {
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public ArrayList<ItemStack> getDrops(int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{this.itemStackFromNBTTile()});
    }

    public void onWrenched(ForgeDirection forgeDirection) {
        DirectionHelper.setFacing_YAW(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, forgeDirection);
    }

    public boolean openGui(EntityPlayer player, Object mod, int guiID) {
        player.openGui(mod, guiID, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    protected ItemStack itemStackFromNBTTile() {
        NBTTagCompound compound = new NBTTagCompound();
        ItemStack ret = new ItemStack(this.func_145838_q(), 1, this.func_145832_p());
        this.writeToItemStack(compound);
        ret.func_77982_d(compound);
        return ret;
    }

    protected void setMetaForFacingOnPlacement(EntityLivingBase entityLivingBase) {
        this.setBlockMetadataWithNotify(DirectionHelper.getDirectionNumberOnPlacement(entityLivingBase));
    }

    public void reRenderBlock() {
        if (!this.field_145850_b.field_72995_K) {
            ServerHelper.instance.sendMessageToAllPlayersWatchingBlock(this.field_145850_b, this.field_145851_c, this.field_145849_e, new PacketReRenderBlock(this), ElecCore.networkHandler);
        } else {
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void syncData() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendPacketToServer(int ID, NBTTagCompound data) {
        ElecCore.networkHandler.getNetworkWrapper().sendToServer((IMessage)new PacketTileDataToServer(this, ID, data));
    }

    @Override
    public void onPacketReceivedFromClient(EntityPlayerMP sender, int ID, NBTTagCompound data) {
    }

    public void sendPacket(int ID, NBTTagCompound data) {
        for (EntityPlayerMP player : ServerHelper.instance.getAllPlayersWatchingBlock(this.field_145850_b, this.field_145851_c, this.field_145849_e)) {
            this.sendPacketTo(player, ID, data);
        }
    }

    public void sendPacketTo(EntityPlayerMP player, int ID, NBTTagCompound data) {
        player.field_71135_a.func_147359_a((Packet)new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, ID, data));
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        if (packet.func_148853_f() == 0) {
            this.func_145839_a(packet.func_148857_g());
        } else {
            this.onDataPacket(packet.func_148853_f(), packet.func_148857_g());
        }
    }

    @Override
    public void onDataPacket(int id, NBTTagCompound tag) {
    }
}

