/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.printer.registry;

import com.github.lunatrius.schematica.client.printer.registry.IExtraClick;
import com.github.lunatrius.schematica.client.printer.registry.PlacementData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PlacementRegistry {
    public static final PlacementRegistry INSTANCE = new PlacementRegistry();
    private final Map<Class<? extends Block>, PlacementData> classPlacementMap = new HashMap<Class<? extends Block>, PlacementData>();
    private final Map<Block, PlacementData> blockPlacementMap = new HashMap<Block, PlacementData>();
    private final Map<Item, PlacementData> itemPlacementMap = new HashMap<Item, PlacementData>();

    public void populatePlacementMaps() {
        this.classPlacementMap.clear();
        this.blockPlacementMap.clear();
        this.itemPlacementMap.clear();
        IExtraClick extraClickDoubleSlab = new IExtraClick(){

            @Override
            public int getExtraClicks(Block block, int metadata) {
                return ((BlockSlab)block).func_149662_c() ? 1 : 0;
            }
        };
        this.addPlacementMapping(BlockButton.class, new PlacementData(PlacementData.PlacementType.BLOCK, -1, -1, 3, 4, 1, 2).setMaskMeta(7));
        this.addPlacementMapping(BlockChest.class, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 2, 5, 4));
        this.addPlacementMapping(BlockDispenser.class, new PlacementData(PlacementData.PlacementType.PISTON, 0, 1, 2, 3, 4, 5).setMaskMeta(7));
        this.addPlacementMapping(BlockEnderChest.class, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 2, 5, 4));
        this.addPlacementMapping(BlockFurnace.class, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 2, 5, 4));
        this.addPlacementMapping(BlockHopper.class, new PlacementData(PlacementData.PlacementType.BLOCK, 0, 1, 2, 3, 4, 5).setMaskMeta(7));
        this.addPlacementMapping(BlockPistonBase.class, new PlacementData(PlacementData.PlacementType.PISTON, 0, 1, 2, 3, 4, 5).setMaskMeta(7));
        this.addPlacementMapping(BlockPumpkin.class, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 0, 2, 3, 1).setMaskMeta(15));
        this.addPlacementMapping(BlockRotatedPillar.class, new PlacementData(PlacementData.PlacementType.BLOCK, 0, 0, 8, 8, 4, 4).setMaskMeta(12));
        this.addPlacementMapping(BlockStairs.class, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 2, 1, 0).setOffset(4, 0.0f, 1.0f).setMaskMeta(3));
        this.addPlacementMapping(BlockTorch.class, new PlacementData(PlacementData.PlacementType.BLOCK, 5, -1, 3, 4, 1, 2).setMaskMeta(15));
        this.addPlacementMapping(Blocks.field_150346_d, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping(Blocks.field_150344_f, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping(Blocks.field_150322_A, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping(Blocks.field_150325_L, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping((Block)Blocks.field_150327_N, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping((Block)Blocks.field_150328_O, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping((Block)Blocks.field_150334_T, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setExtraClick(extraClickDoubleSlab));
        this.addPlacementMapping((Block)Blocks.field_150333_U, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setOffset(8, 0.0f, 1.0f).setMaskMeta(7));
        this.addPlacementMapping((Block)Blocks.field_150399_cn, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping(Blocks.field_150468_ap, new PlacementData(PlacementData.PlacementType.BLOCK, -1, -1, 3, 2, 5, 4));
        this.addPlacementMapping(Blocks.field_150442_at, new PlacementData(PlacementData.PlacementType.BLOCK, -1, -1, 3, 4, 1, 2).setMaskMeta(7));
        this.addPlacementMapping(Blocks.field_150431_aC, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping(Blocks.field_150415_aT, new PlacementData(PlacementData.PlacementType.BLOCK, -1, -1, 1, 0, 3, 2).setOffset(8, 0.0f, 1.0f).setMaskMeta(3));
        this.addPlacementMapping(Blocks.field_150418_aU, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping(Blocks.field_150417_aV, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping((Block)Blocks.field_150479_bC, new PlacementData(PlacementData.PlacementType.BLOCK, -1, -1, 0, 2, 3, 1).setMaskMeta(3));
        this.addPlacementMapping(Blocks.field_150371_ca, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping(Blocks.field_150396_be, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 2, 0, 1, 3).setMaskMeta(3));
        this.addPlacementMapping((Block)Blocks.field_150373_bw, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping((Block)Blocks.field_150376_bx, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]).setOffset(8, 0.0f, 1.0f).setMaskMeta(7).setExtraClick(extraClickDoubleSlab));
        this.addPlacementMapping(Blocks.field_150467_bQ, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 1, 3, 0, 2).setMaskMeta(3));
        this.addPlacementMapping(Blocks.field_150406_ce, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping(Blocks.field_150404_cg, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping((Block)Blocks.field_150397_co, new PlacementData(PlacementData.PlacementType.BLOCK, new int[0]));
        this.addPlacementMapping(Items.field_151135_aq, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 1, 2, 0).setMaskMeta(7));
        this.addPlacementMapping(Items.field_151139_aw, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 3, 1, 2, 0).setMaskMeta(7));
        this.addPlacementMapping(Items.field_151107_aW, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 0, 2, 3, 1).setMaskMeta(3));
        this.addPlacementMapping(Items.field_151132_bS, new PlacementData(PlacementData.PlacementType.PLAYER, -1, -1, 0, 2, 3, 1).setMaskMeta(3));
    }

    public PlacementData addPlacementMapping(Class<? extends Block> clazz, PlacementData data) {
        if (clazz == null || data == null) {
            return null;
        }
        return this.classPlacementMap.put(clazz, data);
    }

    public PlacementData addPlacementMapping(Block block, PlacementData data) {
        if (block == null || data == null) {
            return null;
        }
        return this.blockPlacementMap.put(block, data);
    }

    public PlacementData addPlacementMapping(Item item, PlacementData data) {
        if (item == null || data == null) {
            return null;
        }
        return this.itemPlacementMap.put(item, data);
    }

    public PlacementData getPlacementData(Block block, ItemStack itemStack) {
        PlacementData placementDataItem = this.itemPlacementMap.get(itemStack.func_77973_b());
        if (placementDataItem != null) {
            return placementDataItem;
        }
        PlacementData placementDataBlock = this.blockPlacementMap.get(block);
        if (placementDataBlock != null) {
            return placementDataBlock;
        }
        for (Class<? extends Block> clazz : this.classPlacementMap.keySet()) {
            if (!clazz.isInstance(block)) continue;
            return this.classPlacementMap.get(clazz);
        }
        return null;
    }

    static {
        INSTANCE.populatePlacementMaps();
    }
}

