/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.machines.tools;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import org.dave.CompactMachines.CompactMachines;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.tileentity.TileEntityMachine;

public class ChunkLoadingTools {
    public static void disableMachine(TileEntityMachine machine) {
        ChunkLoadingTools.disableMachine(machine.coords);
    }

    public static void disableMachine(int coords) {
        if (coords == -1) {
            return;
        }
        World worldObj = CompactMachines.instance.machineHandler.getWorld();
        ImmutableSetMultimap existingTickets = ForgeChunkManager.getPersistentChunksFor((World)worldObj);
        UnmodifiableIterator ticketIterator = existingTickets.values().iterator();
        ArrayList<Integer> visitedTickets = new ArrayList<Integer>();
        while (ticketIterator.hasNext()) {
            ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)ticketIterator.next();
            if (visitedTickets.contains(ticket.hashCode())) continue;
            visitedTickets.add(ticket.hashCode());
            NBTTagCompound data = ticket.getModData();
            if (!data.func_74764_b("coords")) continue;
            int[] nbtCoords = data.func_74759_k("coords");
            boolean foundMatch = false;
            for (int i = 0; i < nbtCoords.length; ++i) {
                if (nbtCoords[i] != coords) continue;
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(coords * ConfigurationHandler.cubeDistance >> 4, 0));
                int usedChunks = 0;
                if (data.func_74764_b("usedChunks")) {
                    usedChunks = data.func_74762_e("usedChunks");
                }
                if (usedChunks < 2) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                } else {
                    nbtCoords[i] = -1;
                    data.func_74768_a("usedChunks", usedChunks - 1);
                    data.func_74783_a("coords", nbtCoords);
                }
                foundMatch = true;
                break;
            }
            if (!foundMatch) continue;
            break;
        }
        CompactMachines.instance.machineHandler.func_76185_a();
    }

    public static boolean isCoordChunkLoaded(TileEntityMachine machine) {
        return ChunkLoadingTools.isCoordChunkLoaded(machine.coords);
    }

    public static boolean isCoordChunkLoaded(int coords) {
        if (coords == -1) {
            return false;
        }
        World worldObj = CompactMachines.instance.machineHandler.getWorld();
        ImmutableSetMultimap existingTickets = ForgeChunkManager.getPersistentChunksFor((World)worldObj);
        UnmodifiableIterator ticketIterator = existingTickets.values().iterator();
        ArrayList<Integer> visitedTickets = new ArrayList<Integer>();
        while (ticketIterator.hasNext()) {
            ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)ticketIterator.next();
            if (visitedTickets.contains(ticket.hashCode())) continue;
            visitedTickets.add(ticket.hashCode());
            NBTTagCompound data = ticket.getModData();
            if (!data.func_74764_b("coords")) continue;
            int[] nbtCoords = data.func_74759_k("coords");
            for (int i = 0; i < nbtCoords.length; ++i) {
                if (nbtCoords[i] != coords) continue;
                return true;
            }
        }
        return false;
    }

    public static void forceChunkLoad(int coord) {
        int i;
        World worldObj = CompactMachines.instance.machineHandler.getWorld();
        if (worldObj == null) {
            return;
        }
        if (ConfigurationHandler.chunkLoadingMode == 0) {
            return;
        }
        ForgeChunkManager.Ticket chunkTicket = null;
        ImmutableSetMultimap existingTickets = ForgeChunkManager.getPersistentChunksFor((World)worldObj);
        UnmodifiableIterator ticketIterator = existingTickets.values().iterator();
        ArrayList<Integer> visitedTickets = new ArrayList<Integer>();
        while (ticketIterator.hasNext()) {
            ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)ticketIterator.next();
            if (visitedTickets.contains(ticket.hashCode())) continue;
            visitedTickets.add(ticket.hashCode());
            NBTTagCompound data = ticket.getModData();
            if (!data.func_74764_b("coords")) continue;
            int usedChunks = 0;
            if (data.func_74764_b("usedChunks")) {
                usedChunks = data.func_74762_e("usedChunks");
            }
            if (usedChunks >= ticket.getMaxChunkListDepth()) continue;
            chunkTicket = ticket;
            break;
        }
        if (chunkTicket == null) {
            chunkTicket = ForgeChunkManager.requestTicket((Object)CompactMachines.instance, (World)worldObj, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (chunkTicket == null) {
            return;
        }
        NBTTagCompound data = chunkTicket.getModData();
        int usedChunks = 0;
        if (data.func_74764_b("usedChunks")) {
            usedChunks = data.func_74762_e("usedChunks");
        }
        int[] nbtCoords = new int[chunkTicket.getMaxChunkListDepth()];
        if (data.func_74764_b("coords")) {
            nbtCoords = data.func_74759_k("coords");
            if (nbtCoords.length > chunkTicket.getMaxChunkListDepth()) {
                // empty if block
            }
        } else {
            for (i = 0; i < nbtCoords.length; ++i) {
                nbtCoords[i] = -1;
            }
        }
        for (i = 0; i < nbtCoords.length; ++i) {
            if (nbtCoords[i] != -1) continue;
            nbtCoords[i] = coord;
            break;
        }
        data.func_74783_a("coords", nbtCoords);
        data.func_74768_a("usedChunks", usedChunks + 1);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(coord * ConfigurationHandler.cubeDistance >> 4, 0));
    }
}

