/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.integration.gas;

import cpw.mods.fml.common.Optional;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.integration.AbstractHoppingStorage;
import org.dave.CompactMachines.integration.gas.ExtendedGasTank;
import org.dave.CompactMachines.reference.Reference;

@Optional.Interface(iface="mekanism.api.gas.IGasHandler", modid="Mekanism")
public class GasSharedStorage
extends AbstractHoppingStorage
implements IGasHandler {
    private ExtendedGasTank tank;

    public GasSharedStorage(SharedStorageHandler storageHandler, int coord, int side) {
        super(storageHandler, coord, side);
        if (Reference.MEK_AVAILABLE) {
            this.tank = new ExtendedGasTank(){

                @Override
                public void onGasChanged() {
                    GasSharedStorage.this.setDirty();
                }
            };
        }
        this.max_cooldown = ConfigurationHandler.cooldownGas;
    }

    public GasStack getGasContents() {
        if (!ConfigurationHandler.enableIntegrationMekanism) {
            return null;
        }
        GasStack gas = this.tank.getGas();
        if (gas != null) {
            gas = gas.copy();
        }
        return gas;
    }

    public int receiveGas(ForgeDirection side, GasStack stack) {
        if (!ConfigurationHandler.enableIntegrationMekanism) {
            return 0;
        }
        return this.tank.receive(stack, true);
    }

    public GasStack drawGas(ForgeDirection side, int amount) {
        if (!ConfigurationHandler.enableIntegrationMekanism) {
            return null;
        }
        return this.tank.draw(amount, true);
    }

    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        return this.receiveGas(side, stack);
    }

    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return this.drawGas(side, amount);
    }

    public boolean canReceiveGas(ForgeDirection side, Gas gas) {
        if (!ConfigurationHandler.enableIntegrationMekanism) {
            return false;
        }
        return this.tank.canReceive(gas);
    }

    public boolean canDrawGas(ForgeDirection side, Gas gas) {
        if (!ConfigurationHandler.enableIntegrationMekanism) {
            return false;
        }
        return this.tank.canDraw(gas);
    }

    @Override
    public String type() {
        return "gas";
    }

    @Override
    public NBTTagCompound saveToTag() {
        NBTTagCompound compound = super.saveToTag();
        compound.func_74782_a("tank", (NBTBase)this.tank.write(new NBTTagCompound()));
        return compound;
    }

    @Override
    public void loadFromTag(NBTTagCompound tag) {
        super.loadFromTag(tag);
        this.tank.read(tag.func_74775_l("tank"));
    }

    @Override
    public void hopToTileEntity(TileEntity te, boolean opposite) {
        GasStack stack = this.tank.getGas();
        if (stack == null || stack.amount == 0) {
            return;
        }
        stack = stack.copy();
        if (te instanceof IGasHandler) {
            int received;
            IGasHandler gh = (IGasHandler)te;
            ForgeDirection hoppingSide = ForgeDirection.getOrientation((int)this.side);
            if (opposite) {
                hoppingSide = hoppingSide.getOpposite();
            }
            if (gh.canReceiveGas(hoppingSide, stack.getGas()) && (received = gh.receiveGas(hoppingSide, stack, true)) > 0) {
                this.tank.draw(received, true);
                te.func_70296_d();
            }
        }
    }
}

