/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.handler;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.util.concurrent.GenericFutureListener;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.dave.CompactMachines.CompactMachines;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.init.ModBlocks;
import org.dave.CompactMachines.machines.MachineSaveData;
import org.dave.CompactMachines.network.MessageConfiguration;
import org.dave.CompactMachines.network.PacketHandler;
import org.dave.CompactMachines.utility.LogHelper;

public class CMEventHandler {
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.itemStack.func_77973_b() instanceof ItemBlock) {
            ItemBlock itemblock = (ItemBlock)event.itemStack.func_77973_b();
            Block holding = itemblock.field_150939_a;
            if (holding == ModBlocks.interfaceblockcreative || holding == ModBlocks.innerwallcreative) {
                event.toolTip.add(EnumChatFormatting.DARK_GREEN + "-- Creative Mode Fake Block --");
                event.toolTip.add(EnumChatFormatting.RED + "You can only remove these blocks");
                event.toolTip.add(EnumChatFormatting.RED + "while holding an Atom Shrinking");
                event.toolTip.add(EnumChatFormatting.RED + "Module in Creative mode!");
            }
        }
    }

    @SubscribeEvent
    public void onClientConnect(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        if (!event.isLocal && event.handler instanceof NetHandlerPlayServer) {
            NetHandlerPlayServer nhps = (NetHandlerPlayServer)event.handler;
            EntityPlayerMP player = nhps.field_147369_b;
            LogHelper.info("Sending configuration to client: " + player.getDisplayName());
            event.manager.func_150725_a(PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageConfiguration()), new GenericFutureListener[0]);
        }
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (ConfigurationHandler.isServerConfig) {
            LogHelper.info("Unregistering dimension " + ConfigurationHandler.dimensionId + " on client side");
            DimensionManager.unregisterDimension((int)ConfigurationHandler.dimensionId);
            DimensionManager.unregisterProviderType((int)ConfigurationHandler.dimensionId);
            ConfigurationHandler.reload();
            ConfigurationHandler.isServerConfig = false;
            LogHelper.info("Restored original dimension id: " + ConfigurationHandler.dimensionId);
        }
    }

    @SubscribeEvent
    public void loadWorld(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == ConfigurationHandler.dimensionId) {
            LogHelper.info("Loading machine world!");
            MachineSaveData machineHandler = (MachineSaveData)event.world.field_72988_C.func_75742_a(MachineSaveData.class, "MachineHandler");
            if (machineHandler == null) {
                machineHandler = new MachineSaveData(event.world);
                machineHandler.func_76185_a();
            }
            machineHandler.setWorld(event.world);
            event.world.field_72988_C.func_75745_a("MachineHandler", (WorldSavedData)machineHandler);
            CompactMachines.instance.machineHandler = machineHandler;
        }
    }

    @SubscribeEvent
    public void playerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.toDim != ConfigurationHandler.dimensionId) {
            return;
        }
        if (event.player == null) {
            return;
        }
        if (ConfigurationHandler.allowEnterWithoutPSD) {
            return;
        }
        NBTTagCompound playerNBT = event.player.getEntityData();
        if (!playerNBT.func_74767_n("isUsingPSD")) {
            event.player.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 300, 2, false));
            event.player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 300, 5, false));
        } else {
            playerNBT.func_82580_o("isUsingPSD");
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("CompactMachines")) {
            ConfigurationHandler.saveConfiguration();
        }
    }
}

