/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.utils.Log;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import logisticspipes.api.ILPPipeTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeTransportItemsLogistics
extends PipeTransportItems {
    public static int getNumConnectedPipes(IPipeTile tile) {
        int count = 0;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!tile.isPipeConnected(o)) continue;
            ++count;
        }
        return count;
    }

    public static int getNumConnectedPipesExceptSide(IPipeTile tile, ForgeDirection sideToExclude) {
        int count = 0;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (sideToExclude == o || !tile.isPipeConnected(o)) continue;
            ++count;
        }
        return count;
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        ForgeDirection currentlyConnectedSide = this.container.pipe.getOpenOrientation().getOpposite();
        if (!currentlyConnectedSide.equals((Object)side) && PipeTransportItemsLogistics.getNumConnectedPipes((IPipeTile)this.container) != 0) {
            return false;
        }
        try {
            return this.pipelineEndsinLogisticsPipe(tile, side.getOpposite());
        }
        catch (StackOverflowError err) {
            Log.warn("Wow, that's a long, straight pipeline! Gave up looking for logistics pipes!");
            return false;
        }
    }

    public void switchSource() {
        int connectedSide = this.container.pipe.getOpenOrientation().getOpposite().ordinal();
        int newSide = 6;
        for (int i = connectedSide + 1; i <= connectedSide + 6; ++i) {
            ForgeDirection o = ForgeDirection.VALID_DIRECTIONS[i % 6];
            TileEntity tile = this.container.getTile(o);
            try {
                if (!this.pipelineEndsinLogisticsPipe(tile, o.getOpposite())) continue;
                newSide = o.ordinal();
                break;
            }
            catch (StackOverflowError err) {
                Log.warn("Wow, that's a long, straight pipeline! Gave up looking for logistics pipes!");
            }
        }
        if (newSide != ForgeDirection.UNKNOWN.ordinal() && connectedSide != ForgeDirection.UNKNOWN.ordinal() && connectedSide != newSide) {
            this.container.pipeConnectionsBuffer[connectedSide] = false;
            this.container.pipeConnectionsBuffer[newSide] = true;
            this.container.scheduleRenderUpdate();
        }
    }

    public boolean pipelineEndsinLogisticsPipe(TileEntity start, ForgeDirection sideConnectedToPrevPipe) {
        if (start instanceof ILPPipeTile) {
            return true;
        }
        if (start instanceof IPipeTile) {
            Pipe pipe = (Pipe)((IPipeTile)start).getPipe();
            if (!BlockGenericPipe.isValid((Pipe)pipe) || !(pipe.transport instanceof PipeTransportItems)) {
                return false;
            }
            if (PipeTransportItemsLogistics.getNumConnectedPipesExceptSide((IPipeTile)pipe.container, sideConnectedToPrevPipe) != 1) {
                return false;
            }
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                if (!pipe.container.isPipeConnected(o) || o == sideConnectedToPrevPipe) continue;
                return this.pipelineEndsinLogisticsPipe(((IPipeTile)start).getNeighborTile(o), o.getOpposite());
            }
        }
        return false;
    }
}

