/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeSwitch<pipeType extends PipeTransport>
extends APPipe<pipeType> {
    private final int textureIndex;

    public PipeSwitch(pipeType transport, Item item, int textureIndex) {
        super(transport, item);
        this.textureIndex = textureIndex;
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        return this.textureIndex + (this.canPipeConnect(null, direction) ? 0 : 1);
    }

    public boolean canConnectRedstone() {
        return true;
    }

    public void initialize() {
        super.initialize();
    }

    public void updateEntity() {
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.container.scheduleNeighborChange();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.container.getTile(direction);
            if (!(tile instanceof TileGenericPipe)) continue;
            ((TileGenericPipe)tile).scheduleNeighborChange();
        }
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        if (this.container == null) {
            return false;
        }
        World world = this.getWorld();
        return world != null && !world.func_72864_z(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
    }
}

