/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsPriorityInsertion
extends APPipe<PipeTransportItems> {
    public int[] sidePriorities = new int[]{1, 1, 1, 1, 1, 1};

    public PipeItemsPriorityInsertion(Item item) {
        super(new PipeTransportItems(), item);
    }

    @Override
    public int getIconIndex(ForgeDirection connection) {
        switch (connection) {
            case DOWN: {
                return 26;
            }
            case UP: {
                return 27;
            }
            case NORTH: {
                return 28;
            }
            case SOUTH: {
                return 29;
            }
            case WEST: {
                return 30;
            }
        }
        return 25;
    }

    public void eventHandler(PipeEventItem.FindDest event) {
        ArrayList<ForgeDirection> result = new ArrayList<ForgeDirection>();
        for (int checkingPriority = 6; checkingPriority >= 1; --checkingPriority) {
            boolean foundAny = false;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity entity;
                if (this.sidePriorities[side.ordinal()] != checkingPriority || !((entity = this.container.getTile(side)) instanceof IInventory)) continue;
                ITransactor transactor = Transactor.getTransactorFor((Object)entity);
                if (transactor.add((ItemStack)event.item.getItemStack(), (ForgeDirection)side.getOpposite(), (boolean)false).field_77994_a > 0) {
                    result.add(side);
                }
                foundAny = true;
            }
            if (foundAny) break;
        }
        if (!result.isEmpty()) {
            event.destinations.clear();
            event.destinations.addAll(result);
        }
    }

    public boolean blockActivated(EntityPlayer player, ForgeDirection direction) {
        Item equipped;
        if (player.func_70093_af()) {
            return false;
        }
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (equipped != null && APConfiguration.filterRightclicks && AdditionalPipes.isPipe(equipped)) {
            return false;
        }
        player.openGui((Object)AdditionalPipes.instance, 5, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        return true;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74783_a("priorities", this.sidePriorities);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("priorities")) {
            this.sidePriorities = nbt.func_74759_k("priorities");
        }
    }
}

