/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.integration;

import com.jaquadro.minecraft.gardencore.api.SaplingRegistry;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardentrees.world.gen.OrnamentalTreeFactory;
import com.jaquadro.minecraft.gardentrees.world.gen.OrnamentalTreeRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;

public class ExtraBiomesXLIntegration {
    public static final String MOD_ID = "ExtrabiomesXL";

    public static void init() {
        if (!Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        HashMap<String, int[]> saplingBank1 = new HashMap<String, int[]>();
        saplingBank1.put("small_oak", new int[]{0, 1, 2, 3});
        saplingBank1.put("large_spruce", new int[]{4});
        saplingBank1.put("large_oak", new int[]{5});
        saplingBank1.put("small_acacia", new int[]{6});
        saplingBank1.put("small_cyprus", new int[]{7});
        HashMap<String, int[]> saplingBank2 = new HashMap<String, int[]>();
        saplingBank2.put("small_cyprus", new int[]{0});
        saplingBank2.put("small_oak", new int[]{3, 4});
        saplingBank2.put("small_canopy", new int[]{1});
        saplingBank2.put("small_shrub", new int[]{2});
        HashMap<Item, HashMap<String, int[]>> banks = new HashMap<Item, HashMap<String, int[]>>();
        banks.put(GameRegistry.findItem((String)MOD_ID, (String)"saplings_1"), saplingBank1);
        banks.put(GameRegistry.findItem((String)MOD_ID, (String)"saplings_2"), saplingBank2);
        SaplingRegistry saplingReg = SaplingRegistry.instance();
        for (Map.Entry entry : banks.entrySet()) {
            Item sapling = (Item)entry.getKey();
            for (Map.Entry bankEntry : ((Map)entry.getValue()).entrySet()) {
                OrnamentalTreeFactory factory = OrnamentalTreeRegistry.getTree((String)bankEntry.getKey());
                if (factory == null) continue;
                for (int i : (int[])bankEntry.getValue()) {
                    UniqueMetaIdentifier woodBlock = saplingReg.getWoodForSapling(sapling, i);
                    UniqueMetaIdentifier leafBlock = saplingReg.getLeavesForSapling(sapling, i);
                    if (woodBlock == null && leafBlock == null) continue;
                    saplingReg.putExtendedData(sapling, i, "sm_generator", (Object)factory.create(woodBlock.getBlock(), woodBlock.meta, leafBlock.getBlock(), leafBlock.meta));
                }
            }
        }
    }
}

