/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenstuff.renderer;

import com.jaquadro.minecraft.gardenapi.api.GardenAPI;
import com.jaquadro.minecraft.gardenapi.api.component.ILanternSource;
import com.jaquadro.minecraft.gardenapi.api.connect.IAttachable;
import com.jaquadro.minecraft.gardenapi.api.connect.IChainSingleAttachable;
import com.jaquadro.minecraft.gardenapi.internal.Api;
import com.jaquadro.minecraft.gardencore.util.BindingStack;
import com.jaquadro.minecraft.gardencore.util.RenderHelper;
import com.jaquadro.minecraft.gardenstuff.GardenStuff;
import com.jaquadro.minecraft.gardenstuff.block.BlockLantern;
import com.jaquadro.minecraft.gardenstuff.block.tile.TileEntityLantern;
import com.jaquadro.minecraft.gardenstuff.core.ClientProxy;
import com.jaquadro.minecraft.gardenstuff.core.ModBlocks;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class LanternRenderer
implements ISimpleBlockRenderingHandler {
    public int renderPass = 0;
    private float[] colorScratch = new float[3];
    private static final Vec3 defaultAttachPoint = Vec3.func_72443_a((double)0.5, (double)0.0, (double)0.5);

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (!(block instanceof BlockLantern)) {
            return false;
        }
        return this.renderWorldBlock(world, x, y, z, (BlockLantern)block, modelId, renderer);
    }

    private boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockLantern block, int modelId, RenderBlocks renderer) {
        if (this.renderPass == 0) {
            renderer.func_147775_a((Block)block);
            renderer.func_147784_q((Block)block, x, y, z);
            renderer.field_147838_g = true;
            renderer.field_147855_j = 0.005f;
            renderer.func_147784_q((Block)block, x, y, z);
            renderer.field_147838_g = false;
            renderer.field_147840_d = block.getIconTopCross();
            renderer.func_147746_l((Block)block, x, y, z);
            renderer.field_147840_d = null;
            TileEntityLantern tile = block.getTileEntity(world, x, y, z);
            if (tile != null) {
                ILanternSource lanternSource;
                BindingStack binding = GardenStuff.proxy.getClientBindingStack((Object)block);
                binding.setDefaultMeta(world.func_72805_g(x, y, z));
                binding.bind(tile.func_145831_w(), x, y, z, 0, tile.getLightSourceMeta());
                Tessellator.field_78398_a.func_78372_c(0.0f, 0.001f, 0.0f);
                if (tile.getLightSource() != null && (lanternSource = Api.instance.registries().lanternSources().getLanternSource(tile.getLightSource())) != null && lanternSource.renderInPass(this.renderPass)) {
                    lanternSource.render(renderer, x, y, z, tile.getLightSourceMeta(), this.renderPass);
                }
                Tessellator.field_78398_a.func_78372_c(0.0f, -0.001f, 0.0f);
                binding.unbind(tile.func_145831_w(), x, y, z);
            }
            this.renderChain(world, renderer, block, x, y, z);
        } else if (this.renderPass == 1) {
            ILanternSource lanternSource;
            TileEntityLantern tile = block.getTileEntity(world, x, y, z);
            if (tile != null && tile.hasGlass()) {
                IIcon glass = block.getIconStainedGlass(world.func_72805_g(x, y, z));
                RenderHelper.calculateBaseColor(this.colorScratch, block.func_149635_D());
                RenderHelper.setTessellatorColor(Tessellator.field_78398_a, this.colorScratch);
                Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y, z));
                renderer.func_147775_a((Block)block);
                renderer.field_147859_h += 0.01;
                renderer.field_147851_l += 0.01;
                renderer.field_147861_i -= 0.01;
                renderer.field_147853_m -= 0.01;
                renderer.func_147798_e((Block)block, (double)x, (double)y, (double)z, glass);
                renderer.func_147764_f((Block)block, (double)x, (double)y, (double)z, glass);
                renderer.func_147761_c((Block)block, (double)x, (double)y, (double)z, glass);
                renderer.func_147734_d((Block)block, (double)x, (double)y, (double)z, glass);
                renderer.field_147857_k -= 0.01;
                renderer.func_147806_b((Block)block, (double)x, (double)y, (double)z, glass);
            } else {
                RenderHelper.instance.renderEmptyPlane(x, y, z);
            }
            if (tile != null && tile.getLightSource() != null && (lanternSource = Api.instance.registries().lanternSources().getLanternSource(tile.getLightSource())) != null && lanternSource.renderInPass(this.renderPass)) {
                lanternSource.render(renderer, x, y, z, tile.getLightSourceMeta(), this.renderPass);
            }
        }
        return true;
    }

    private void renderChain(IBlockAccess world, RenderBlocks renderer, BlockLantern block, int x, int y, int z) {
        double depth;
        Vec3 attach;
        Block lowerBlock = world.func_147439_a(x, y - 1, z);
        if (lowerBlock.isSideSolid(world, x, y - 1, z, ForgeDirection.UP)) {
            return;
        }
        Block upperBlock = world.func_147439_a(x, y + 1, z);
        if (upperBlock instanceof IChainSingleAttachable && (attach = ((IChainSingleAttachable)upperBlock).getChainAttachPoint(world, x, y + 1, z, 0)) != null && attach != defaultAttachPoint) {
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, attach.field_72448_b, 1.0);
            RenderHelper.instance.renderCrossedSquares(world, ModBlocks.heavyChain, x, y + 1, z, ModBlocks.lightChain.func_149691_a(0, 4));
            return;
        }
        IAttachable attachable = GardenAPI.instance().registries().attachable().getAttachable(upperBlock, world.func_72805_g(x, y + 1, z));
        if (attachable != null && attachable.isAttachable(world, x, y + 1, z, 0) && (depth = attachable.getAttachDepth(world, x, y + 1, z, 0)) > 0.0) {
            RenderHelper.instance.setRenderBounds(0.0, 0.0, 0.0, 1.0, depth, 1.0);
            RenderHelper.instance.renderCrossedSquares(world, ModBlocks.heavyChain, x, y + 1, z, ModBlocks.lightChain.func_149691_a(0, 4));
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return ClientProxy.lanternRenderID;
    }
}

