/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.integration.ae2;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import java.lang.reflect.Constructor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.common.tileentity.machines.TileEntityStorageChamber;

public class StorageChamberHandler {
    public static void init() {
        ReflectionFactory.init();
        AEApi.instance().registries().externalStorage().addExternalStorageInterface((IExternalStorageHandler)new StorageHandler());
    }

    public static class StorageInventory
    implements IMEInventory<IAEItemStack> {
        private World world;
        private int x;
        private int y;
        private int z;

        public StorageInventory(World world, int x, int y, int z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public TileEntityStorageChamber getChamber() {
            TileEntity tile;
            if (this.world != null && (tile = this.world.func_147438_o(this.x, this.y, this.z)) != null && tile instanceof TileEntityStorageChamber) {
                return (TileEntityStorageChamber)tile;
            }
            return null;
        }

        public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
            TileEntityStorageChamber chamber = this.getChamber();
            if (chamber != null) {
                if (chamber.getSavedStack() != null) {
                    if (TileEntityStorageChamber.getCircuitType(input.getItemStack()) == TileEntityStorageChamber.getCircuitType(chamber.getSavedStack())) {
                        int stored = chamber.getStored()[input.getItemDamage()];
                        if (stored == TileEntityStorageChamber.maxSize) {
                            return input;
                        }
                        if ((long)stored + input.getStackSize() <= (long)TileEntityStorageChamber.maxSize) {
                            if (type != Actionable.SIMULATE) {
                                chamber.increaseStored(input.getItemDamage(), (int)input.getStackSize());
                            }
                            return null;
                        }
                        if (type != Actionable.SIMULATE) {
                            chamber.setStored(input.getItemDamage(), TileEntityStorageChamber.maxSize);
                        }
                        input.decStackSize((long)(TileEntityStorageChamber.maxSize - stored));
                        return input;
                    }
                } else if (TileEntityStorageChamber.getCircuitType(input.getItemStack()) != null) {
                    if (type != Actionable.SIMULATE) {
                        chamber.setSavedStack(input.getItemStack().func_77946_l());
                    }
                    if (input.getStackSize() <= (long)TileEntityStorageChamber.maxSize) {
                        if (type != Actionable.SIMULATE) {
                            int n = input.getItemDamage();
                            chamber.stored[n] = (int)((long)chamber.stored[n] + input.getStackSize());
                        }
                        return null;
                    }
                    if (type != Actionable.SIMULATE) {
                        chamber.stored[input.getItemDamage()] = TileEntityStorageChamber.maxSize;
                    }
                    input.decStackSize((long)TileEntityStorageChamber.maxSize);
                    return input;
                }
            }
            return input;
        }

        public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
            TileEntityStorageChamber chamber = this.getChamber();
            if (chamber != null && chamber.getSavedStack() != null) {
                int stored;
                if (TileEntityStorageChamber.getCircuitType(request.getItemStack()) == TileEntityStorageChamber.getCircuitType(chamber.getSavedStack()) && (stored = chamber.stored[request.getItemDamage()]) != 0) {
                    if ((long)stored <= request.getStackSize()) {
                        ItemStack stack = chamber.getFullStack(request.getItemDamage());
                        if (mode != Actionable.SIMULATE) {
                            chamber.stored[request.getItemDamage()] = 0;
                            chamber.resetSavedStack(request.getItemDamage());
                        }
                        return AEApi.instance().storage().createItemStack(stack);
                    }
                    ItemStack stack = chamber.getSlotStack(request.getItemDamage(), (int)request.getStackSize());
                    if (mode != Actionable.SIMULATE) {
                        int n = request.getItemDamage();
                        chamber.stored[n] = (int)((long)chamber.stored[n] - request.getStackSize());
                    }
                    return AEApi.instance().storage().createItemStack(stack);
                }
            }
            return null;
        }

        public IItemList getAvailableItems(IItemList out) {
            TileEntityStorageChamber chamber = this.getChamber();
            if (chamber != null && chamber.getSavedStack() != null) {
                for (int i = 0; i < 14; ++i) {
                    ItemStack stack = chamber.getFullStack(i);
                    if (stack == null) continue;
                    out.add((IAEStack)AEApi.instance().storage().createItemStack(stack));
                }
            }
            return out;
        }

        public StorageChannel getChannel() {
            return StorageChannel.ITEMS;
        }
    }

    public static class StorageHandler
    implements IExternalStorageHandler {
        public boolean canHandle(TileEntity te, ForgeDirection d, StorageChannel channel, BaseActionSource mySrc) {
            return te != null && te instanceof TileEntityStorageChamber;
        }

        public IMEInventory getInventory(TileEntity te, ForgeDirection d, StorageChannel channel, BaseActionSource src) {
            if (te != null && te instanceof TileEntityStorageChamber) {
                return ReflectionFactory.createStorageBusMonitor(new StorageInventory(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e), src);
            }
            return null;
        }
    }

    public static class ReflectionFactory {
        private static Class classInventoryAdaptor;
        private static Class classMEAdaptor;
        private static Class classMonitor;
        private static Constructor constMEAdaptor;
        private static Constructor constMonitor;

        public static boolean init() {
            try {
                classInventoryAdaptor = Class.forName("appeng.util.InventoryAdaptor");
                classMEAdaptor = Class.forName("appeng.util.inv.IMEAdaptor");
                classMonitor = Class.forName("appeng.me.storage.MEMonitorIInventory");
                constMEAdaptor = classMEAdaptor.getConstructor(IMEInventory.class, BaseActionSource.class);
                constMonitor = classMonitor.getConstructor(classInventoryAdaptor);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        public static IMEMonitor<IAEItemStack> createStorageBusMonitor(IMEInventory<IAEItemStack> inventory, BaseActionSource src) {
            try {
                Object adaptor = constMEAdaptor.newInstance(inventory, src);
                Object monitor = constMonitor.newInstance(adaptor);
                return (IMEMonitor)monitor;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

