/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import cofh.api.transport.IItemDuct;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.api.ActionType;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredItemStack;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.utils.IByteBufTile;

public class TileEntityMagneticFlux
extends TileEntityInventory
implements IEntitySelector,
ISidedInventory,
IByteBufTile {
    public boolean whitelisted;
    public boolean exact;
    public Random rand = new Random();
    public float rotate = 0.0f;
    public boolean disabled;

    public TileEntityMagneticFlux() {
        this.slots = new ItemStack[8];
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.disabled = true;
            return;
        }
        this.disabled = false;
        if (this.field_145850_b.field_72995_K) {
            this.rotate = !(this.rotate >= 1.0f) ? (this.rotate += 0.01f) : 0.0f;
        }
        this.magnetizeItems();
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.whitelisted = nbt.func_74767_n("blacklisted");
            this.exact = nbt.func_74767_n("exact");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74757_a("blacklisted", this.whitelisted);
            nbt.func_74757_a("exact", this.exact);
        }
    }

    public void magnetizeItems() {
        int range = 10;
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + range), (double)(this.field_145848_d + range), (double)(this.field_145849_e + range));
        List items = this.field_145850_b.func_82733_a(EntityItem.class, aabb, null);
        for (Entity entity : items) {
            if (!(entity instanceof EntityItem) || !this.validItemStack(((EntityItem)entity).func_92059_d())) continue;
            double x = (double)this.field_145851_c + 0.5 - entity.field_70165_t;
            double y = (double)this.field_145848_d + 0.2 - entity.field_70163_u;
            double z = (double)this.field_145849_e + 0.5 - entity.field_70161_v;
            double distance = Math.sqrt(x * x + y * y + z * z);
            if (distance < 1.5) {
                ItemStack itemstack = this.addToInventory((EntityItem)entity);
                if (itemstack == null || itemstack.field_77994_a <= 0) {
                    entity.func_70106_y();
                    continue;
                }
                ((EntityItem)entity).func_92058_a(itemstack);
                continue;
            }
            double speed = entity.func_70027_ad() ? 5.2 : 0.1;
            entity.field_70159_w += x / distance * speed;
            entity.field_70181_x += y * speed;
            if (y > 0.0) {
                entity.field_70181_x = 0.1;
            }
            entity.field_70179_y += z / distance * speed;
        }
    }

    public boolean validItemStack(ItemStack stack) {
        if (this.slots == null) {
            return true;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            boolean matches = this.matchingStack(this.slots[i], stack);
            if (!this.whitelisted && matches) {
                return false;
            }
            if (!this.whitelisted || !matches) continue;
            return true;
        }
        return !this.whitelisted;
    }

    public boolean matchingStack(ItemStack stack, ItemStack stack2) {
        if (this.exact) {
            int[] stackDict = OreDictionary.getOreIDs((ItemStack)stack2);
            int[] storedDict = OreDictionary.getOreIDs((ItemStack)stack);
            for (int i = 0; i < stackDict.length; ++i) {
                for (int s = 0; s < storedDict.length; ++s) {
                    if (stackDict[i] != storedDict[s]) continue;
                    return true;
                }
            }
        }
        return !(stack.func_77973_b() != stack2.func_77973_b() || !this.exact && stack.func_77960_j() != stack2.func_77960_j() || !this.exact && !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stack2));
    }

    public ItemStack addToInventory(EntityItem item) {
        if (!this.field_145850_b.field_72995_K) {
            EntityItem entity = (EntityItem)this.field_145850_b.func_73045_a(item.func_145782_y());
            if (entity == null) {
                return null;
            }
            ItemStack itemstack = entity.func_92059_d();
            int i = itemstack.field_77994_a;
            TileEntity target = SonarHelper.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)ForgeDirection.DOWN);
            itemstack = target instanceof IItemDuct ? ((IItemDuct)target).insertItem(ForgeDirection.UP, itemstack) : SonarAPI.getItemHelper().addItems(target, new StoredItemStack(itemstack), ForgeDirection.getOrientation((int)1), ActionType.PERFORM, null).getFullStack();
            return itemstack;
        }
        return item.func_92059_d();
    }

    public boolean func_82704_a(Entity entity) {
        return entity instanceof EntityItem;
    }

    public int[] func_94128_d(int side) {
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        if (!this.disabled) {
            String active = FontHelper.translate((String)"locator.state") + " : " + FontHelper.translate((String)"state.on");
            currenttip.add(active);
        } else {
            String idle = FontHelper.translate((String)"locator.state") + " : " + FontHelper.translate((String)"state.off");
            currenttip.add(idle);
        }
        return currenttip;
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.whitelisted = !this.whitelisted;
                buf.writeBoolean(this.whitelisted);
                break;
            }
            case 1: {
                this.exact = !this.exact;
                buf.writeBoolean(this.exact);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 0: {
                this.whitelisted = buf.readBoolean();
                break;
            }
            case 1: {
                this.exact = buf.readBoolean();
            }
        }
    }
}

