/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.misc;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.flux.IFluxController;
import sonar.calculator.mod.api.items.ILocatorModule;
import sonar.calculator.mod.client.gui.misc.GuiFlux;
import sonar.calculator.mod.network.ChunkHandler;
import sonar.calculator.mod.utils.FluxNetwork;
import sonar.calculator.mod.utils.FluxRegistry;
import sonar.core.common.tileentity.TileEntityInventory;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.network.utils.ISyncTile;

public class TileEntityFluxController
extends TileEntityInventory
implements IFluxController,
ISyncTile,
IByteBufTile {
    private ForgeChunkManager.Ticket currentTicket;
    public int recieveMode;
    public int sendMode;
    public int transmitterMode;
    public int playerProtect;
    public int dimension;
    public int networkID;
    public String playerName = "";
    public String networkName = "NETWORK";
    public List<FluxNetwork> networks;

    public TileEntityFluxController() {
        this.slots = new ItemStack[9];
    }

    @Override
    public int pushEnergy(int recieve, boolean simulate) {
        List<String> players = this.getPlayers();
        if (players != null && players.size() > 0) {
            for (int p = 0; p < players.size(); ++p) {
                EntityPlayer player;
                MinecraftServer server = MinecraftServer.func_71276_C();
                WorldServer world = server.func_71218_a(this.dimension);
                if (world.func_72924_a(players.get(p)) == null || (player = world.func_72924_a(players.get(p))) == null || player.field_71071_by == null) continue;
                InventoryPlayer inv = player.field_71071_by;
                int size = inv.func_70302_i_();
                if (this.transmitterMode == 2) {
                    size = 9;
                }
                for (int i = 0; i < size; ++i) {
                    int toTransferRF;
                    int itemEnergyRF;
                    IElectricItemManager manager;
                    IElectricItem item;
                    ItemStack target = inv.func_70301_a(i);
                    if (target == null) continue;
                    if (target.func_77973_b() instanceof IEnergyContainerItem) {
                        if (((IEnergyContainerItem)target.func_77973_b()).getEnergyStored(target) == ((IEnergyContainerItem)target.func_77973_b()).getMaxEnergyStored(target)) continue;
                        recieve -= ((IEnergyContainerItem)target.func_77973_b()).receiveEnergy(inv.func_70301_a(i), recieve, simulate);
                        continue;
                    }
                    if (SonarLoader.ic2Loaded() && target.func_77973_b() instanceof IElectricItem) {
                        item = (IElectricItem)target.func_77973_b();
                        manager = ElectricItem.manager;
                        itemEnergyRF = (int)Math.round(Math.min(Math.sqrt(item.getMaxCharge(target) * 4.0), item.getMaxCharge(target) * 4.0 - manager.getCharge(target) * 4.0));
                        toTransferRF = Math.min(recieve, Math.round(itemEnergyRF));
                        recieve = (int)((double)recieve - manager.charge(target, (double)(toTransferRF / 4), 4, false, simulate) * 4.0);
                        continue;
                    }
                    if (!SonarLoader.ic2Loaded() || !(target.func_77973_b() instanceof ISpecialElectricItem)) continue;
                    item = (ISpecialElectricItem)target.func_77973_b();
                    manager = item.getManager(target);
                    itemEnergyRF = (int)Math.round(Math.min(Math.sqrt(item.getMaxCharge(target) * 4.0), item.getMaxCharge(target) * 4.0 - manager.getCharge(target) * 4.0));
                    toTransferRF = Math.min(recieve, Math.round(itemEnergyRF));
                    recieve = (int)((double)recieve - manager.charge(target, (double)(toTransferRF / 4), 4, false, simulate) * 4.0);
                }
            }
        }
        return recieve;
    }

    public void addToFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            FluxRegistry.addController(this);
        }
    }

    public void removeFromFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            FluxRegistry.removeController(this);
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.recieveMode = nbt.func_74762_e("recieveMode");
            this.sendMode = nbt.func_74762_e("sendMode");
            this.networkID = nbt.func_74762_e("networkID");
            this.networkName = nbt.func_74779_i("networkName");
            this.transmitterMode = nbt.func_74762_e("transmitterMode");
            this.playerProtect = nbt.func_74762_e("playerProtect");
            if (type == NBTHelper.SyncType.SAVE) {
                this.dimension = nbt.func_74762_e("DIMENSION");
                this.playerName = nbt.func_74779_i("playerName");
            }
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74768_a("recieveMode", this.recieveMode);
            nbt.func_74768_a("sendMode", this.sendMode);
            nbt.func_74768_a("networkID", this.networkID);
            nbt.func_74778_a("networkName", this.networkName);
            nbt.func_74768_a("transmitterMode", this.transmitterMode);
            nbt.func_74768_a("playerProtect", this.playerProtect);
            if (type == NBTHelper.SyncType.SAVE) {
                nbt.func_74768_a("DIMENSION", this.dimension);
                nbt.func_74778_a("playerName", this.playerName);
            }
        }
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            int network = FluxRegistry.getNetwork(this.networkName, this.playerName);
            this.networkID = network == 0 ? FluxRegistry.createNetwork(this.networkName) : network;
            this.addToFrequency();
            this.loadChunks();
        }
    }

    public void loadChunks() {
        this.currentTicket = ForgeChunkManager.requestTicket((Object)Calculator.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.currentTicket != null) {
            ChunkCoordIntPair chunk = new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4);
            ChunkHandler.saveFluxController(this.currentTicket, this);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.currentTicket, (ChunkCoordIntPair)chunk);
        }
    }

    public void removeChunks() {
        if (this.currentTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.currentTicket);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.removeFromFrequency();
        }
    }

    public List<String> getPlayers() {
        ArrayList<String> players = new ArrayList<String>();
        if (this.playerName != null) {
            if (this.playerName != null) {
                players.add(this.playerName);
            }
            for (int i = 0; i < 9; ++i) {
                String locatorPlayer;
                if (this.slots[i] == null || !(this.slots[i].func_77973_b() instanceof ILocatorModule) || (locatorPlayer = ((ILocatorModule)this.slots[i].func_77973_b()).getPlayer(this.slots[i])) == null || players.contains(locatorPlayer)) continue;
                players.add(locatorPlayer);
            }
        }
        return players;
    }

    @Override
    public boolean validPlayer(String playerName) {
        if (playerName == null) {
            return true;
        }
        switch (this.playerProtect) {
            case 0: {
                return this.getPlayers().contains(playerName);
            }
            case 1: {
                return playerName.equals(this.playerName);
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public String getPlayer() {
        return this.playerName;
    }

    public void setName(String name) {
        if (!name.isEmpty() && !name.equals("NETWORK")) {
            this.removeFromFrequency();
            int network = FluxRegistry.getNetwork(name, this.playerName);
            if (network == 0) {
                this.networkID = FluxRegistry.createNetwork(name);
            } else if (FluxRegistry.getController(network) == null) {
                this.networkID = network;
            }
            if (FluxRegistry.getController(network) == null) {
                this.addToFrequency();
                this.networkName = name;
            }
        }
    }

    public void rename(String name) {
        if (!name.isEmpty() && !name.equals("NETWORK")) {
            FluxRegistry.renameNetwork(this.playerName, this.networkName, name);
        }
    }

    public void setPlayer(EntityPlayer player) {
        if (player == null) {
            return;
        }
        this.playerName = player.func_146103_bH().getName();
        this.dimension = player.field_71093_bK;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() == Calculator.itemLocatorModule;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public int xCoord() {
        return this.field_145851_c;
    }

    @Override
    public int yCoord() {
        return this.field_145848_d;
    }

    @Override
    public int zCoord() {
        return this.field_145849_e;
    }

    @Override
    public int networkID() {
        return this.networkID;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int maxTransfer() {
        return 64000;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public String masterName() {
        return this.playerName;
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        if (this.networkName.equals("NETWORK")) {
            currenttip.add(FontHelper.translate((String)"network.notConnected"));
        } else {
            currenttip.add(this.networkName + ": " + GuiFlux.getNetworkType(this.playerProtect));
        }
        return currenttip;
    }

    public void writePacket(ByteBuf buf, int id) {
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case 3: {
                if (this.recieveMode < 4) {
                    ++this.recieveMode;
                    break;
                }
                this.recieveMode = 0;
                break;
            }
            case 4: {
                if (this.sendMode < 2) {
                    ++this.sendMode;
                    break;
                }
                this.sendMode = 0;
                break;
            }
            case 5: {
                if (this.transmitterMode < 2) {
                    ++this.transmitterMode;
                    break;
                }
                this.transmitterMode = 0;
                break;
            }
            case 6: {
                if (this.playerProtect < 2) {
                    ++this.playerProtect;
                    break;
                }
                this.playerProtect = 0;
            }
        }
    }

    @Override
    public int getRecieveMode() {
        return this.recieveMode;
    }

    @Override
    public int getTransmitterMode() {
        return this.transmitterMode;
    }

    @Override
    public int getSendMode() {
        return this.sendMode;
    }

    @Override
    public int getProtectionMode() {
        return this.playerProtect;
    }
}

