/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import cofh.api.energy.IEnergyHandler;
import ic2.api.energy.tile.IEnergySink;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.machines.IProcessMachine;
import sonar.core.common.tileentity.TileEntityInventoryReceiver;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncEnergyStorage;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.network.utils.ISyncTile;

public class TileEntityWeatherController
extends TileEntityInventoryReceiver
implements IEnergyHandler,
IEnergySink,
ISyncTile,
IByteBufTile,
IProcessMachine {
    public int type;
    public int data;
    public int buffer;
    public int coolDown;
    public static final int TIME = 0;
    public static final int RAIN = 1;
    public static final int THUNDER = 2;
    public int requiredPower = CalculatorConfig.getInteger("Weather Controller");

    public TileEntityWeatherController() {
        this.slots = new ItemStack[1];
        this.storage = new SyncEnergyStorage(1000000, 64000);
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.discharge(0);
        if (this.buffer > 0) {
            this.storage.modifyEnergyStored(-(this.requiredPower / 100));
            if (this.buffer != 100) {
                ++this.buffer;
            } else {
                this.coolDown = 1;
                this.buffer = 0;
                if (!this.field_145850_b.field_72995_K) {
                    this.processType(this.type, false);
                }
            }
        }
        if (this.coolDown > 0) {
            this.coolDown = this.coolDown != 30 ? ++this.coolDown : 0;
        }
    }

    public void startProcess() {
        int power = this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.buffer == 0 && this.coolDown == 0 && this.storage.getEnergyStored() >= this.requiredPower && this.processType(this.type, true) && (power != 0 || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
            this.buffer = 1;
        }
    }

    public boolean processType(int type, boolean simulate) {
        switch (type) {
            case 0: {
                if (this.data == 0 && this.field_145850_b.func_72935_r()) {
                    return false;
                }
                if (this.data > 0 && !this.field_145850_b.func_72935_r()) {
                    return false;
                }
                if (!simulate) {
                    this.field_145850_b.func_72877_b(this.data == 0 ? 1000L : 13000L);
                }
                return true;
            }
            case 1: {
                if (this.data == 0 && !this.field_145850_b.func_72896_J()) {
                    return false;
                }
                if (this.data > 0 && this.field_145850_b.func_72896_J()) {
                    return false;
                }
                if (!simulate) {
                    this.field_145850_b.func_72912_H().func_76084_b(this.data != 0);
                }
                return true;
            }
            case 2: {
                if (this.data == 0 && !this.field_145850_b.func_72911_I()) {
                    return false;
                }
                if (this.data > 0 && this.field_145850_b.func_72911_I()) {
                    return false;
                }
                if (!simulate) {
                    this.field_145850_b.func_72912_H().func_76084_b(this.data != 0);
                    this.field_145850_b.func_72912_H().func_76069_a(this.data != 0);
                }
                return true;
            }
        }
        return false;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.type = nbt.func_74762_e("type");
            this.data = nbt.func_74762_e("data");
            this.buffer = nbt.func_74762_e("buffer");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            nbt.func_74768_a("type", this.type);
            nbt.func_74768_a("data", this.data);
            nbt.func_74768_a("buffer", this.buffer);
        }
    }

    public void writePacket(ByteBuf buf, int id) {
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 0) {
            this.data = this.data == 1 ? 0 : 1;
        } else {
            this.setType(id - 1);
        }
    }

    @Override
    public int getCurrentProcessTime() {
        return this.buffer;
    }

    @Override
    public int getProcessTime() {
        return 100;
    }

    @Override
    public double getEnergyUsage() {
        return this.requiredPower / this.getProcessTime();
    }

    @Override
    public int getBaseProcessTime() {
        return this.getProcessTime();
    }
}

