/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.machines;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.item.misc.ItemCircuit;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.calculator.mod.common.tileentity.TileEntityAbstractProcess;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.RecipeHelper;
import sonar.core.helpers.RenderHelper;

public class TileEntityDockingStation
extends TileEntityAbstractProcess {
    public ItemStack calcStack;

    public TileEntityDockingStation() {
        super(4, 1, 200, 10);
    }

    @Override
    public int inputSize() {
        return 4;
    }

    @Override
    public int outputSize() {
        return 1;
    }

    @Override
    public ItemStack[] getOutput(boolean simulate, ItemStack ... stacks) {
        return this.recipeHelper().getOutput(stacks);
    }

    @Override
    public RecipeHelper recipeHelper() {
        if (this.calcStack != null) {
            if (this.calcStack.func_77973_b() == Calculator.itemCalculator) {
                return RecipeRegistry.CalculatorRecipes.instance();
            }
            if (this.calcStack.func_77973_b() == Calculator.itemScientificCalculator) {
                return RecipeRegistry.ScientificRecipes.instance();
            }
            if (this.calcStack.func_77973_b() == Item.func_150898_a((Block)Calculator.atomiccalculatorBlock)) {
                return RecipeRegistry.AtomicRecipes.instance();
            }
            if (this.calcStack.func_77973_b() == Calculator.itemFlawlessCalculator) {
                return RecipeRegistry.FlawlessRecipes.instance();
            }
        }
        return RecipeRegistry.CalculatorRecipes.instance();
    }

    @Override
    public int getProcessTime() {
        return Math.max(1, super.getProcessTime() / 8);
    }

    @Override
    public int requiredEnergy() {
        return 10;
    }

    @Override
    public boolean canAddUpgrades(int type) {
        if (type == 1) {
            return false;
        }
        return super.canAddUpgrades(type);
    }

    @Override
    public ItemStack[] inputStacks() {
        int size = TileEntityDockingStation.isCalculator(this.calcStack);
        if (size == 0) {
            return null;
        }
        ItemStack[] input = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            input[i] = this.slots[i];
        }
        return input;
    }

    @Override
    public void finishProcess() {
        ItemStack[] output = this.getOutput(false, this.inputStacks());
        for (int o = 0; o < this.outputSize(); ++o) {
            if (output[o] == null) continue;
            if (this.slots[o + this.inputSize() + 1] == null) {
                ItemStack outputStack = output[o].func_77946_l();
                if (output[o].func_77973_b() == Calculator.circuitBoard) {
                    ItemCircuit.setData(outputStack);
                }
                this.slots[o + this.inputSize() + 1] = outputStack;
                continue;
            }
            if (!this.slots[o + this.inputSize() + 1].func_77969_a(output[o])) continue;
            this.slots[o + this.inputSize() + 1].field_77994_a += output[o].field_77994_a;
        }
        int i = 0;
        while (true) {
            if (i >= TileEntityDockingStation.isCalculator(this.calcStack)) break;
            this.slots[i].field_77994_a = this.recipeHelper() != null ? (this.slots[i].field_77994_a -= this.recipeHelper().getInputSize(i, output)) : --this.slots[i].field_77994_a;
            if (this.slots[i].field_77994_a <= 0) {
                this.slots[i] = null;
            }
            ++i;
        }
    }

    public static int isCalculator(ItemStack itemstack1) {
        if (itemstack1 != null) {
            if (itemstack1.func_77973_b() == Calculator.itemCalculator) {
                return 2;
            }
            if (itemstack1.func_77973_b() == Calculator.itemScientificCalculator) {
                return 2;
            }
            if (itemstack1.func_77973_b() == Item.func_150898_a((Block)Calculator.atomiccalculatorBlock)) {
                return 3;
            }
            if (itemstack1.func_77973_b() == Calculator.itemFlawlessCalculator) {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            this.calcStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("calcStack"));
            this.field_145847_g = nbt.func_74762_e("meta");
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if ((type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) && this.calcStack != null) {
            NBTTagCompound stack = new NBTTagCompound();
            this.calcStack.func_77955_b(stack);
            nbt.func_74782_a("calcStack", (NBTBase)stack);
            nbt.func_74768_a("meta", this.field_145847_g);
        }
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.slots[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public int[] func_94128_d(int side) {
        int[] outputSlot = new int[]{5};
        int[] emptySlot = new int[]{};
        int size = TileEntityDockingStation.isCalculator(this.calcStack);
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.field_145847_g);
        if (dir == ForgeDirection.UNKNOWN || size == 0) {
            return emptySlot;
        }
        if (side == 0 || side == 1) {
            return outputSlot;
        }
        if (size == 2) {
            if (side == RenderHelper.getHorizontal((ForgeDirection)dir).ordinal()) {
                return new int[]{0};
            }
            if (side == RenderHelper.getHorizontal((ForgeDirection)dir).getOpposite().ordinal()) {
                return new int[]{1};
            }
        }
        if (size == 3) {
            if (side == RenderHelper.getHorizontal((ForgeDirection)dir).ordinal()) {
                return new int[]{0};
            }
            if (side == dir.getOpposite().ordinal()) {
                return new int[]{1};
            }
            if (side == RenderHelper.getHorizontal((ForgeDirection)dir).getOpposite().ordinal()) {
                return new int[]{2};
            }
        }
        if (size == 4) {
            if (side == RenderHelper.getHorizontal((ForgeDirection)dir).ordinal()) {
                return new int[]{0};
            }
            if (side == dir.getOpposite().ordinal()) {
                return new int[]{1};
            }
            if (side == dir.ordinal()) {
                return new int[]{2};
            }
            if (side == RenderHelper.getHorizontal((ForgeDirection)dir).getOpposite().ordinal()) {
                return new int[]{3};
            }
        }
        return outputSlot;
    }

    public int convertMeta(int meta) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        RenderHelper.getHorizontal((ForgeDirection)dir);
        if (meta <= 1) {
            meta = 5;
        } else if ((meta & 5) <= 1) {
            meta = 2;
        }
        return meta;
    }
}

