/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import cofh.api.energy.IEnergyHandler;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.calculator.mod.api.flux.IFlux;
import sonar.calculator.mod.api.flux.IFluxController;
import sonar.calculator.mod.client.gui.misc.GuiFlux;
import sonar.calculator.mod.utils.FluxNetwork;
import sonar.calculator.mod.utils.FluxRegistry;
import sonar.calculator.mod.utils.helpers.FluxHelper;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.ISyncTile;

public abstract class TileEntityFlux
extends TileEntitySonar
implements IEnergyHandler,
ISyncTile,
IEnergySink,
IFlux {
    public SyncTagType.INT networkState = (SyncTagType.INT)new SyncTagType.INT("networkState").removeSyncType(NBTHelper.SyncType.SAVE);
    public SyncTagType.INT playerState = (SyncTagType.INT)new SyncTagType.INT("playerState").removeSyncType(NBTHelper.SyncType.SAVE);
    public SyncTagType.INT dimension = (SyncTagType.INT)new SyncTagType.INT("DIMENSION").removeSyncType(NBTHelper.SyncType.SYNC);
    public SyncTagType.INT networkID = new SyncTagType.INT("networkID");
    public SyncTagType.STRING playerName = (SyncTagType.STRING)new SyncTagType.STRING("playerName").removeSyncType(NBTHelper.SyncType.SYNC);
    public SyncTagType.STRING networkName = (SyncTagType.STRING)new SyncTagType.STRING("networkName").setDefault((Object)"NETWORK");
    public String masterName = "";
    public List<FluxNetwork> networks;

    public String getMasterName() {
        IFluxController controller = FluxHelper.getController((Integer)this.networkID.getObject());
        if (controller != null) {
            this.networkState.setObject((Object)controller.getProtectionMode());
            if (controller.validPlayer((String)this.playerName.getObject())) {
                this.playerState.setObject((Object)0);
            } else {
                this.playerState.setObject((Object)1);
            }
            return controller.toString();
        }
        this.playerState.setObject((Object)0);
        this.networkState.setObject((Object)1);
        return " ";
    }

    public void setName(String name) {
        if (!name.isEmpty() && !name.equals("NETWORK")) {
            this.removeFromFrequency();
            int network = FluxRegistry.getNetwork(name, (String)this.playerName.getObject());
            if (network == 0) {
                this.networkID.setObject((Object)FluxRegistry.createNetwork(name));
            } else {
                this.networkID.setObject((Object)network);
            }
            this.addToFrequency();
            this.networkName.setObject((Object)name);
        }
    }

    public void rename(String name) {
        if (!name.isEmpty() && !name.equals("NETWORK")) {
            FluxRegistry.renameNetwork((String)this.playerName.getObject(), (String)this.networkName.getObject(), name);
            this.networkName.setObject((Object)name);
        }
    }

    public void addToFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            FluxRegistry.addFlux(this);
        }
    }

    public void removeFromFrequency() {
        if (!this.field_145850_b.field_72995_K) {
            FluxRegistry.removeFlux(this);
        }
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.SYNC) {
            this.masterName = nbt.func_74779_i("masterName");
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SYNC) {
            nbt.func_74778_a("masterName", this.getMasterName());
        }
    }

    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.addAll(Lists.newArrayList((Object[])new SyncTagType[]{this.dimension, this.networkID, this.playerName, this.networkName, this.networkState, this.playerState}));
    }

    public boolean hasEnergyHandler(ForgeDirection from) {
        TileEntity handler = SonarHelper.getAdjacentTileEntity((TileEntity)this, (ForgeDirection)from);
        if (handler instanceof TileEntityFlux) {
            return false;
        }
        return SonarHelper.isAdjacentEnergyHandlerFromSide((TileEntity)this, (ForgeDirection)from);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection dir, int maxTransfer, boolean simulate) {
        return 0;
    }

    public int extractEnergy(ForgeDirection dir, int paramInt, boolean paramBoolean) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection dir) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection dir) {
        return 0;
    }

    public void onChunkUnload() {
        this.removeFromFrequency();
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            int network;
            if (SonarLoader.ic2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            }
            if ((network = FluxRegistry.getNetwork((String)this.networkName.getObject(), (String)this.playerName.getObject())) == 0) {
                this.networkID.setObject((Object)FluxRegistry.createNetwork((String)this.networkName.getObject()));
            } else {
                this.networkID.setObject((Object)network);
            }
            this.addToFrequency();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            if (SonarLoader.ic2Loaded()) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            }
            this.removeFromFrequency();
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        return 0.0;
    }

    public int getSinkTier() {
        return 4;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        return 0.0;
    }

    @Override
    public int xCoord() {
        return this.field_145851_c;
    }

    @Override
    public int yCoord() {
        return this.field_145848_d;
    }

    @Override
    public int zCoord() {
        return this.field_145849_e;
    }

    @Override
    public int networkID() {
        return (Integer)this.networkID.getObject();
    }

    @Override
    public int dimension() {
        return (Integer)this.dimension.getObject();
    }

    public String getPlayer() {
        return (String)this.playerName.getObject();
    }

    public void setPlayer(EntityPlayer player) {
        if (player == null) {
            return;
        }
        this.playerName.setObject((Object)player.func_146103_bH().getName());
        this.dimension.setObject((Object)player.field_71093_bK);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public String masterName() {
        return (String)this.playerName.getObject();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip) {
        if (this.networkName.equals("NETWORK")) {
            currenttip.add(FontHelper.translate((String)"network.notConnected"));
        } else {
            currenttip.add((String)this.networkName.getObject() + ": " + GuiFlux.getNetworkType((Integer)this.networkState.getObject()));
        }
        return currenttip;
    }

    public static class TransferList {
        public int[] inputList;
        public int energy;

        public TransferList(int[] inputList, int input) {
            this.inputList = inputList;
            this.energy = input;
        }
    }
}

