/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.machines.ProcessType;
import sonar.calculator.mod.api.nutrition.IHealthStore;
import sonar.calculator.mod.utils.helpers.NutritionHelper;
import sonar.core.common.item.SonarItem;
import sonar.core.helpers.FontHelper;

public class HealthModule
extends SonarItem
implements IHealthStore {
    public HealthModule() {
        this.func_77637_a(Calculator.Calculator);
        this.field_77777_bU = 1;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return NutritionHelper.chargeHealth(stack, world, player, "points");
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par, float par8, float par9, float par10) {
        return NutritionHelper.useHealth(stack, player, world, x, y, z, par);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (stack.func_77942_o()) {
            list.add(FontHelper.translate((String)"points.health") + ": " + this.getHealthPoints(stack));
        }
    }

    @Override
    public void transferHealth(int transfer, ItemStack stack, ProcessType process) {
        NBTTagCompound nbtData;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((nbtData = stack.func_77978_p()) == null) {
            stack.func_77978_p().func_74768_a("points", 0);
        }
        int points = stack.func_77978_p().func_74762_e("points");
        if (process == ProcessType.REMOVE) {
            nbtData.func_74768_a("points", points - transfer);
        } else if (process == ProcessType.ADD) {
            nbtData.func_74768_a("points", points + transfer);
        }
    }

    @Override
    public int getHealthPoints(ItemStack stack) {
        return NutritionHelper.getIntegerTag(stack, "points");
    }

    @Override
    public int getMaxHealthPoints(ItemStack stack) {
        return 1000;
    }

    @Override
    public void setHealth(ItemStack stack, int health) {
        if (health >= 0 && health <= this.getMaxHealthPoints(stack)) {
            NBTTagCompound nbtData;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((nbtData = stack.func_77978_p()) == null) {
                stack.func_77978_p().func_74768_a("points", 0);
            }
            nbtData.func_74768_a("points", health);
        }
    }
}

