/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.calculators;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.THashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.items.IResearchStore;
import sonar.calculator.mod.common.entities.EntityGrenade;
import sonar.calculator.mod.common.item.calculators.SonarCalculator;
import sonar.calculator.mod.common.recipes.RecipeRegistry;
import sonar.core.common.item.InventoryItem;
import sonar.core.helpers.FontHelper;
import sonar.core.inventory.IItemInventory;

public class FlawlessCalc
extends SonarCalculator
implements IItemInventory,
IResearchStore {
    private static final int FlawlessCraft = 0;
    private static final int DynamicCraft = 1;
    private static final int Crafting = 2;
    private static final int Grenade = 3;
    private static final int Ender = 4;
    private static final int Teleport = 5;

    public InventoryItem getInventory(ItemStack stack) {
        NBTTagCompound nbtData = stack.func_77978_p();
        if (nbtData == null) {
            nbtData = new NBTTagCompound();
            stack.func_77982_d(nbtData);
        }
        int mode = nbtData.func_74762_e("Mode");
        switch (mode) {
            case 0: {
                return new FlawlessInventory(stack);
            }
            case 1: {
                return new DynamicInventory(stack);
            }
            case 2: {
                return new CraftingInventory(stack);
            }
        }
        return null;
    }

    public FlawlessCalc() {
        this.capacity = 1000000;
        this.maxReceive = 1000000;
        this.maxExtract = 1000000;
        this.maxTransfer = 1000000;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        NBTTagCompound nbtData = stack.func_77978_p();
        if (nbtData == null) {
            nbtData = new NBTTagCompound();
            stack.func_77982_d(nbtData);
        }
        list.add(FontHelper.translate((String)"calc.mode") + ": " + this.chat(stack, player));
        int storedItems = new FlawlessInventory(stack).getItemsStored(stack) + new DynamicInventory(stack).getItemsStored(stack) + new CraftingInventory(stack).getItemsStored(stack);
        if (storedItems != 0) {
            list.add(FontHelper.translate((String)"calc.storedstacks") + ": " + storedItems);
        }
        if (stack.func_77942_o()) {
            int max = stack.func_77978_p().func_74762_e("Max");
            int stored = stack.func_77978_p().func_74762_e("Stored");
            if (max != 0) {
                list.add(FontHelper.translate((String)"research.recipe") + ": " + stored + "/" + max);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound nbtData = stack.func_77978_p();
        if (nbtData == null) {
            nbtData = new NBTTagCompound();
            stack.func_77982_d(nbtData);
        }
        int mode = nbtData.func_74762_e("Mode");
        if (player.func_70093_af()) {
            mode = (mode + 1) % 6;
            nbtData.func_74768_a("Mode", mode);
            nbtData.func_74757_a("Grenade", false);
            if (!world.field_72995_K) {
                FontHelper.sendMessage((String)this.chat(stack, player), (World)world, (EntityPlayer)player);
            }
        } else {
            switch (mode) {
                case 0: {
                    if (world.field_72995_K) break;
                    player.openGui((Object)Calculator.instance, 5, world, -1000, -1000, -1000);
                    break;
                }
                case 1: {
                    if (world.field_72995_K) break;
                    player.openGui((Object)Calculator.instance, 35, world, -1000, -1000, -1000);
                    break;
                }
                case 2: {
                    if (world.field_72995_K) break;
                    player.openGui((Object)Calculator.instance, 36, world, -1000, -1000, -1000);
                    break;
                }
                case 3: {
                    if (CalculatorConfig.enableGrenades) {
                        if (!world.field_72995_K && player.field_71075_bZ.field_75098_d) {
                            this.explosion(stack, world, player);
                            break;
                        }
                        if (this.getEnergyStored(stack) >= 10000) {
                            this.explosion(stack, world, player);
                            this.extractEnergy(stack, 10000, false);
                            break;
                        }
                        if (this.getEnergyStored(stack) > 10000 || world.field_72995_K) break;
                        player.func_146105_b((IChatComponent)new ChatComponentText(FontHelper.translate((String)"energy.notEnough")));
                        break;
                    }
                    FontHelper.sendMessage((String)FontHelper.translate((String)"calc.ban"), (World)world, (EntityPlayer)player);
                    break;
                }
                case 4: {
                    if (player.field_71075_bZ.field_75098_d) {
                        this.ender(world, player);
                        break;
                    }
                    if (this.getEnergyStored(stack) >= 10000) {
                        this.ender(world, player);
                        this.extractEnergy(stack, 10000, false);
                        break;
                    }
                    if (this.getEnergyStored(stack) > 10000 || world.field_72995_K) break;
                    player.func_146105_b((IChatComponent)new ChatComponentText(FontHelper.translate((String)"energy.notEnough")));
                    break;
                }
                case 5: {
                    this.teleport(player, world, stack);
                }
            }
        }
        return super.func_77659_a(stack, world, player);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (world.func_147439_a(x, y, z) != Calculator.stablestoneBlock) {
            return false;
        }
        int mode = stack.func_77978_p().func_74762_e("Mode");
        if (world.func_147439_a(x, y, z) == Calculator.stablestoneBlock && stack.func_77942_o() && mode == 5) {
            if (world.func_147439_a(x, y, z) == Calculator.stablestoneBlock && !stack.func_77978_p().func_74767_n("Tele")) {
                stack.func_77978_p().func_74780_a("TeleX", (double)x - 0.5);
                stack.func_77978_p().func_74780_a("TeleY", (double)(y + 1));
                stack.func_77978_p().func_74780_a("TeleZ", (double)z - 0.5);
                stack.func_77978_p().func_74757_a("Tele", true);
                stack.func_77978_p().func_74768_a("Dimension", player.field_71093_bK);
                if (!world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(FontHelper.translate((String)"calc.position")));
                }
            } else if (world.func_147439_a(x, y, z) == Calculator.stablestoneBlock && stack.func_77978_p().func_74767_n("Tele") && world.func_147439_a((int)stack.func_77978_p().func_74769_h("TeleX"), (int)stack.func_77978_p().func_74769_h("TeleY") - 1, (int)stack.func_77978_p().func_74769_h("TeleZ")) != Calculator.stablestoneBlock) {
                stack.func_77978_p().func_74780_a("TeleX", (double)x + 0.5);
                stack.func_77978_p().func_74780_a("TeleY", (double)(y + 1));
                stack.func_77978_p().func_74780_a("TeleZ", (double)z + 0.5);
                stack.func_77978_p().func_74757_a("Tele", true);
                stack.func_77978_p().func_74768_a("Dimension", player.field_71093_bK);
                if (!world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(FontHelper.translate((String)"calc.position")));
                }
            }
        }
        return false;
    }

    public void teleport(EntityPlayer player, World world, ItemStack stack) {
        if (player.field_71093_bK == stack.func_77978_p().func_74762_e("Dimension")) {
            if (stack.func_77978_p().func_74767_n("Tele")) {
                Block target = world.func_147439_a((int)(stack.func_77978_p().func_74769_h("TeleX") - 0.5), (int)stack.func_77978_p().func_74769_h("TeleY") - 1, (int)(stack.func_77978_p().func_74769_h("TeleZ") - 0.5));
                if (target == Calculator.stablestoneBlock) {
                    player.func_70634_a(stack.func_77978_p().func_74769_h("TeleX"), stack.func_77978_p().func_74769_h("TeleY"), stack.func_77978_p().func_74769_h("TeleZ"));
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText(FontHelper.translate((String)"calc.stableStone")));
                }
            } else if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(FontHelper.translate((String)"calc.noPosition")));
            }
        }
        if (!world.field_72995_K && player.field_71093_bK != stack.func_77978_p().func_74762_e("Dimension")) {
            player.func_146105_b((IChatComponent)new ChatComponentText(FontHelper.translate((String)"calc.dimension")));
        }
    }

    public int currentEnergy(ItemStack itemstack) {
        return this.getEnergyStored(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
        this.field_77791_bV = iconregister.func_94245_a("Calculator:flawlesscalculator");
    }

    public void ender(World world, EntityPlayer player) {
        world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityEnderPearl(world, (EntityLivingBase)player));
        }
    }

    public void explosion(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77978_p().func_74767_n("Grenade")) {
            world.func_72956_a((Entity)player, "random.fizz", 0.7f, 0.8f);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityGrenade(world, (EntityLivingBase)player));
            }
            stack.func_77978_p().func_74757_a("Grenade", false);
        } else {
            if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText(FontHelper.translate((String)"calc.grenade")));
            }
            stack.func_77978_p().func_74757_a("Grenade", true);
        }
    }

    public String chat(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbtData = stack.func_77978_p();
        int current = nbtData.func_74762_e("Mode");
        if (current == 0) {
            return FontHelper.translate((String)"flawless.mode1");
        }
        if (current == 1) {
            return FontHelper.translate((String)"flawless.mode2");
        }
        if (current == 2) {
            return FontHelper.translate((String)"flawless.mode3");
        }
        if (current == 3) {
            return FontHelper.translate((String)"flawless.mode4");
        }
        if (current == 4) {
            return FontHelper.translate((String)"flawless.mode5");
        }
        if (current == 5) {
            return FontHelper.translate((String)"flawless.mode6");
        }
        return FontHelper.translate((String)"flawless.mode");
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public int getMode(ItemStack stack) {
        NBTTagCompound nbtData = stack.func_77978_p();
        if (nbtData == null) {
            nbtData = new NBTTagCompound();
            stack.func_77982_d(nbtData);
        }
        return nbtData.func_74762_e("Mode");
    }

    @Override
    public Map<Integer, Integer> getResearch(ItemStack stack) {
        Object unblocked = new THashMap();
        if (stack != null && stack.func_77973_b() instanceof IResearchStore) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            unblocked = RecipeRegistry.CalculatorRecipes.instance().readFromNBT(stack.func_77978_p(), "unblocked");
        }
        return unblocked;
    }

    @Override
    public void setResearch(ItemStack stack, Map<Integer, Integer> unblocked, int stored, int max) {
        if (stack != null && stack.func_77973_b() == Calculator.itemCalculator) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            RecipeRegistry.CalculatorRecipes.instance().writeToNBT(stack.func_77978_p(), unblocked, "unblocked");
            stack.func_77978_p().func_74768_a("Max", max);
            stack.func_77978_p().func_74768_a("Stored", stored);
        }
    }

    public static class CraftingInventory
    extends InventoryItem {
        public static final int size = 10;

        public CraftingInventory(ItemStack stack) {
            super(stack, 10, "CraftingInv");
        }
    }

    public static class DynamicInventory
    extends InventoryItem {
        public static final int size = 10;

        public DynamicInventory(ItemStack stack) {
            super(stack, 10, "DynamicInv");
        }
    }

    public static class FlawlessInventory
    extends InventoryItem {
        public static final int size = 5;

        public FlawlessInventory(ItemStack stack) {
            super(stack, 5, "FlawlessInv");
        }
    }
}

