/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.generators;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.tileentity.generators.TileEntityGenerator;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.BlockInteraction;

public class ExtractorBlock
extends SonarMachineBlock {
    public int type;

    public ExtractorBlock(int type) {
        super(SonarMaterials.machine);
        this.disableOrientation();
        this.type = type;
        this.func_149676_a(0.0625f, 0.0625f, 0.0625f, 0.9375f, 0.9375f, 0.9375f);
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    public boolean operateBlock(World world, int x, int y, int z, EntityPlayer player, BlockInteraction interact) {
        if (player != null && !world.field_72995_K) {
            switch (this.type) {
                case 0: {
                    player.openGui((Object)Calculator.instance, 28, world, x, y, z);
                    break;
                }
                case 1: {
                    player.openGui((Object)Calculator.instance, 30, world, x, y, z);
                    break;
                }
                case 2: {
                    player.openGui((Object)Calculator.instance, 29, world, x, y, z);
                }
            }
        }
        return true;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        TileEntityGenerator generator = (TileEntityGenerator)world.func_147438_o(x, y, z);
        generator.updateAdjacentHandlers();
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (tileentity != null && tileentity instanceof TileEntityGenerator) {
            TileEntityGenerator generator = (TileEntityGenerator)world.func_147438_o(x, y, z);
            generator.updateAdjacentHandlers();
        }
    }

    public TileEntity func_149915_a(World world, int var) {
        switch (this.type) {
            case 0: {
                return new TileEntityGenerator.StarchExtractor();
            }
            case 1: {
                return new TileEntityGenerator.RedstoneExtractor();
            }
            case 2: {
                return new TileEntityGenerator.GlowstoneExtractor();
            }
        }
        return new TileEntityGenerator.StarchExtractor();
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List list) {
        CalculatorHelper.addEnergytoToolTip(stack, player, list);
        CalculatorHelper.addItemLevelToolTip(stack, player, list);
    }

    public void standardInfo(ItemStack stack, EntityPlayer player, List list) {
        switch (this.type) {
            case 0: {
                list.add(FontHelper.translate((String)"energy.generate") + ": " + CalculatorConfig.getInteger("Starch Extractor") + " RF/t");
                break;
            }
            case 1: {
                list.add(FontHelper.translate((String)"energy.generate") + ": " + CalculatorConfig.getInteger("Redstone Extractor") + " RF/t");
                break;
            }
            case 2: {
                list.add(FontHelper.translate((String)"energy.generate") + ": " + CalculatorConfig.getInteger("Glowstone Extractor") + " RF/t");
            }
        }
    }
}

