/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.generators;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.api.blocks.IStableBlock;
import sonar.calculator.mod.common.tileentity.generators.TileEntityCalculatorLocator;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.SonarCore;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.utils.BlockInteraction;

public class CalculatorLocator
extends SonarMachineBlock {
    public CalculatorLocator() {
        super(SonarMaterials.machine);
        this.disableOrientation();
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    public boolean hasSpecialRenderer() {
        return true;
    }

    public boolean operateBlock(World world, int x, int y, int z, EntityPlayer player, BlockInteraction interact) {
        if (player != null && !world.field_72995_K) {
            TileEntity locator = world.func_147438_o(x, y, z);
            if (locator != null) {
                SonarCore.sendFullSyncAround((TileEntity)locator, (int)64);
            }
            player.openGui((Object)Calculator.instance, 32, world, x, y, z);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntityCalculatorLocator te = (TileEntityCalculatorLocator)world.func_147438_o(x, y, z);
        if (((Boolean)te.active.getObject()).booleanValue()) {
            float x1 = (float)x + random.nextFloat();
            float y1 = (float)y + 0.5f;
            float z1 = (float)z + random.nextFloat();
            world.func_72869_a("smoke", (double)x1, (double)y1, (double)z1, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)x1, (double)y1, (double)z1, 0.0, 0.0, 0.0);
        }
    }

    public static int multiBlockStructure(World world, int x, int y, int z) {
        for (int size = 1; size < 12; ++size) {
            if (!CalculatorLocator.checkSize(world, x, y, z, size)) continue;
            return size;
        }
        return 0;
    }

    public static boolean checkSize(World world, int x, int y, int z, int size) {
        int Z;
        int X;
        for (X = -size; X <= size; ++X) {
            for (Z = -size; Z <= size; ++Z) {
                if (X == 0 && Z == 0 || world.func_147439_a(x + X, y - 1, z + Z) instanceof IStableBlock) continue;
                return false;
            }
        }
        for (int XZ = -size; XZ <= size; ++XZ) {
            for (int Y = -1; Y <= 0; ++Y) {
                if (!(world.func_147439_a(x + XZ, y + Y, z + size + 1) instanceof IStableBlock)) {
                    return false;
                }
                if (!(world.func_147439_a(x + XZ, y + Y, z - (size + 1)) instanceof IStableBlock)) {
                    return false;
                }
                if (!(world.func_147439_a(x + (size + 1), y + Y, z + XZ) instanceof IStableBlock)) {
                    return false;
                }
                if (world.func_147439_a(x - (size + 1), y + Y, z + XZ) instanceof IStableBlock) continue;
                return false;
            }
        }
        for (X = -size; X <= size; ++X) {
            for (Z = -size; Z <= size; ++Z) {
                if (X == 0 && Z == 0 || world.func_147439_a(x + X, y, z + Z) == Calculator.calculatorplug) continue;
                return false;
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityCalculatorLocator();
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List list) {
        CalculatorHelper.addEnergytoToolTip(stack, player, list);
    }
}

