/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.item.misc.UpgradeCircuit;
import sonar.calculator.mod.common.tileentity.TileEntityAbstractProcess;
import sonar.calculator.mod.common.tileentity.TileEntityMachine;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.common.block.SonarMachineBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.FontHelper;
import sonar.core.utils.BlockInteraction;

public class SmeltingBlock
extends SonarMachineBlock {
    @SideOnly(value=Side.CLIENT)
    private IIcon front;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontActive;
    @SideOnly(value=Side.CLIENT)
    private IIcon front2;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontActive2;
    @SideOnly(value=Side.CLIENT)
    private IIcon slot1;
    @SideOnly(value=Side.CLIENT)
    private IIcon slot2;
    public int type;

    public SmeltingBlock(int num) {
        super(SonarMaterials.machine);
        this.type = num;
    }

    public boolean func_149662_c() {
        return this.type == 4 || this.type == 5 || this.type == 7;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        switch (this.type) {
            case 4: {
                this.front = iconRegister.func_94245_a("Calculator:stoneseperator_still_front1");
                this.front2 = iconRegister.func_94245_a("Calculator:stoneseperator_still_front2");
                this.frontActive = iconRegister.func_94245_a("Calculator:stoneseperator_animate_front1");
                this.frontActive2 = iconRegister.func_94245_a("Calculator:stoneseperator_animate_front2");
                this.slot1 = iconRegister.func_94245_a("Calculator:stoneseperator_slot1");
                this.slot2 = iconRegister.func_94245_a("Calculator:stoneseperator_slot2");
                break;
            }
            case 5: {
                this.front = iconRegister.func_94245_a("Calculator:algorithmseperator1_slot1");
                this.front2 = iconRegister.func_94245_a("Calculator:algorithmseperator1_slot2");
                this.frontActive = iconRegister.func_94245_a("Calculator:algorithmseperatoranimate_front1");
                this.frontActive2 = iconRegister.func_94245_a("Calculator:algorithmseperatoranimate_front2");
                this.slot1 = iconRegister.func_94245_a("Calculator:algorithmseperator_slot1");
                this.slot2 = iconRegister.func_94245_a("Calculator:algorithmseperator_slot2");
                break;
            }
            case 7: {
                this.front = iconRegister.func_94245_a("Calculator:reinforced_furnace");
                this.front2 = iconRegister.func_94245_a("Calculator:reinforced_furnace2");
                this.frontActive = iconRegister.func_94245_a("Calculator:reinforced_furnace_active");
                this.frontActive2 = iconRegister.func_94245_a("Calculator:reinforced_furnace2_active");
                this.slot1 = iconRegister.func_94245_a("Calculator:stoneseperator_slot2");
                this.slot2 = iconRegister.func_94245_a("Calculator:stoneseperator_slot1");
            }
        }
        if (this.type < 4 || this.type == 6) {
            this.front = iconRegister.func_94245_a("Calculator:overlays/machine_input");
            this.front2 = iconRegister.func_94245_a("Calculator:overlays/machine_output");
            this.frontActive = iconRegister.func_94245_a("Calculator:overlays/machine_input");
            this.frontActive2 = iconRegister.func_94245_a("Calculator:overlays/machine_output");
            this.slot1 = iconRegister.func_94245_a("Calculator:overlays/machine_input");
            this.slot2 = iconRegister.func_94245_a("Calculator:overlays/machine_output");
            this.field_149761_L = this.type == 6 || this.type == 3 ? iconRegister.func_94245_a("Calculator:analysis_side_slot1") : iconRegister.func_94245_a("Calculator:machine_side");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess access, int x, int y, int z, int side) {
        int metadata = access.func_72805_g(x, y, z);
        if (metadata == 0) {
            return this.func_149691_a(side, metadata);
        }
        TileEntity entity = access.func_147438_o(x, y, z);
        if (entity != null) {
            if (entity instanceof TileEntityAbstractProcess) {
                TileEntityAbstractProcess t = (TileEntityAbstractProcess)access.func_147438_o(x, y, z);
                if (side != metadata) {
                    return t.getBlockTexture(side, metadata) ? this.slot1 : this.slot2;
                }
                if (side == metadata) {
                    return t.isActive() ? (t.getBlockTexture(side, metadata) ? this.frontActive : this.frontActive2) : (t.getBlockTexture(side, metadata) ? this.front : this.front2);
                }
            } else if (entity instanceof TileEntityAbstractProcess) {
                TileEntityAbstractProcess t = (TileEntityAbstractProcess)access.func_147438_o(x, y, z);
                if (side != metadata) {
                    return t.getBlockTexture(side, metadata) ? this.slot1 : this.slot2;
                }
                if (side == metadata) {
                    return t.isActive() ? (t.getBlockTexture(side, metadata) ? this.frontActive : this.frontActive2) : (t.getBlockTexture(side, metadata) ? this.front : this.front2);
                }
            }
        }
        return this.slot1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.type < 4 || this.type == 6 ? this.field_149761_L : (side == metadata ? this.slot2 : (side == 0 ? this.slot1 : (side == 1 ? this.slot1 : (metadata == 0 && side == 3 ? this.front : this.slot1))));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null) {
            TileEntityAbstractProcess te;
            if (entity instanceof TileEntityAbstractProcess) {
                TileEntityAbstractProcess te2 = (TileEntityAbstractProcess)world.func_147438_o(x, y, z);
                if (te2.isActive()) {
                    this.spawnParticles(world, x, y, z, random);
                }
            } else if (entity instanceof TileEntityAbstractProcess && (te = (TileEntityAbstractProcess)world.func_147438_o(x, y, z)).isActive()) {
                this.spawnParticles(world, x, y, z, random);
            }
        }
    }

    public void spawnParticles(World world, int x, int y, int z, Random random) {
        int direction = world.func_72805_g(x, y, z);
        float x1 = (float)x + 0.5f;
        float y1 = (float)y + random.nextFloat();
        float z1 = (float)z + 0.5f;
        float f = 0.1f;
        float f1 = random.nextFloat() * 0.6f - 0.3f;
        if (direction == 4) {
            world.func_72869_a("smoke", (double)(x1 - f), (double)y1, (double)(z1 + f1), 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)(x1 - f), (double)y1, (double)(z1 + f1), 0.0, 0.0, 0.0);
        }
        if (direction == 5) {
            world.func_72869_a("smoke", (double)(x1 + f), (double)y1, (double)(z1 + f1), 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)(x1 + f), (double)y1, (double)(z1 + f1), 0.0, 0.0, 0.0);
        }
        if (direction == 2) {
            world.func_72869_a("smoke", (double)(x1 + f1), (double)y1, (double)(z1 - f), 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)(x1 + f1), (double)y1, (double)(z1 - f), 0.0, 0.0, 0.0);
        }
        if (direction == 3) {
            world.func_72869_a("smoke", (double)(x1 + f1), (double)y1, (double)(z1 + f), 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", (double)(x1 + f1), (double)y1, (double)(z1 + f), 0.0, 0.0, 0.0);
        }
    }

    public void openGui(World world, int x, int y, int z, EntityPlayer player) {
        switch (this.type) {
            case 0: {
                player.openGui((Object)Calculator.instance, 24, world, x, y, z);
                break;
            }
            case 1: {
                player.openGui((Object)Calculator.instance, 21, world, x, y, z);
                break;
            }
            case 2: {
                player.openGui((Object)Calculator.instance, 22, world, x, y, z);
                break;
            }
            case 3: {
                player.openGui((Object)Calculator.instance, 23, world, x, y, z);
                break;
            }
            case 4: {
                player.openGui((Object)Calculator.instance, 19, world, x, y, z);
                break;
            }
            case 5: {
                player.openGui((Object)Calculator.instance, 20, world, x, y, z);
                break;
            }
            case 6: {
                player.openGui((Object)Calculator.instance, 25, world, x, y, z);
                break;
            }
            case 7: {
                player.openGui((Object)Calculator.instance, 26, world, x, y, z);
            }
        }
    }

    public boolean operateBlock(World world, int x, int y, int z, EntityPlayer player, BlockInteraction interact) {
        if (player != null) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof UpgradeCircuit) {
                return false;
            }
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Calculator.wrench) {
                return false;
            }
            if (!world.field_72995_K) {
                this.openGui(world, x, y, z, player);
            }
            return true;
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int i) {
        switch (this.type) {
            case 0: {
                return new TileEntityMachine.ExtractionChamber();
            }
            case 1: {
                return new TileEntityMachine.RestorationChamber();
            }
            case 2: {
                return new TileEntityMachine.ReassemblyChamber();
            }
            case 3: {
                return new TileEntityMachine.ProcessingChamber();
            }
            case 4: {
                return new TileEntityMachine.StoneSeperator();
            }
            case 5: {
                return new TileEntityMachine.AlgorithmSeperator();
            }
            case 6: {
                return new TileEntityMachine.PrecisionChamber();
            }
            case 7: {
                return new TileEntityMachine.ReinforcedFurnace();
            }
        }
        return null;
    }

    public boolean dropStandard(World world, int x, int y, int z) {
        return false;
    }

    public void addSpecialToolTip(ItemStack stack, EntityPlayer player, List list) {
        CalculatorHelper.addEnergytoToolTip(stack, player, list);
    }

    public void standardInfo(ItemStack stack, EntityPlayer player, List list) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int energyUsage = 0;
            int speed = 0;
            switch (this.type) {
                case 0: {
                    energyUsage = CalculatorConfig.getInteger("Extraction ChamberEnergy Usage");
                    speed = CalculatorConfig.getInteger("Extraction ChamberBase Speed");
                    break;
                }
                case 1: {
                    energyUsage = CalculatorConfig.getInteger("Restoration ChamberEnergy Usage");
                    speed = CalculatorConfig.getInteger("Restoration ChamberBase Speed");
                    break;
                }
                case 2: {
                    energyUsage = CalculatorConfig.getInteger("Reassembly ChamberEnergy Usage");
                    speed = CalculatorConfig.getInteger("Reassembly ChamberBase Speed");
                    break;
                }
                case 3: {
                    energyUsage = CalculatorConfig.getInteger("Processing ChamberEnergy Usage");
                    speed = CalculatorConfig.getInteger("Processing ChamberBase Speed");
                    break;
                }
                case 4: {
                    energyUsage = CalculatorConfig.getInteger("Stone SeperatorEnergy Usage");
                    speed = CalculatorConfig.getInteger("Stone SeperatorBase Speed");
                    break;
                }
                case 5: {
                    energyUsage = CalculatorConfig.getInteger("Algorithm SeperatorEnergy Usage");
                    speed = CalculatorConfig.getInteger("Algorithm SeperatorBase Speed");
                    break;
                }
                case 6: {
                    energyUsage = CalculatorConfig.getInteger("Precision ChamberEnergy Usage");
                    speed = CalculatorConfig.getInteger("Precision ChamberBase Speed");
                    break;
                }
                case 7: {
                    energyUsage = CalculatorConfig.getInteger("Reinforced FurnaceEnergy Usage");
                    speed = CalculatorConfig.getInteger("Reinforced FurnaceBase Speed");
                }
            }
            list.add(FontHelper.translate((String)"Process Speed: ") + EnumChatFormatting.WHITE + speed + " ticks");
            list.add(FontHelper.translate((String)"Energy Usage: ") + EnumChatFormatting.WHITE + energyUsage + " RF per operation");
            list.add(FontHelper.translate((String)"Consumption: ") + EnumChatFormatting.WHITE + energyUsage / speed + " RF/t");
        } else {
            list.add("Hold shift for more info");
        }
    }
}

